/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchJavaTimeFieldCodec;

public class ElasticsearchMonthDayFieldCodec
extends AbstractElasticsearchJavaTimeFieldCodec<MonthDay> {
    private static final int LEAP_YEAR = 0;

    public ElasticsearchMonthDayFieldCodec(Gson gson, DateTimeFormatter delegate) {
        super(gson, delegate);
    }

    @Override
    protected String nullUnsafeFormat(MonthDay value) {
        LocalDate date = value.atYear(0);
        return this.formatter.format(date);
    }

    @Override
    protected MonthDay nullUnsafeParse(String stringValue) {
        LocalDate date = LocalDate.parse(stringValue, this.formatter);
        return MonthDay.from(date);
    }

    @Override
    protected Long nullUnsafeScalar(MonthDay value) {
        LocalDate date = value.atYear(0);
        return date.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}

