/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.deployers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ConcurrencyAttachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.concurrent.ConcurrentContext;
import org.jboss.as.ee.concurrent.ConcurrentContextInterceptor;
import org.jboss.as.ee.concurrent.ConcurrentContextSetupAction;
import org.jboss.as.ee.concurrent.handle.ClassLoaderContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.NamingContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.OtherEESetupActionsContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ThreadContextProviderContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.TransactionContextHandleFactory;
import org.jboss.as.ee.concurrent.service.ConcurrentContextService;
import org.jboss.as.ee.concurrent.service.ConcurrentServiceNames;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class EEConcurrentContextProcessor
implements DeploymentUnitProcessor {
    private static final String LOCAL_TRANSACTION_PROVIDER_CAPABILITY = "org.wildfly.transactions.global-default-local-provider";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (eeModuleDescription == null) {
            return;
        }
        CapabilityServiceSupport capabilityServiceSupport = (CapabilityServiceSupport)phaseContext.getDeploymentUnit().getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
        ServiceName localTransactionProviderCapabilityServiceName = capabilityServiceSupport.hasCapability(LOCAL_TRANSACTION_PROVIDER_CAPABILITY) ? capabilityServiceSupport.getCapabilityServiceName(LOCAL_TRANSACTION_PROVIDER_CAPABILITY) : null;
        this.processModuleDescription(eeModuleDescription, deploymentUnit, phaseContext, localTransactionProviderCapabilityServiceName);
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        if (componentDescriptions == null) {
            return;
        }
        HashMap additionalComponentFactories = new HashMap();
        deploymentUnit.putAttachment(ConcurrencyAttachments.ADDITIONAL_COMPONENT_FACTORIES, additionalComponentFactories);
        for (ComponentDescription componentDescription : componentDescriptions) {
            if (componentDescription.getNamingMode() == ComponentNamingMode.NONE) continue;
            this.processComponentDescription(componentDescription, localTransactionProviderCapabilityServiceName);
        }
    }

    private void processModuleDescription(EEModuleDescription moduleDescription, DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, ServiceName localTransactionProviderCapabilityServiceName) {
        ConcurrentContext concurrentContext = new ConcurrentContext();
        this.setupConcurrentContext(concurrentContext, moduleDescription.getApplicationName(), moduleDescription.getModuleName(), null, (ClassLoader)((Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE)).getClassLoader(), (NamespaceContextSelector)moduleDescription.getNamespaceContextSelector(), deploymentUnit, phaseContext.getServiceTarget(), localTransactionProviderCapabilityServiceName);
        ConcurrentContextSetupAction setupAction = new ConcurrentContextSetupAction(concurrentContext);
        deploymentUnit.putAttachment(ConcurrencyAttachments.CONCURRENT_CONTEXT_SETUP_ACTION, (Object)setupAction);
        deploymentUnit.addToAttachmentList(Attachments.WEB_SETUP_ACTIONS, (Object)setupAction);
    }

    private void processComponentDescription(ComponentDescription componentDescription, final ServiceName localTransactionProviderCapabilityServiceName) {
        ComponentConfigurator componentConfigurator = new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                ConcurrentContext concurrentContext = new ConcurrentContext();
                List additionalComponentFactories = (List)((Map)context.getDeploymentUnit().getAttachment(ConcurrencyAttachments.ADDITIONAL_COMPONENT_FACTORIES)).remove(configuration);
                if (additionalComponentFactories != null) {
                    for (ContextHandleFactory factory : additionalComponentFactories) {
                        concurrentContext.addFactory(factory);
                    }
                }
                EEConcurrentContextProcessor.this.setupConcurrentContext(concurrentContext, description.getApplicationName(), description.getModuleName(), description.getComponentName(), configuration.getModuleClassLoader(), configuration.getNamespaceContextSelector(), context.getDeploymentUnit(), context.getServiceTarget(), localTransactionProviderCapabilityServiceName);
                ConcurrentContextInterceptor interceptor = new ConcurrentContextInterceptor(concurrentContext);
                ImmediateInterceptorFactory interceptorFactory = new ImmediateInterceptorFactory((Interceptor)interceptor);
                configuration.addPostConstructInterceptor((InterceptorFactory)interceptorFactory, 384);
                configuration.addPreDestroyInterceptor((InterceptorFactory)interceptorFactory, 384);
                if (description.isPassivationApplicable()) {
                    configuration.addPrePassivateInterceptor((InterceptorFactory)interceptorFactory, 384);
                    configuration.addPostActivateInterceptor((InterceptorFactory)interceptorFactory, 384);
                }
                configuration.addComponentInterceptor((InterceptorFactory)interceptorFactory, 384, false);
            }
        };
        componentDescription.getConfigurators().add(componentConfigurator);
    }

    private void setupConcurrentContext(ConcurrentContext concurrentContext, String applicationName, String moduleName, String componentName, ClassLoader moduleClassLoader, NamespaceContextSelector namespaceContextSelector, DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, ServiceName localTransactionProviderCapabilityServiceName) {
        concurrentContext.addFactory(new NamingContextHandleFactory(namespaceContextSelector, deploymentUnit.getServiceName()));
        concurrentContext.addFactory(new ClassLoaderContextHandleFactory(moduleClassLoader));
        for (ContextHandleFactory contextHandleFactory : deploymentUnit.getAttachmentList(ConcurrencyAttachments.ADDITIONAL_FACTORIES)) {
            concurrentContext.addFactory(contextHandleFactory);
        }
        concurrentContext.addFactory(new OtherEESetupActionsContextHandleFactory(deploymentUnit.getAttachmentList(Attachments.OTHER_EE_SETUP_ACTIONS)));
        if (localTransactionProviderCapabilityServiceName != null) {
            concurrentContext.addFactory(new TransactionContextHandleFactory());
        }
        for (ContextHandleFactory contextHandleFactory : ThreadContextProviderContextHandleFactory.fromServiceLoader(moduleClassLoader)) {
            concurrentContext.addFactory(contextHandleFactory);
        }
        ConcurrentContextService service = new ConcurrentContextService(concurrentContext);
        ServiceName serviceName = ConcurrentServiceNames.getConcurrentContextServiceName(applicationName, moduleName, componentName);
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service);
        if (localTransactionProviderCapabilityServiceName != null) {
            serviceBuilder.requires(localTransactionProviderCapabilityServiceName);
        }
        serviceBuilder.install();
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        SetupAction action = (SetupAction)deploymentUnit.removeAttachment(ConcurrencyAttachments.CONCURRENT_CONTEXT_SETUP_ACTION);
        if (action != null) {
            deploymentUnit.getAttachmentList(Attachments.WEB_SETUP_ACTIONS).remove(action);
        }
        deploymentUnit.removeAttachment(ConcurrencyAttachments.ADDITIONAL_COMPONENT_FACTORIES);
    }
}

