# Contributing guide

**First off all, thank you for taking the time to contribute into WildFly!** The below contents will help you through the steps for getting started with WildFly. Please make sure to read the relevant section before making your contribution. It will make it a lot easier for us maintainers and smooth out the experience for all involved. The community looks forward to your contributions.

* Git Setup: https://github.com/wildfly/wildfly/blob/main/docs/src/main/asciidoc/_hacking/github_setup.adoc
* Contributing: https://github.com/wildfly/wildfly/blob/main/docs/src/main/asciidoc/_hacking/contributing.adoc
* Pull request standard: https://github.com/wildfly/wildfly/blob/main/docs/src/main/asciidoc/_hacking/pullrequest_standards.adoc

If you like our project, but just don’t have time to contribute, that’s fine. There are other easy ways to support the project and show your appreciation.

* Mention the project at local meetups and tell your friends/colleagues.
* Tweet about it and also check out our [twitter page](https://twitter.com/WildFlyAS) and [mastodon page](https://fosstodon.org/@wildflyas).
* Check out our [youtube](https://www.youtube.com/@WildFlyAS) contents.

# Issues

---

WildFly uses JIRA to manage issues. All issues can be found [here](https://issues.redhat.com/projects/WFLY/issues/).

To create a new issue, comment on an existing issue, or assign an issue to yourself, you'll need to first [create a JIRA account](https://issues.redhat.com/).

# Good First Issues

---

Check out our issues with the `good-first-issue` label. These are a triaged set of issues that are great for getting started on our project. These can be found [here](https://issues.redhat.com/issues/?filter=12403174).

Once you have selected an issue you'd like to work on, make sure it's not already assigned to someone else. To assign an issue to yourself, simply click on "Start Progress". This will automatically assign the issue to you. If you're not able to assign it to yourself that way, post a message in the [wildfly-developers Zulip stream](https://wildfly.zulipchat.com/#narrow/stream/174184-wildfly-developers) and someone will help get it assigned to you.

Lastly, this project is an open source project. Please act responsibly, be nice, polite and enjoy!