/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.function.Function;
import javax.transaction.xa.Xid;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.ByteInputs;
import org.wildfly.httpclient.common.ByteOutputs;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.HeadersHelper;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpServerHelper;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.transaction.Constants;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionMessages;
import org.wildfly.httpclient.transaction.RequestType;
import org.wildfly.httpclient.transaction.Serializer;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;

final class ServerHandlers {
    private final LocalTransactionContext ctx;
    private final Function<LocalTransaction, Xid> xidResolver;
    private final HttpServiceConfig config;

    private ServerHandlers(HttpServiceConfig config, LocalTransactionContext ctx, Function<LocalTransaction, Xid> xidResolver) {
        this.config = config;
        this.ctx = ctx;
        this.xidResolver = xidResolver;
    }

    static ServerHandlers newInstance(HttpServiceConfig config, LocalTransactionContext ctx, Function<LocalTransaction, Xid> xidResolver) {
        return new ServerHandlers(config, ctx, xidResolver);
    }

    HttpHandler handlerOf(RequestType requestType) {
        switch (requestType) {
            case UT_BEGIN: {
                return new BeginHandler(this.config, this.ctx, this.xidResolver);
            }
            case UT_COMMIT: {
                return new UTCommitHandler(this.config, this.ctx);
            }
            case UT_ROLLBACK: {
                return new UTRollbackHandler(this.config, this.ctx);
            }
            case XA_BEFORE_COMPLETION: {
                return new XABeforeCompletionHandler(this.config, this.ctx);
            }
            case XA_COMMIT: {
                return new XACommitHandler(this.config, this.ctx);
            }
            case XA_FORGET: {
                return new XAForgetHandler(this.config, this.ctx);
            }
            case XA_PREPARE: {
                return new XAPrepHandler(this.config, this.ctx);
            }
            case XA_RECOVER: {
                return new XARecoveryHandler(this.config, this.ctx);
            }
            case XA_ROLLBACK: {
                return new XARollbackHandler(this.config, this.ctx);
            }
        }
        throw new IllegalStateException();
    }

    private static final class XACommitHandler
    extends AbstractTransactionHandler {
        private XACommitHandler(HttpServiceConfig config, LocalTransactionContext ctx) {
            super(config, ctx);
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            Deque opc = (Deque)exchange.getQueryParameters().get("opc");
            boolean onePhase = false;
            if (opc != null && !opc.isEmpty()) {
                onePhase = Boolean.parseBoolean((String)opc.poll());
            }
            transaction.getControl().commit(onePhase);
        }
    }

    private static final class XARollbackHandler
    extends AbstractTransactionHandler {
        private XARollbackHandler(HttpServiceConfig config, LocalTransactionContext ctx) {
            super(config, ctx);
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().rollback();
        }
    }

    private static final class XAPrepHandler
    extends AbstractTransactionHandler {
        private XAPrepHandler(HttpServiceConfig config, LocalTransactionContext ctx) {
            super(config, ctx);
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().prepare();
        }
    }

    private static final class XAForgetHandler
    extends AbstractTransactionHandler {
        private XAForgetHandler(HttpServiceConfig config, LocalTransactionContext ctx) {
            super(config, ctx);
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().forget();
        }
    }

    private static final class XABeforeCompletionHandler
    extends AbstractTransactionHandler {
        private XABeforeCompletionHandler(HttpServiceConfig config, LocalTransactionContext ctx) {
            super(config, ctx);
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().beforeCompletion();
        }
    }

    private static final class UTCommitHandler
    extends AbstractTransactionHandler {
        private UTCommitHandler(HttpServiceConfig config, LocalTransactionContext ctx) {
            super(config, ctx);
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            ((LocalTransaction)transaction.getTransaction()).commit();
        }
    }

    private static final class UTRollbackHandler
    extends AbstractTransactionHandler {
        private UTRollbackHandler(HttpServiceConfig config, LocalTransactionContext ctx) {
            super(config, ctx);
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            ((LocalTransaction)transaction.getTransaction()).rollback();
        }
    }

    private static final class XARecoveryHandler
    extends ValidatingTransactionHandler {
        private XARecoveryHandler(HttpServiceConfig config, LocalTransactionContext ctx) {
            super(config, ctx);
        }

        @Override
        protected boolean isValidRequest(HttpServerExchange exchange) {
            String flagsStringString = HeadersHelper.getRequestHeader((HttpServerExchange)exchange, (HttpString)Constants.RECOVERY_FLAGS);
            if (flagsStringString == null) {
                exchange.setStatusCode(400);
                HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s is missing %s header", exchange, Constants.RECOVERY_FLAGS);
                return false;
            }
            String parentName = HeadersHelper.getRequestHeader((HttpServerExchange)exchange, (HttpString)Constants.RECOVERY_PARENT_NAME);
            if (parentName == null) {
                exchange.setStatusCode(400);
                HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s is missing %s header", exchange, Constants.RECOVERY_PARENT_NAME);
                return false;
            }
            return true;
        }

        @Override
        protected void processRequest(HttpServerExchange exchange) {
            try {
                ByteOutput byteOutput;
                String flagsStringString = HeadersHelper.getRequestHeader((HttpServerExchange)exchange, (HttpString)Constants.RECOVERY_FLAGS);
                int flags = Integer.parseInt(flagsStringString);
                String parentName = HeadersHelper.getRequestHeader((HttpServerExchange)exchange, (HttpString)Constants.RECOVERY_PARENT_NAME);
                Xid[] recoveryList = this.ctx.getRecoveryInterface().recover(flags, parentName);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (ByteOutput byteOutput2 = byteOutput = ByteOutputs.byteOutputOf((OutputStream)out);){
                    Marshaller marshaller = this.config.getHttpMarshallerFactory(exchange).createMarshaller();
                    marshaller.start(byteOutput);
                    Serializer.serializeXidArray((ObjectOutput)marshaller, recoveryList);
                    marshaller.finish();
                }
                exchange.getResponseSender().send(ByteBuffer.wrap(out.toByteArray()));
            }
            catch (Exception e) {
                HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)this.config, (int)500, (Throwable)e);
            }
        }
    }

    private static final class BeginHandler
    extends ValidatingTransactionHandler {
        private BeginHandler(HttpServiceConfig config, LocalTransactionContext ctx, Function<LocalTransaction, Xid> xidResolver) {
            super(config, ctx, xidResolver);
        }

        @Override
        protected boolean isValidRequest(HttpServerExchange exchange) {
            String timeoutString = HeadersHelper.getRequestHeader((HttpServerExchange)exchange, (HttpString)Constants.TIMEOUT);
            if (timeoutString == null) {
                exchange.setStatusCode(400);
                HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s is missing %s header", exchange, Constants.TIMEOUT);
                return false;
            }
            return true;
        }

        @Override
        protected void processRequest(HttpServerExchange exchange) {
            try {
                String timeoutString = HeadersHelper.getRequestHeader((HttpServerExchange)exchange, (HttpString)Constants.TIMEOUT);
                Integer timeout = Integer.parseInt(timeoutString);
                HeadersHelper.putResponseHeader((HttpServerExchange)exchange, (HttpString)Headers.CONTENT_TYPE, (ContentType)Constants.NEW_TRANSACTION);
                LocalTransaction transaction = this.ctx.beginTransaction(timeout.intValue());
                Xid xid = (Xid)this.xidResolver.apply(transaction);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Marshaller marshaller = this.config.getHttpMarshallerFactory(exchange).createMarshaller();
                try (ByteOutput out = ByteOutputs.byteOutputOf((OutputStream)baos);){
                    marshaller.start(out);
                    Serializer.serializeXid((ObjectOutput)marshaller, xid);
                    marshaller.finish();
                }
                exchange.getResponseSender().send(ByteBuffer.wrap(baos.toByteArray()));
            }
            catch (Exception e) {
                HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)this.config, (int)500, (Throwable)e);
            }
        }
    }

    private static abstract class AbstractTransactionHandler
    extends ValidatingTransactionHandler {
        private AbstractTransactionHandler(HttpServiceConfig config, LocalTransactionContext ctx) {
            super(config, ctx);
        }

        @Override
        protected boolean isValidRequest(HttpServerExchange exchange) {
            ContentType contentType = ContentType.parse((String)HeadersHelper.getRequestHeader((HttpServerExchange)exchange, (HttpString)Headers.CONTENT_TYPE));
            if (contentType == null || contentType.getVersion() != 1 || !contentType.getType().equals(Constants.XID.getType())) {
                exchange.setStatusCode(400);
                HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s has incorrect or missing content type", exchange);
                return false;
            }
            return true;
        }

        @Override
        protected void processRequest(HttpServerExchange exchange) {
            try {
                Xid simpleXid;
                HttpMarshallerFactory httpMarshallerFactory = this.config.getHttpUnmarshallerFactory(exchange);
                Unmarshaller unmarshaller = httpMarshallerFactory.createUnmarshaller();
                InputStream is = exchange.getInputStream();
                try (ByteInput in = ByteInputs.byteInputOf((InputStream)is);){
                    unmarshaller.start(in);
                    simpleXid = Serializer.deserializeXid((ObjectInput)unmarshaller);
                    unmarshaller.finish();
                }
                ImportResult transaction = this.ctx.findOrImportTransaction(simpleXid, 0);
                ((LocalTransaction)transaction.getTransaction()).performFunction((o, exchange2) -> {
                    this.handleImpl((HttpServerExchange)exchange2, (ImportResult<LocalTransaction>)o);
                    return null;
                }, (Object)transaction, (Object)exchange);
            }
            catch (Exception e) {
                HttpServerHelper.sendException((HttpServerExchange)exchange, (HttpServiceConfig)this.config, (int)500, (Throwable)e);
            }
        }

        protected abstract void handleImpl(HttpServerExchange var1, ImportResult<LocalTransaction> var2) throws Exception;
    }

    private static abstract class ValidatingTransactionHandler
    implements HttpHandler {
        protected final LocalTransactionContext ctx;
        protected final Function<LocalTransaction, Xid> xidResolver;
        protected final HttpServiceConfig config;

        private ValidatingTransactionHandler(HttpServiceConfig config, LocalTransactionContext ctx) {
            this(config, ctx, null);
        }

        private ValidatingTransactionHandler(HttpServiceConfig config, LocalTransactionContext ctx, Function<LocalTransaction, Xid> xidResolver) {
            this.config = config;
            this.ctx = ctx;
            this.xidResolver = xidResolver;
        }

        protected abstract boolean isValidRequest(HttpServerExchange var1);

        protected abstract void processRequest(HttpServerExchange var1);

        public final void handleRequest(HttpServerExchange exchange) throws Exception {
            if (this.isValidRequest(exchange)) {
                this.processRequest(exchange);
            }
        }
    }
}

