/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrar;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteredCacheServiceInstallerProvider;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;
import org.wildfly.clustering.singleton.compat.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.compat.SingletonServiceConfigurator;
import org.wildfly.clustering.singleton.compat.SingletonServiceTargetFactory;
import org.wildfly.clustering.singleton.election.SingletonElectionListener;
import org.wildfly.clustering.singleton.election.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.server.DefaultSingletonServiceBuilderContext;
import org.wildfly.clustering.singleton.server.DistributedSingletonServiceTarget;
import org.wildfly.clustering.singleton.server.LegacyDistributedSingletonService;
import org.wildfly.clustering.singleton.server.LegacySingletonServiceBuilder;
import org.wildfly.clustering.singleton.server.SingletonReference;
import org.wildfly.clustering.singleton.server.SingletonServiceBuilderContext;
import org.wildfly.clustering.singleton.server.SingletonServiceContext;
import org.wildfly.clustering.singleton.server.SingletonServiceTargetContext;
import org.wildfly.clustering.singleton.service.SingletonServiceConfiguratorFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceTarget;
import org.wildfly.common.function.Functions;
import org.wildfly.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class CacheSingletonServiceTargetFactoryServiceInstallerProvider
implements ClusteredCacheServiceInstallerProvider {
    public Iterable<ServiceInstaller> apply(BinaryServiceConfiguration configuration) {
        final ServiceDependency dispatcherFactory = ServiceDependency.on((ServiceName)configuration.resolveServiceName(ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY));
        final ServiceDependency registrar = ServiceDependency.on((ServiceName)configuration.resolveServiceName(ClusteringServiceDescriptor.SERVICE_PROVIDER_REGISTRAR)).map(ServiceProviderRegistrar.class::cast);
        final SingletonServiceTargetContext context = new SingletonServiceTargetContext(){

            public ServiceDependency<ServiceProviderRegistrar<ServiceName, GroupMember>> getServiceProviderRegistrarDependency() {
                return registrar;
            }

            public ServiceDependency<CommandDispatcherFactory<GroupMember>> getCommandDispatcherFactoryDependency() {
                return dispatcherFactory;
            }
        };
        final Function discardingSingletonFactory = new Function<ServiceBuilder<?>, Consumer<Singleton>>(){

            @Override
            public Consumer<Singleton> apply(ServiceBuilder<?> builder) {
                return Functions.discardingConsumer();
            }
        };
        SingletonServiceTargetFactory factory = new SingletonServiceTargetFactory(){

            public SingletonServiceTarget createSingletonServiceTarget(ServiceTarget target) {
                return new DistributedSingletonServiceTarget(target, context, discardingSingletonFactory);
            }

            @Deprecated
            public SingletonServiceConfigurator createSingletonServiceConfigurator(final ServiceName name) {
                DefaultSingletonServiceBuilderContext builderContext = new DefaultSingletonServiceBuilderContext(name, context);
                final Function singletonFactory = new Function<ServiceBuilder<?>, Consumer<Singleton>>(){

                    @Override
                    public Consumer<Singleton> apply(ServiceBuilder<?> builder) {
                        return builder.provides(new ServiceName[]{name.append(new String[]{"singleton"})});
                    }
                };
                return new SingletonServiceConfigurator(){
                    final /* synthetic */ SingletonServiceBuilderContext val$builderContext;
                    {
                        this.val$builderContext = singletonServiceBuilderContext;
                    }

                    public ServiceName getServiceName() {
                        return name;
                    }

                    public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<?> build(ServiceTarget target) {
                        return new DistributedSingletonServiceTarget(target, context, singletonFactory).addService(name).requireQuorum(this.val$builderContext.getQuorum()).withElectionListener(this.val$builderContext.getElectionListener()).withElectionPolicy(this.val$builderContext.getElectionPolicy());
                    }

                    public SingletonServiceConfigurator withElectionPolicy(SingletonElectionPolicy policy) {
                        this.val$builderContext.setElectionPolicy(policy);
                        return this;
                    }

                    public SingletonServiceConfigurator withElectionListener(SingletonElectionListener listener) {
                        this.val$builderContext.setElectionListener(listener);
                        return this;
                    }

                    public SingletonServiceConfigurator requireQuorum(int quorum) {
                        this.val$builderContext.setQuorum(quorum);
                        return this;
                    }
                };
            }

            @Deprecated
            public <T> SingletonServiceBuilder<T> createSingletonServiceBuilder(ServiceName name, Service<T> service) {
                return this.createSingletonServiceBuilder(name, service, (Service<T>)null);
            }

            @Deprecated
            public <T> SingletonServiceBuilder<T> createSingletonServiceBuilder(final ServiceName name, Service<T> primaryService, Service<T> backupService) {
                DefaultSingletonServiceBuilderContext builderContext = new DefaultSingletonServiceBuilderContext(name, context);
                return new SingletonServiceBuilder<T>((SingletonServiceBuilderContext)builderContext, primaryService, backupService){
                    final /* synthetic */ SingletonServiceBuilderContext val$builderContext;
                    final /* synthetic */ Service val$primaryService;
                    final /* synthetic */ Service val$backupService;
                    {
                        this.val$builderContext = singletonServiceBuilderContext;
                        this.val$primaryService = service;
                        this.val$backupService = service2;
                    }

                    public ServiceName getServiceName() {
                        return name;
                    }

                    public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> build(ServiceTarget target) {
                        SingletonReference reference = new SingletonReference();
                        LegacyDistributedSingletonService service = new LegacyDistributedSingletonService((SingletonServiceContext)this.val$builderContext, this.val$primaryService, this.val$backupService, (Consumer)reference);
                        return new LegacySingletonServiceBuilder((Supplier)reference, this.val$builderContext, target.addService(name, (Service)service));
                    }

                    public SingletonServiceBuilder<T> withElectionPolicy(SingletonElectionPolicy policy) {
                        this.val$builderContext.setElectionPolicy(policy);
                        return this;
                    }

                    public SingletonServiceBuilder<T> withElectionListener(SingletonElectionListener listener) {
                        this.val$builderContext.setElectionListener(listener);
                        return this;
                    }

                    public SingletonServiceBuilder<T> requireQuorum(int quorum) {
                        this.val$builderContext.setQuorum(quorum);
                        return this;
                    }
                };
            }
        };
        return List.of((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Object)factory).provides(configuration.resolveServiceName(org.wildfly.clustering.singleton.service.SingletonServiceTargetFactory.SERVICE_DESCRIPTOR))).provides(configuration.resolveServiceName(SingletonServiceConfiguratorFactory.SERVICE_DESCRIPTOR))).provides(configuration.resolveServiceName(SingletonServiceBuilderFactory.SERVICE_DESCRIPTOR))).build());
    }
}

