/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jgroups.BatchMessage;
import org.jgroups.BytesMessage;
import org.jgroups.CompositeMessage;
import org.jgroups.EmptyMessage;
import org.jgroups.FragmentedMessage;
import org.jgroups.LongMessage;
import org.jgroups.Message;
import org.jgroups.NioMessage;
import org.jgroups.ObjectMessage;

public class MessageFactory {
    protected static final byte MIN_TYPE = 32;
    protected static final Supplier<? extends Message>[] creators = new Supplier[32];
    protected static Map<Short, Supplier<? extends Message>> map = new HashMap<Short, Supplier<? extends Message>>();

    public static <T extends Message> T create(short type) {
        Supplier<? extends Message> creator;
        Supplier<? extends Message> supplier = creator = type < 32 ? creators[type] : map.get(type);
        if (creator == null) {
            throw new IllegalArgumentException("no creator found for type " + type);
        }
        return (T)creator.get();
    }

    public static void register(short type, Supplier<? extends Message> generator) {
        Objects.requireNonNull(generator, "the creator must be non-null");
        if (type < 32) {
            throw new IllegalArgumentException(String.format("type (%d) must be >= 32", type));
        }
        if (map.containsKey(type)) {
            throw new IllegalArgumentException(String.format("type %d is already taken", type));
        }
        map.put(type, generator);
    }

    static {
        MessageFactory.creators[0] = BytesMessage::new;
        MessageFactory.creators[1] = NioMessage::new;
        MessageFactory.creators[2] = EmptyMessage::new;
        MessageFactory.creators[3] = ObjectMessage::new;
        MessageFactory.creators[4] = LongMessage::new;
        MessageFactory.creators[5] = CompositeMessage::new;
        MessageFactory.creators[6] = FragmentedMessage::new;
        MessageFactory.creators[7] = BatchMessage::new;
    }
}

