/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.internal.NamedNativeQueryDefinitionImpl;
import org.hibernate.boot.query.AbstractNamedQueryBuilder;
import org.hibernate.boot.query.NamedNativeQueryDefinition;

public class NamedNativeQueryDefinitionBuilder
extends AbstractNamedQueryBuilder<NamedNativeQueryDefinitionBuilder> {
    private String sqlString;
    private String resultSetMappingName;
    private String resultSetMappingClassName;
    private Set<String> querySpaces;
    private Map<String, String> parameterTypes;
    private Integer firstResult;
    private Integer maxResults;

    public NamedNativeQueryDefinitionBuilder(String name) {
        super(name);
    }

    public NamedNativeQueryDefinitionBuilder setSqlString(String sqlString) {
        this.sqlString = sqlString;
        return this.getThis();
    }

    public NamedNativeQueryDefinitionBuilder setFirstResult(Integer firstResult) {
        this.firstResult = firstResult;
        return this.getThis();
    }

    public NamedNativeQueryDefinitionBuilder setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this.getThis();
    }

    public NamedNativeQueryDefinition build() {
        return new NamedNativeQueryDefinitionImpl(this.getName(), this.sqlString, this.resultSetMappingName, this.resultSetMappingClassName, this.getQuerySpaces(), this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.firstResult, this.maxResults, this.getHints());
    }

    @Override
    protected NamedNativeQueryDefinitionBuilder getThis() {
        return this;
    }

    public String getSqlString() {
        return this.sqlString;
    }

    public Set<String> getQuerySpaces() {
        return this.querySpaces;
    }

    public Map<String, String> getParameterTypes() {
        return this.parameterTypes == null ? Collections.emptyMap() : this.parameterTypes;
    }

    public String getResultSetMappingName() {
        return this.resultSetMappingName;
    }

    public String getResultSetMappingClassName() {
        return this.resultSetMappingClassName;
    }

    public NamedNativeQueryDefinitionBuilder addSynchronizedQuerySpace(String space) {
        if (this.querySpaces == null) {
            this.querySpaces = new HashSet<String>();
        }
        this.querySpaces.add(space);
        return this.getThis();
    }

    public NamedNativeQueryDefinitionBuilder setQuerySpaces(Set<String> spaces) {
        this.querySpaces = spaces;
        return this;
    }

    public NamedNativeQueryDefinitionBuilder setResultSetMappingName(String resultSetMappingName) {
        this.resultSetMappingName = resultSetMappingName;
        return this;
    }

    public NamedNativeQueryDefinitionBuilder setResultSetMappingClassName(String resultSetMappingClassName) {
        this.resultSetMappingClassName = resultSetMappingClassName;
        return this;
    }

    public void addParameterTypeHint(String name, String type) {
        if (this.parameterTypes == null) {
            this.parameterTypes = new HashMap<String, String>();
        }
        this.parameterTypes.put(name, type);
    }
}

