/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.MutationStatementPreparer;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.resource.jdbc.spi.JdbcObserver;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;

public class MutationStatementPreparerImpl
implements MutationStatementPreparer {
    private final JdbcCoordinatorImpl jdbcCoordinator;
    private final JdbcServices jdbcServices;

    public MutationStatementPreparerImpl(JdbcCoordinatorImpl jdbcCoordinator, JdbcServices jdbcServices) {
        this.jdbcCoordinator = jdbcCoordinator;
        this.jdbcServices = jdbcServices;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, boolean isCallable) {
        return this.buildPreparedStatementPreparationTemplate(sql, isCallable).prepareStatement();
    }

    private StatementPreparationTemplate buildPreparedStatementPreparationTemplate(String sql, final boolean isCallable) {
        return new StatementPreparationTemplate(sql){

            @Override
            protected PreparedStatement doPrepare() throws SQLException {
                return isCallable ? MutationStatementPreparerImpl.this.connection().prepareCall(this.sql) : MutationStatementPreparerImpl.this.connection().prepareStatement(this.sql);
            }
        };
    }

    @Override
    public PreparedStatement prepareStatement(String sql, final int autoGeneratedKeys) {
        if (autoGeneratedKeys == 1) {
            this.checkAutoGeneratedKeysSupportEnabled();
        }
        return new StatementPreparationTemplate(sql){

            @Override
            public PreparedStatement doPrepare() throws SQLException {
                return MutationStatementPreparerImpl.this.connection().prepareStatement(this.sql, autoGeneratedKeys);
            }
        }.prepareStatement();
    }

    private void checkAutoGeneratedKeysSupportEnabled() {
        if (!this.settings().isGetGeneratedKeysEnabled()) {
            throw new AssertionFailure("getGeneratedKeys() support is not enabled");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, final String[] columnNames) {
        this.checkAutoGeneratedKeysSupportEnabled();
        return new StatementPreparationTemplate(sql){

            @Override
            public PreparedStatement doPrepare() throws SQLException {
                return MutationStatementPreparerImpl.this.connection().prepareStatement(this.sql, columnNames);
            }
        }.prepareStatement();
    }

    protected final Connection connection() {
        return this.logicalConnection().getPhysicalConnection();
    }

    protected final LogicalConnectionImplementor logicalConnection() {
        return this.jdbcCoordinator.getLogicalConnection();
    }

    protected final SqlExceptionHelper sqlExceptionHelper() {
        return this.jdbcServices.getSqlExceptionHelper();
    }

    protected final JdbcSessionContext settings() {
        return this.jdbcCoordinator.getJdbcSessionOwner().getJdbcSessionContext();
    }

    private abstract class StatementPreparationTemplate {
        protected final String sql;

        protected StatementPreparationTemplate(String incomingSql) {
            String inspectedSql = MutationStatementPreparerImpl.this.jdbcCoordinator.getJdbcSessionOwner().getJdbcSessionContext().getStatementInspector().inspect(incomingSql);
            this.sql = inspectedSql == null ? incomingSql : inspectedSql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PreparedStatement prepareStatement() {
            try {
                PreparedStatement preparedStatement;
                JdbcSessionOwner jdbcSessionOwner = MutationStatementPreparerImpl.this.jdbcCoordinator.getJdbcSessionOwner();
                JdbcObserver observer = jdbcSessionOwner.getJdbcSessionContext().getObserver();
                EventManager eventManager = jdbcSessionOwner.getEventManager();
                HibernateMonitoringEvent jdbcPreparedStatementCreation = eventManager.beginJdbcPreparedStatementCreationEvent();
                try {
                    observer.jdbcPrepareStatementStart();
                    preparedStatement = this.doPrepare();
                    this.setStatementTimeout(preparedStatement);
                }
                finally {
                    eventManager.completeJdbcPreparedStatementCreationEvent(jdbcPreparedStatementCreation, this.sql);
                    observer.jdbcPrepareStatementEnd();
                }
                this.postProcess(preparedStatement);
                return preparedStatement;
            }
            catch (SQLException e) {
                throw MutationStatementPreparerImpl.this.sqlExceptionHelper().convert(e, "could not prepare statement", this.sql);
            }
        }

        protected abstract PreparedStatement doPrepare() throws SQLException;

        public void postProcess(PreparedStatement preparedStatement) throws SQLException {
            MutationStatementPreparerImpl.this.jdbcCoordinator.getLogicalConnection().getResourceRegistry().register(preparedStatement, true);
        }

        private void setStatementTimeout(PreparedStatement preparedStatement) throws SQLException {
            int remainingTransactionTimeOutPeriod = MutationStatementPreparerImpl.this.jdbcCoordinator.determineRemainingTransactionTimeOutPeriod();
            if (remainingTransactionTimeOutPeriod > 0) {
                preparedStatement.setQueryTimeout(remainingTransactionTimeOutPeriod);
            }
        }
    }
}

