/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintUtilization;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AccessConstraintAppliesToResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"applies-to");
    public static final AttributeDefinition ADDRESS = new SimpleAttributeDefinitionBuilder("address", ModelType.STRING).build();
    public static final AttributeDefinition ENTIRE_RESOURCE = new SimpleAttributeDefinitionBuilder("entire-resource", ModelType.BOOLEAN).build();
    public static final AttributeDefinition ATTRIBUTES = new SimpleListAttributeDefinition.Builder("attributes", (AttributeDefinition)new SimpleAttributeDefinitionBuilder("attribute", ModelType.STRING).build()).build();
    public static final AttributeDefinition OPERATIONS = new SimpleListAttributeDefinition.Builder("operations", (AttributeDefinition)new SimpleAttributeDefinitionBuilder("operation", ModelType.STRING).build()).build();

    public AccessConstraintAppliesToResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, DomainManagementResolver.getResolver("core.access-control.constraint.applies-to")).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(ADDRESS, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute(ENTIRE_RESOURCE, (OperationStepHandler)new EntireResourceHandler());
        resourceRegistration.registerReadOnlyAttribute(ATTRIBUTES, (OperationStepHandler)new AttributesHandler());
        resourceRegistration.registerReadOnlyAttribute(OPERATIONS, (OperationStepHandler)new OperationsHandler());
    }

    static Resource.ResourceEntry createResource(AccessConstraintUtilization constraintUtilization) {
        return new AccessConstraintAppliesToResource(constraintUtilization);
    }

    private static class EntireResourceHandler
    extends AccessConstraintAppliesToHandler {
        private EntireResourceHandler() {
        }

        @Override
        void setResult(OperationContext context, AccessConstraintUtilization constraintUtilization) {
            context.getResult().set(constraintUtilization.isEntireResourceConstrained());
        }
    }

    private static class AttributesHandler
    extends StringSetHandler {
        private AttributesHandler() {
        }

        @Override
        Set<String> getStringSet(AccessConstraintUtilization constraintUtilization) {
            if (constraintUtilization.isEntireResourceConstrained()) {
                return Collections.emptySet();
            }
            return constraintUtilization.getAttributes();
        }
    }

    private static class OperationsHandler
    extends StringSetHandler {
        private OperationsHandler() {
        }

        @Override
        Set<String> getStringSet(AccessConstraintUtilization constraintUtilization) {
            if (constraintUtilization.isEntireResourceConstrained()) {
                return Collections.emptySet();
            }
            return constraintUtilization.getOperations();
        }
    }

    private static class AccessConstraintAppliesToResource
    extends PlaceholderResource.PlaceholderResourceEntry {
        private final AccessConstraintUtilization constraintUtilization;

        private AccessConstraintAppliesToResource(AccessConstraintUtilization constraintUtilization) {
            super(PathElement.pathElement((String)"applies-to", (String)constraintUtilization.getPathAddress().toCLIStyleString()));
            this.constraintUtilization = constraintUtilization;
        }
    }

    private static abstract class StringSetHandler
    extends AccessConstraintAppliesToHandler {
        private StringSetHandler() {
        }

        @Override
        void setResult(OperationContext context, AccessConstraintUtilization constraintUtilization) {
            ModelNode result = context.getResult();
            result.setEmptyList();
            for (String attribute : this.getStringSet(constraintUtilization)) {
                result.add(attribute);
            }
        }

        abstract Set<String> getStringSet(AccessConstraintUtilization var1);
    }

    private static abstract class AccessConstraintAppliesToHandler
    implements OperationStepHandler {
        private AccessConstraintAppliesToHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            AccessConstraintAppliesToResource resource = (AccessConstraintAppliesToResource)context.readResource(PathAddress.EMPTY_ADDRESS);
            this.setResult(context, resource.constraintUtilization);
        }

        abstract void setResult(OperationContext var1, AccessConstraintUtilization var2);
    }
}

