/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

public class ModularLongRangeParameterValidator
extends LongRangeValidator {
    private final long moduleSize;

    public ModularLongRangeParameterValidator(long moduleSize, long min) {
        super(min);
        this.moduleSize = moduleSize;
    }

    public ModularLongRangeParameterValidator(long moduleSize, long min, boolean nullable) {
        super(min, nullable);
        this.moduleSize = moduleSize;
    }

    public ModularLongRangeParameterValidator(long moduleSize, long min, long max, boolean nullable, boolean allowExpressions) {
        super(min, max, nullable, allowExpressions);
        this.moduleSize = moduleSize;
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        long val;
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION && (val = value.asLong()) % this.moduleSize != 0L) {
            throw MessagingLogger.ROOT_LOGGER.invalidModularParameterValue(val, parameterName, this.moduleSize);
        }
    }
}

