/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.data.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.Throwables;

public final class KeyValueProvider<K, V> {
    private final Map<K, ? extends V> content;
    private final BiFunction<? super K, ? super Set<K>, SearchException> singleMissingValueExceptionFactory;
    private final BiFunction<? super Set<K>, ? super Set<K>, SearchException> multiMissingValueExceptionFactory;

    public static <K, V> KeyValueProvider<K, V> create(Map<K, ? extends V> content, BiFunction<? super K, ? super Set<K>, SearchException> missingValueExceptionFactory) {
        return new KeyValueProvider<K, V>(content, missingValueExceptionFactory, KeyValueProvider.toMultiMissingValue(missingValueExceptionFactory));
    }

    public static <K, V> KeyValueProvider<K, V> create(Map<K, ? extends V> content, BiFunction<? super K, ? super Set<K>, SearchException> singleMissingValueExceptionFactory, BiFunction<? super Set<K>, ? super Set<K>, SearchException> multiMissingValueExceptionFactory) {
        return new KeyValueProvider<K, V>(content, singleMissingValueExceptionFactory, multiMissingValueExceptionFactory);
    }

    public static <K, V> KeyValueProvider<K, V> createWithMultiKeyException(Map<K, ? extends V> content, BiFunction<? super Set<K>, ? super Set<K>, SearchException> missingValueExceptionFactory) {
        return new KeyValueProvider<K, V>(content, KeyValueProvider.toSingleMissingValue(missingValueExceptionFactory), missingValueExceptionFactory);
    }

    private static <K> BiFunction<K, Set<K>, SearchException> toSingleMissingValue(BiFunction<? super Set<K>, ? super Set<K>, SearchException> missingValueExceptionFactory) {
        return (invalidKey, allValidKeys) -> (SearchException)missingValueExceptionFactory.apply((Object)Set.of(invalidKey), (Object)allValidKeys);
    }

    private static <K> BiFunction<Set<K>, Set<K>, SearchException> toMultiMissingValue(BiFunction<? super K, ? super Set<K>, SearchException> singleMissingValueExceptionFactory) {
        return (invalidKeys, allValidKeys) -> {
            SearchException exception = null;
            for (Object invalidKey : invalidKeys) {
                exception = Throwables.combine(exception, (SearchException)singleMissingValueExceptionFactory.apply((Object)invalidKey, (Object)allValidKeys));
            }
            return exception;
        };
    }

    public KeyValueProvider(Map<K, ? extends V> content, BiFunction<? super K, ? super Set<K>, SearchException> singleMissingValueExceptionFactory) {
        this(content, singleMissingValueExceptionFactory, KeyValueProvider.toMultiMissingValue(singleMissingValueExceptionFactory));
    }

    private KeyValueProvider(Map<K, ? extends V> content, BiFunction<? super K, ? super Set<K>, SearchException> singleMissingValueExceptionFactory, BiFunction<? super Set<K>, ? super Set<K>, SearchException> multiMissingValueExceptionFactory) {
        this.content = Collections.unmodifiableMap(content);
        this.singleMissingValueExceptionFactory = singleMissingValueExceptionFactory;
        this.multiMissingValueExceptionFactory = multiMissingValueExceptionFactory;
    }

    public V getOrFail(K key) {
        V result = this.content.get(key);
        if (result == null) {
            throw this.singleMissingValueExceptionFactory.apply(key, this.content.keySet());
        }
        return result;
    }

    public List<V> getAllOrFail(Collection<? extends K> keys) {
        return this.getAllOrFail(keys, (k, v) -> v);
    }

    public <V2> List<V2> getAllOrFail(Collection<? extends K> keys, BiFunction<K, V, V2> transform) {
        ArrayList<V2> result = new ArrayList<V2>();
        LinkedHashSet<K> missing = null;
        for (K key : keys) {
            V value = this.content.get(key);
            if (value == null) {
                if (missing == null) {
                    missing = new LinkedHashSet<K>();
                }
                missing.add(key);
                continue;
            }
            result.add(transform.apply(key, value));
        }
        if (missing != null) {
            throw this.multiMissingValueExceptionFactory.apply(missing, this.content.keySet());
        }
        return result;
    }

    public Optional<? extends V> getOptional(K key) {
        return Optional.ofNullable(this.content.get(key));
    }

    public V getOrNull(K key) {
        return this.content.get(key);
    }

    public Set<K> keys() {
        return this.content.keySet();
    }

    public Collection<? extends V> values() {
        return this.content.values();
    }
}

