/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

final class ResourceAdapterService
implements Service<Activation> {
    private final Activation value;
    private final String name;
    private final InjectedValue<ResourceAdaptersService.ModifiableResourceAdaptors> resourceAdapters = new InjectedValue();
    private final InjectedValue<ResourceAdaptersSubsystemService> resourceAdaptersSubsystemService = new InjectedValue();

    public ResourceAdapterService(ModifiableResourceAdapter value, String name) {
        this.value = value;
        this.name = name;
    }

    public Activation getValue() throws IllegalStateException {
        return this.value;
    }

    public void start(StartContext context) throws StartException {
        ((ResourceAdaptersService.ModifiableResourceAdaptors)this.resourceAdapters.getValue()).addActivation(this.value);
        ((ResourceAdaptersSubsystemService)this.resourceAdaptersSubsystemService.getValue()).getAdapters().putIfAbsent(this.value.getArchive(), ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{this.name}));
        ConnectorLogger.SUBSYSTEM_RA_LOGGER.debugf("Starting ResourceAdapter Service", new Object[0]);
    }

    public void stop(StopContext context) {
        ((ResourceAdaptersService.ModifiableResourceAdaptors)this.resourceAdapters.getValue()).removeActivation(this.value);
        ((ResourceAdaptersSubsystemService)this.resourceAdaptersSubsystemService.getValue()).getAdapters().remove(this.value.getArchive());
        ConnectorLogger.SUBSYSTEM_RA_LOGGER.debugf("Stopping ResourceAdapter Service", new Object[0]);
    }

    public Injector<ResourceAdaptersService.ModifiableResourceAdaptors> getResourceAdaptersInjector() {
        return this.resourceAdapters;
    }

    public Injector<ResourceAdaptersSubsystemService> getResourceAdaptersSubsystemInjector() {
        return this.resourceAdaptersSubsystemService;
    }
}

