/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.Collections;
import java.util.Set;
import org.aesh.command.export.ExportManager;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.terminal.utils.Config;

public class DefaultAeshContext
implements AeshContext {
    private Resource cwd;
    private final ExportManager exportManager;

    public DefaultAeshContext() {
        this(new FileResource("").newInstance(Config.getUserDir()), null);
    }

    public DefaultAeshContext(Resource cwd) {
        this(cwd, null);
    }

    public DefaultAeshContext(Resource cwd, ExportManager exportManager) {
        if (cwd == null || cwd.isLeaf() || !cwd.exists()) {
            throw new IllegalArgumentException("Current working directory must be a directory");
        }
        this.cwd = cwd;
        this.exportManager = exportManager;
    }

    public DefaultAeshContext(ExportManager exportManager) {
        this(new FileResource("").newInstance(Config.getUserDir()), exportManager);
    }

    @Override
    public Resource getCurrentWorkingDirectory() {
        return this.cwd;
    }

    @Override
    public void setCurrentWorkingDirectory(Resource cwd) {
        if (cwd.isLeaf()) {
            throw new IllegalArgumentException("Current working directory must be a directory");
        }
        this.cwd = cwd;
    }

    @Override
    public Set<String> exportedVariableNames() {
        if (this.exportManager != null) {
            return this.exportManager.keys();
        }
        return Collections.emptySet();
    }

    @Override
    public String exportedVariable(String key) {
        if (this.exportManager != null) {
            return this.exportManager.getValue(key);
        }
        return null;
    }
}

