/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.Iterator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public interface ModelNodeFormatter {
    public static final int OFFSET = 2;
    public static final ModelNodeFormatterBase DEFAULT = new ModelNodeFormatterBase(){

        @Override
        public void formatDefined(StringBuilder buf, int newLineOffset, ModelNode value) {
            buf.append(value.toString());
        }
    };
    public static final ModelNodeFormatterBase BOOLEAN = new ModelNodeFormatterBase(){

        @Override
        public void formatDefined(StringBuilder buf, int newLineOffset, ModelNode value) {
            buf.append(value.asBoolean());
        }
    };
    public static final ModelNodeFormatterBase STRING = new ModelNodeFormatterBase(){

        @Override
        public void formatDefined(StringBuilder buf, int newLineOffset, ModelNode value) {
            buf.append(value.asString());
        }
    };
    public static final ModelNodeFormatterBase LIST = new ModelNodeFormatterBase(){

        @Override
        void formatDefined(StringBuilder buf, int newLineOffset, ModelNode value) {
            Iterator<ModelNode> iterator = value.asList().iterator();
            if (iterator.hasNext()) {
                int i;
                ModelNode item = iterator.next();
                ModelNodeFormatterBase formatter = Factory.forType(item.getType());
                if (formatter == LIST) {
                    formatter.format(buf, newLineOffset + 2, item);
                } else {
                    if (newLineOffset > 0) {
                        for (i = 0; i < newLineOffset; ++i) {
                            buf.append(' ');
                        }
                    }
                    formatter.format(buf, newLineOffset, item);
                }
                while (iterator.hasNext()) {
                    item = iterator.next();
                    formatter = Factory.forType(item.getType());
                    buf.append('\n');
                    if (formatter == LIST) {
                        formatter.format(buf, newLineOffset + 2, item);
                        continue;
                    }
                    if (newLineOffset > 0) {
                        for (i = 0; i < newLineOffset; ++i) {
                            buf.append(' ');
                        }
                    }
                    formatter.format(buf, newLineOffset, item);
                }
            }
        }
    };
    public static final ModelNodeFormatterBase PROPERTY = new ModelNodeFormatterBase(){

        @Override
        void formatDefined(StringBuilder buf, int newLineOffset, ModelNode value) {
            Property prop = value.asProperty();
            buf.append(prop.getName());
            ModelNode propValue = prop.getValue();
            ModelNodeFormatterBase formatter = Factory.forType(propValue.getType());
            if (formatter == LIST) {
                buf.append('\n');
                formatter.format(buf, newLineOffset + 2, propValue);
            } else {
                buf.append('=');
                formatter.format(buf, newLineOffset, propValue);
            }
        }
    };

    public void format(StringBuilder var1, int var2, ModelNode var3);

    public static abstract class ModelNodeFormatterBase
    implements ModelNodeFormatter {
        @Override
        public void format(StringBuilder buf, int newLineOffset, ModelNode value) {
            if (value == null) {
                buf.append("null");
            } else if (!value.isDefined()) {
                buf.append("n/a");
            } else {
                this.formatDefined(buf, newLineOffset, value);
            }
        }

        abstract void formatDefined(StringBuilder var1, int var2, ModelNode var3);
    }

    public static class Factory {
        public static ModelNodeFormatterBase forType(ModelType type) {
            if (type == ModelType.STRING) {
                return STRING;
            }
            if (type == ModelType.BOOLEAN) {
                return BOOLEAN;
            }
            if (type == ModelType.OBJECT || type == ModelType.LIST) {
                return LIST;
            }
            if (type == ModelType.PROPERTY) {
                return PROPERTY;
            }
            return DEFAULT;
        }
    }
}

