/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoContainedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingPlanImpl;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingPlanStrategy;
import org.hibernate.search.mapper.pojo.work.impl.PojoLoadingPlanProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexingPlanIndexDelegate;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

public class PojoIndexingPlanLocalStrategy
implements PojoIndexingPlanStrategy {
    final DocumentCommitStrategy commitStrategy;
    final DocumentRefreshStrategy refreshStrategy;

    public PojoIndexingPlanLocalStrategy(DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.commitStrategy = commitStrategy;
        this.refreshStrategy = refreshStrategy;
    }

    @Override
    public boolean shouldResolveDirtyForDeleteOnly() {
        return false;
    }

    @Override
    public CompletableFuture<MultiEntityOperationExecutionReport> doExecuteAndReport(Collection<PojoIndexedTypeIndexingPlan<?, ?>> indexedTypeDelegates, PojoLoadingPlanProvider loadingPlanProvider, OperationSubmitter operationSubmitter) {
        ArrayList<CompletableFuture<MultiEntityOperationExecutionReport>> futures = new ArrayList<CompletableFuture<MultiEntityOperationExecutionReport>>();
        for (PojoIndexedTypeIndexingPlan<?, ?> delegate : indexedTypeDelegates) {
            futures.add(delegate.executeAndReport(operationSubmitter));
        }
        return MultiEntityOperationExecutionReport.allOf(futures);
    }

    @Override
    public void doDiscard(Collection<PojoIndexedTypeIndexingPlan<?, ?>> indexedTypeDelegates) {
        for (PojoIndexedTypeIndexingPlan<?, ?> delegate : indexedTypeDelegates) {
            delegate.discard();
        }
    }

    @Override
    public <I, E> PojoIndexedTypeIndexingPlan<I, E> createIndexedDelegate(PojoWorkIndexedTypeContext<I, E> typeContext, PojoWorkSessionContext sessionContext, PojoIndexingPlanImpl root) {
        IndexIndexingPlan indexIndexingPlan = typeContext.createIndexingPlan(sessionContext, this.commitStrategy, this.refreshStrategy);
        return new PojoIndexedTypeIndexingPlan<I, E>(typeContext, sessionContext, root, new PojoTypeIndexingPlanIndexDelegate<I, E>(typeContext, sessionContext, root, indexIndexingPlan));
    }

    @Override
    public <I, E> PojoContainedTypeIndexingPlan<I, E> createDelegate(PojoWorkContainedTypeContext<I, E> typeContext, PojoWorkSessionContext sessionContext, PojoIndexingPlanImpl root) {
        return new PojoContainedTypeIndexingPlan<I, E>(typeContext, sessionContext, root, null);
    }
}

