/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module.descriptor;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.as.controller.client.helpers.JBossModulesNameUtil;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.MountedDeploymentOverlay;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.server.deployment.module.descriptor.JBossAllXmlParserAdaptor;
import org.jboss.as.server.deployment.module.descriptor.ModuleStructureSpec;
import org.jboss.as.server.deployment.module.descriptor.ParseResult;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class JBossDeploymentStructureParser13
implements XMLElementReader<ParseResult> {
    public static final String NAMESPACE_1_3 = "urn:jboss:deployment-structure:1.3";
    public static final JBossDeploymentStructureParser13 INSTANCE = new JBossDeploymentStructureParser13();
    static final JBossAllXMLParser<ParseResult> JBOSS_ALL_XML_PARSER = new JBossAllXmlParserAdaptor(INSTANCE);

    private JBossDeploymentStructureParser13() {
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult result) throws XMLStreamException {
        boolean deploymentVisited = false;
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case EAR_SUBDEPLOYMENTS_ISOLATED: {
                            String value = reader.getElementText();
                            if (value == null || value.isEmpty()) {
                                result.setEarSubDeploymentsIsolated(true);
                                continue block11;
                            }
                            result.setEarSubDeploymentsIsolated(Boolean.valueOf(value));
                            continue block11;
                        }
                        case EAR_EXCLUSIONS_CASCADED_TO_SUBDEPLOYMENTS: {
                            String cascaded = reader.getElementText();
                            if (cascaded == null || cascaded.isEmpty()) {
                                result.setEarExclusionsCascadedToSubDeployments(false);
                                continue block11;
                            }
                            result.setEarExclusionsCascadedToSubDeployments(Boolean.valueOf(cascaded));
                            continue block11;
                        }
                        case DEPLOYMENT: {
                            if (deploymentVisited) {
                                throw JBossDeploymentStructureParser13.unexpectedContent((XMLStreamReader)reader);
                            }
                            deploymentVisited = true;
                            JBossDeploymentStructureParser13.parseDeployment((XMLStreamReader)reader, result);
                            continue block11;
                        }
                        case SUB_DEPLOYMENT: {
                            JBossDeploymentStructureParser13.parseSubDeployment((XMLStreamReader)reader, result);
                            continue block11;
                        }
                        case MODULE: {
                            JBossDeploymentStructureParser13.parseModule((XMLStreamReader)reader, result);
                            continue block11;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent((XMLStreamReader)reader);
        }
        throw JBossDeploymentStructureParser13.endOfDocument(reader.getLocation());
    }

    private static void parseDeployment(XMLStreamReader reader, ParseResult result) throws XMLStreamException {
        result.setRootDeploymentSpecification(new ModuleStructureSpec());
        JBossDeploymentStructureParser13.parseModuleStructureSpec(result.getDeploymentUnit(), reader, result.getRootDeploymentSpecification(), result.getModuleLoader());
    }

    private static void parseSubDeployment(XMLStreamReader reader, ParseResult result) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        if (result.getSubDeploymentSpecifications().containsKey(name)) {
            throw ServerLogger.ROOT_LOGGER.duplicateSubdeploymentListing(name);
        }
        ModuleStructureSpec moduleSpecification = new ModuleStructureSpec();
        result.getSubDeploymentSpecifications().put(name, moduleSpecification);
        JBossDeploymentStructureParser13.parseModuleStructureSpec(result.getDeploymentUnit(), reader, moduleSpecification, result.getModuleLoader());
    }

    private static void parseModule(XMLStreamReader reader, ParseResult result) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        if (!name.startsWith("deployment.")) {
            throw ServerLogger.ROOT_LOGGER.invalidModuleName(name);
        }
        ModuleStructureSpec moduleSpecification = new ModuleStructureSpec();
        moduleSpecification.setModuleName(ModuleIdentifierUtil.canonicalModuleIdentifier((String)name, slot));
        result.getAdditionalModules().add(moduleSpecification);
        JBossDeploymentStructureParser13.parseModuleStructureSpec(result.getDeploymentUnit(), reader, moduleSpecification, result.getModuleLoader());
    }

    private static void parseModuleStructureSpec(DeploymentUnit deploymentUnit, XMLStreamReader reader, ModuleStructureSpec moduleSpec, ModuleLoader moduleLoader) throws XMLStreamException {
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (visited.contains((Object)element)) {
                        throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EXPORTS: {
                            JBossDeploymentStructureParser13.parseFilterList(reader, moduleSpec.getExportFilters());
                            continue block14;
                        }
                        case DEPENDENCIES: {
                            JBossDeploymentStructureParser13.parseDependencies(reader, moduleSpec, moduleLoader);
                            continue block14;
                        }
                        case RESOURCES: {
                            JBossDeploymentStructureParser13.parseResources(deploymentUnit, reader, moduleSpec);
                            continue block14;
                        }
                        case TRANSFORMERS: {
                            JBossDeploymentStructureParser13.parseTransformers(reader, moduleSpec);
                            continue block14;
                        }
                        case EXCLUSIONS: {
                            JBossDeploymentStructureParser13.parseExclusions(reader, moduleSpec);
                            continue block14;
                        }
                        case LOCAL_LAST: {
                            JBossDeploymentStructureParser13.parseLocalLast(reader, moduleSpec);
                            continue block14;
                        }
                        case MODULE_ALIAS: {
                            JBossDeploymentStructureParser13.parseModuleAlias(reader, moduleSpec);
                            continue block14;
                        }
                        case EXCLUDE_SUBSYSTEMS: {
                            JBossDeploymentStructureParser13.parseExcludeSubsystem(reader, moduleSpec);
                            continue block14;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser13.endOfDocument(reader.getLocation());
    }

    private static void parseModuleAlias(XMLStreamReader reader, ModuleStructureSpec moduleSpec) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    moduleSpec.addAlias(JBossModulesNameUtil.canonicalModuleIdentifier(name, slot));
                    return;
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser13.endOfDocument(reader.getLocation());
    }

    private static void parseDependencies(XMLStreamReader reader, ModuleStructureSpec specBuilder, ModuleLoader moduleLoader) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MODULE: {
                            JBossDeploymentStructureParser13.parseModuleDependency(reader, specBuilder, moduleLoader);
                            continue block8;
                        }
                        case SYSTEM: {
                            JBossDeploymentStructureParser13.parseSystemDependency(reader, specBuilder);
                            continue block8;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser13.endOfDocument(reader.getLocation());
    }

    private static void parseSystemDependency(XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        boolean export = false;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case EXPORT: {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block11;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        Set<Object> paths = Collections.emptySet();
        MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder((boolean)export);
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (export) {
                        exportBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        exportBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    PathFilter exportFilter = exportBuilder.create();
                    specBuilder.addSystemDependency(DependencySpec.createSystemDependencySpec((PathFilter)PathFilters.getDefaultImportFilter(), (PathFilter)exportFilter, paths));
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PATHS: {
                            paths = JBossDeploymentStructureParser13.parseSet(reader);
                            break block3;
                        }
                        case EXPORTS: {
                            JBossDeploymentStructureParser13.parseFilterList(reader, exportBuilder);
                            break block3;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
    }

    private static void parseSet(XMLStreamReader reader, boolean include, MultiplePathFilterBuilder builder) throws XMLStreamException {
        builder.addFilter(PathFilters.in(JBossDeploymentStructureParser13.parseSet(reader)), include);
    }

    private static Set<String> parseSet(XMLStreamReader reader) throws XMLStreamException {
        HashSet<String> set = new HashSet<String>();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return set;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PATH: {
                            JBossDeploymentStructureParser13.parsePathName(reader, set);
                        }
                    }
                }
            }
        }
        return set;
    }

    private static void parseFilterList(XMLStreamReader reader, MultiplePathFilterBuilder builder) throws XMLStreamException {
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case INCLUDE: {
                            JBossDeploymentStructureParser13.parsePath(reader, true, builder);
                            continue block10;
                        }
                        case EXCLUDE: {
                            JBossDeploymentStructureParser13.parsePath(reader, false, builder);
                            continue block10;
                        }
                        case INCLUDE_SET: {
                            JBossDeploymentStructureParser13.parseSet(reader, true, builder);
                            continue block10;
                        }
                        case EXCLUDE_SET: {
                            JBossDeploymentStructureParser13.parseSet(reader, false, builder);
                            continue block10;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser13.endOfDocument(reader.getLocation());
    }

    private static void parsePath(XMLStreamReader reader, boolean include, MultiplePathFilterBuilder builder) throws XMLStreamException {
        boolean literal;
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        boolean bl = literal = path.indexOf(42) == -1 && path.indexOf(63) == -1;
        if (literal) {
            if (path.charAt(path.length() - 1) == '/') {
                builder.addFilter(PathFilters.isChildOf((String)path), include);
            } else {
                builder.addFilter(PathFilters.is((String)path), include);
            }
        } else {
            builder.addFilter(PathFilters.match((String)path), include);
        }
        JBossDeploymentStructureParser13.parseNoContent(reader);
    }

    private static void parseModuleDependency(XMLStreamReader reader, ModuleStructureSpec specBuilder, ModuleLoader moduleLoader) throws XMLStreamException {
        String name = null;
        String slot = null;
        boolean export = false;
        boolean optional = false;
        boolean annotations = false;
        Disposition services = Disposition.NONE;
        Disposition metaInf = Disposition.NONE;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block21: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block21;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block21;
                }
                case EXPORT: {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block21;
                }
                case SERVICES: {
                    services = Disposition.of(reader.getAttributeValue(i));
                    continue block21;
                }
                case OPTIONAL: {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block21;
                }
                case ANNOTATIONS: {
                    annotations = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block21;
                }
                case META_INF: {
                    metaInf = Disposition.of(reader.getAttributeValue(i));
                    continue block21;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        String identifier = ModuleIdentifierUtil.canonicalModuleIdentifier(name, slot);
        ModuleDependency dependency = ModuleDependency.Builder.of(moduleLoader, identifier).setOptional(optional).setExport(export).setImportServices(services == Disposition.IMPORT).setUserSpecified(true).build();
        if (annotations) {
            specBuilder.addAnnotationModule(identifier);
        }
        switch (metaInf) {
            case EXPORT: {
                dependency.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
                dependency.addExportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
                dependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
                dependency.addExportFilter(PathFilters.getMetaInfFilter(), true);
                break;
            }
            case IMPORT: {
                dependency.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
                dependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
            }
        }
        specBuilder.addModuleDependency(dependency);
        block22: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (services == Disposition.EXPORT) {
                        dependency.addExportFilter(PathFilters.getMetaInfServicesFilter(), true);
                    }
                    if (export) {
                        dependency.addExportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        dependency.addExportFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    if (dependency.getImportFilters().isEmpty()) {
                        dependency.addImportFilter(services == Disposition.NONE ? PathFilters.getDefaultImportFilter() : PathFilters.getDefaultImportFilterWithServices(), true);
                    } else {
                        if (services != Disposition.NONE) {
                            dependency.addImportFilter(PathFilters.getMetaInfServicesFilter(), true);
                        }
                        dependency.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        dependency.addImportFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case EXPORTS: {
                            JBossDeploymentStructureParser13.parseFilterList(reader, dependency.getExportFilters());
                            continue block22;
                        }
                        case IMPORTS: {
                            JBossDeploymentStructureParser13.parseFilterList(reader, dependency.getImportFilters());
                            continue block22;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
    }

    private static void parseResources(DeploymentUnit deploymentUnit, XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case RESOURCE_ROOT: {
                            JBossDeploymentStructureParser13.parseResourceRoot(deploymentUnit, reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser13.endOfDocument(reader.getLocation());
    }

    private static void parseResourceRoot(DeploymentUnit deploymentUnit, XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        String name = null;
        String path = null;
        boolean usePhysicalCodeSource = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block15;
                }
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block15;
                }
                case USE_PHYSICAL_CODE_SOURCE: {
                    usePhysicalCodeSource = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block15;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        if (name == null) {
            name = path;
        }
        ArrayList<FilterSpecification> resourceFilters = new ArrayList<FilterSpecification>();
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block16: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    try {
                        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
                        VirtualFile deploymentRootFile = deploymentRoot.getRoot();
                        VirtualFile child = deploymentRootFile.getChild(path);
                        Map<String, MountedDeploymentOverlay> overlays = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_OVERLAY_LOCATIONS);
                        MountedDeploymentOverlay overlay = overlays.get(path);
                        Closeable closable = null;
                        if (overlay != null) {
                            overlay.remountAsZip(false);
                        } else if (child.isFile()) {
                            closable = VFS.mountZip((File)child.getPhysicalFile(), (VirtualFile)child, (TempFileProvider)TempFileProviderService.provider());
                        }
                        MountHandle mountHandle = MountHandle.create(closable);
                        ResourceRoot resourceRoot = new ResourceRoot(name, child, mountHandle);
                        for (FilterSpecification filter : resourceFilters) {
                            resourceRoot.getExportFilters().add(filter);
                        }
                        resourceRoot.setUsePhysicalCodeSource(usePhysicalCodeSource);
                        specBuilder.addResourceRoot(resourceRoot);
                    }
                    catch (ZipException e) {
                        throw ServerLogger.ROOT_LOGGER.archiveMountFailed(path, e);
                    }
                    catch (IOException e) {
                        throw new XMLStreamException(e);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (!encountered.add(element)) {
                        throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                    }
                    switch (element) {
                        case FILTER: {
                            JBossDeploymentStructureParser13.parseFilterList(reader, resourceFilters);
                            continue block16;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
    }

    private static void parseFilterList(XMLStreamReader reader, List<FilterSpecification> filters) throws XMLStreamException {
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case INCLUDE: {
                            JBossDeploymentStructureParser13.parsePath(reader, true, filters);
                            continue block10;
                        }
                        case EXCLUDE: {
                            JBossDeploymentStructureParser13.parsePath(reader, false, filters);
                            continue block10;
                        }
                        case INCLUDE_SET: {
                            JBossDeploymentStructureParser13.parseSet(reader, true, filters);
                            continue block10;
                        }
                        case EXCLUDE_SET: {
                            JBossDeploymentStructureParser13.parseSet(reader, false, filters);
                            continue block10;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser13.endOfDocument(reader.getLocation());
    }

    private static void parsePath(XMLStreamReader reader, boolean include, List<FilterSpecification> filters) throws XMLStreamException {
        boolean literal;
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        boolean bl = literal = path.indexOf(42) == -1 && path.indexOf(63) == -1;
        if (literal) {
            if (path.charAt(path.length() - 1) == '/') {
                filters.add(new FilterSpecification(PathFilters.isChildOf((String)path), include));
            } else {
                filters.add(new FilterSpecification(PathFilters.is((String)path), include));
            }
        } else {
            filters.add(new FilterSpecification(PathFilters.match((String)path), include));
        }
        JBossDeploymentStructureParser13.parseNoContent(reader);
    }

    private static void parseSet(XMLStreamReader reader, boolean include, List<FilterSpecification> filters) throws XMLStreamException {
        HashSet<String> set = new HashSet<String>();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    filters.add(new FilterSpecification(PathFilters.in(set), include));
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PATH: {
                            JBossDeploymentStructureParser13.parsePathName(reader, set);
                        }
                    }
                }
            }
        }
    }

    private static void parsePathName(XMLStreamReader reader, Set<String> set) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        set.add(name);
        JBossDeploymentStructureParser13.parseNoContent(reader);
    }

    private static void parseTransformers(XMLStreamReader reader, ModuleStructureSpec moduleSpec) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case TRANSFORMER: {
                            JBossDeploymentStructureParser13.parseTransformer(reader, moduleSpec.getClassTransformers());
                            continue block7;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser13.endOfDocument(reader.getLocation());
    }

    private static void parseTransformer(XMLStreamReader reader, List<String> transformerClassNames) throws XMLStreamException {
        String className = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.CLASS);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CLASS: {
                    className = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        transformerClassNames.add(className);
        JBossDeploymentStructureParser13.parseNoContent(reader);
    }

    private static void parseLocalLast(XMLStreamReader reader, ModuleStructureSpec moduleSpec) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.VALUE);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case VALUE: {
                    String value = reader.getAttributeValue(i);
                    moduleSpec.setLocalLast(Boolean.parseBoolean(value));
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        JBossDeploymentStructureParser13.parseNoContent(reader);
    }

    private static void parseNoContent(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser13.endOfDocument(reader.getLocation());
    }

    private static void parseExclusions(XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MODULE: {
                            JBossDeploymentStructureParser13.parseModuleExclusion(reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser13.endOfDocument(reader.getLocation());
    }

    private static void parseModuleExclusion(XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        String name = null;
        String slot = "main";
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        specBuilder.addExclusion(JBossModulesNameUtil.canonicalModuleIdentifier(name, (String)slot));
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
    }

    private static void parseExcludeSubsystem(XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        HashSet<String> subsystems = new HashSet<String>();
        specBuilder.setExcludedSubsystems(subsystems);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case SUBSYSTEM: {
                            JBossDeploymentStructureParser13.parseSubsystem(reader, subsystems);
                            continue block7;
                        }
                    }
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser13.endOfDocument(reader.getLocation());
    }

    private static void parseSubsystem(XMLStreamReader reader, Set<String> subsystems) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw JBossDeploymentStructureParser13.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser13.missingAttributes(reader.getLocation(), required);
        }
        subsystems.add(name);
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            throw JBossDeploymentStructureParser13.unexpectedContent(reader);
        }
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        return ServerLogger.ROOT_LOGGER.unexpectedContent(switch (reader.getEventType()) {
            case 10 -> "attribute";
            case 12 -> "cdata";
            case 4 -> "characters";
            case 5 -> "comment";
            case 11 -> "dtd";
            case 8 -> "document end";
            case 2 -> "element end";
            case 15 -> "entity declaration";
            case 9 -> "entity ref";
            case 13 -> "namespace";
            case 14 -> "notation declaration";
            case 3 -> "processing instruction";
            case 6 -> "whitespace";
            case 7 -> "document start";
            case 1 -> "element start";
            default -> "unknown";
        }, reader.hasName() ? reader.getName() : null, reader.hasText() ? reader.getText() : null, reader.getLocation());
    }

    private static XMLStreamException endOfDocument(Location location) {
        return ServerLogger.ROOT_LOGGER.unexpectedEndOfDocument(location);
    }

    private static XMLStreamException missingAttributes(Location location, Set<Attribute> required) {
        StringBuilder b = new StringBuilder();
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        return ServerLogger.ROOT_LOGGER.missingRequiredAttributes(b.toString(), location);
    }

    static enum Element {
        JBOSS_DEPLOYMENT_STRUCTURE,
        EAR_SUBDEPLOYMENTS_ISOLATED,
        EAR_EXCLUSIONS_CASCADED_TO_SUBDEPLOYMENTS,
        DEPLOYMENT,
        SUB_DEPLOYMENT,
        MODULE,
        DEPENDENCIES,
        EXCLUDE_SUBSYSTEMS,
        EXPORTS,
        IMPORTS,
        INCLUDE,
        INCLUDE_SET,
        EXCLUDE,
        EXCLUDE_SET,
        RESOURCES,
        RESOURCE_ROOT,
        PATH,
        FILTER,
        TRANSFORMERS,
        TRANSFORMER,
        EXCLUSIONS,
        LOCAL_LAST,
        SUBSYSTEM,
        SYSTEM,
        PATHS,
        MODULE_ALIAS,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "jboss-deployment-structure"), JBOSS_DEPLOYMENT_STRUCTURE);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "ear-subdeployments-isolated"), EAR_SUBDEPLOYMENTS_ISOLATED);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "ear-exclusions-cascaded-to-subdeployments"), EAR_EXCLUSIONS_CASCADED_TO_SUBDEPLOYMENTS);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "deployment"), DEPLOYMENT);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "sub-deployment"), SUB_DEPLOYMENT);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "module"), MODULE);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "dependencies"), DEPENDENCIES);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "resources"), RESOURCES);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "resource-root"), RESOURCE_ROOT);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "path"), PATH);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "exclude-subsystems"), EXCLUDE_SUBSYSTEMS);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "exports"), EXPORTS);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "imports"), IMPORTS);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "include"), INCLUDE);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "exclude"), EXCLUDE);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "exclusions"), EXCLUSIONS);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "include-set"), INCLUDE_SET);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "exclude-set"), EXCLUDE_SET);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "filter"), FILTER);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "transformers"), TRANSFORMERS);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "transformer"), TRANSFORMER);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "local-last"), LOCAL_LAST);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "module-alias"), MODULE_ALIAS);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "subsystem"), SUBSYSTEM);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "system"), SYSTEM);
            elementsMap.put(new QName(JBossDeploymentStructureParser13.NAMESPACE_1_3, "paths"), PATHS);
            elements = elementsMap;
        }
    }

    static enum Attribute {
        NAME,
        SLOT,
        EXPORT,
        SERVICES,
        PATH,
        OPTIONAL,
        CLASS,
        VALUE,
        USE_PHYSICAL_CODE_SOURCE,
        ANNOTATIONS,
        META_INF,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName("name"), NAME);
            attributesMap.put(new QName("slot"), SLOT);
            attributesMap.put(new QName("export"), EXPORT);
            attributesMap.put(new QName("services"), SERVICES);
            attributesMap.put(new QName("path"), PATH);
            attributesMap.put(new QName("optional"), OPTIONAL);
            attributesMap.put(new QName("class"), CLASS);
            attributesMap.put(new QName("value"), VALUE);
            attributesMap.put(new QName("use-physical-code-source"), USE_PHYSICAL_CODE_SOURCE);
            attributesMap.put(new QName("annotations"), ANNOTATIONS);
            attributesMap.put(new QName("meta-inf"), META_INF);
            attributes = attributesMap;
        }
    }

    static enum Disposition {
        NONE("none"),
        IMPORT("import"),
        EXPORT("export");

        private static final Map<String, Disposition> values;
        private final String value;

        private Disposition(String value) {
            this.value = value;
        }

        static Disposition of(String value) {
            Disposition disposition = values.get(value);
            return disposition == null ? NONE : disposition;
        }

        static {
            HashMap<String, Disposition> map = new HashMap<String, Disposition>();
            for (Disposition d : Disposition.values()) {
                map.put(d.value, d);
            }
            values = map;
        }
    }
}

