/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.host.controller.IgnoredNonAffectedServerGroupsUtil;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.dmr.ModelNode;

interface HostControllerExecutionSupport {
    public ModelNode getDomainOperation();

    public Map<ServerIdentity, ModelNode> getServerOps(ServerOperationProvider var1);

    public ModelNode getFormattedDomainResult(ModelNode var1);

    public boolean isReloadRequired();

    public void complete(boolean var1);

    public static class Factory {
        public static HostControllerExecutionSupport create(OperationContext context, ModelNode operation, String hostName, DomainModelProvider domainModelProvider, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, boolean isRemoteDomainControllerIgnoreUnaffectedConfiguration, ExtensionRegistry extensionRegistry) throws OperationFailedException {
            AbstractOpExecutionSupport result;
            PathElement first;
            String targetHost = null;
            PathElement runningServerTarget = null;
            ModelNode runningServerOp = null;
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            if (address.size() > 0 && "host".equals((first = address.getElement(0)).getKey()) && !first.isMultiTarget()) {
                targetHost = first.getValue();
                if (address.size() > 1 && "server".equals(address.getElement(1).getKey())) {
                    runningServerTarget = address.getElement(1);
                    ModelNode relativeAddress = new ModelNode().setEmptyList();
                    for (int i = 2; i < address.size(); ++i) {
                        PathElement element = address.getElement(i);
                        relativeAddress.add(element.getKey(), element.getValue());
                    }
                    runningServerOp = operation.clone();
                    runningServerOp.get("address").set(relativeAddress);
                }
            }
            if (targetHost != null && !hostName.equals(targetHost)) {
                result = new IgnoredOpExecutionSupport(ignoredDomainResourceRegistry);
            } else if (runningServerTarget != null) {
                Resource domainModel = domainModelProvider.getDomainModel();
                Resource hostModel = domainModel.getChild(PathElement.pathElement((String)"host", targetHost));
                if (runningServerTarget.isMultiTarget()) {
                    return new DomainOpExecutionSupport(ignoredDomainResourceRegistry, operation, PathAddress.EMPTY_ADDRESS);
                }
                String serverName = runningServerTarget.getValue();
                String serverGroup = hostModel.getChild(PathElement.pathElement((String)"server-config", (String)serverName)).getModel().require("group").asString();
                ServerIdentity serverIdentity = new ServerIdentity(targetHost, serverGroup, serverName);
                result = new DirectServerOpExecutionSupport(ignoredDomainResourceRegistry, serverIdentity, runningServerOp);
            } else if ("composite".equals(operation.require("operation").asString())) {
                if (operation.hasDefined("steps")) {
                    ArrayList<HostControllerExecutionSupport> parsedSteps = new ArrayList<HostControllerExecutionSupport>();
                    for (ModelNode step : operation.get("steps").asList()) {
                        if (operation.hasDefined(new String[]{"operation-headers", "caller-type"}) && operation.get(new String[]{"operation-headers", "caller-type"}).asString().equals("user")) {
                            step = step.clone();
                            step.get(new String[]{"operation-headers", "caller-type"}).set("user");
                        }
                        parsedSteps.add(Factory.create(context, step, hostName, domainModelProvider, ignoredDomainResourceRegistry, isRemoteDomainControllerIgnoreUnaffectedConfiguration, extensionRegistry));
                    }
                    result = new MultiStepOpExecutionSupport(ignoredDomainResourceRegistry, parsedSteps);
                } else {
                    result = new DomainOpExecutionSupport(ignoredDomainResourceRegistry, operation, address);
                }
            } else {
                result = targetHost == null && Factory.isResourceExcluded(context, ignoredDomainResourceRegistry, isRemoteDomainControllerIgnoreUnaffectedConfiguration, domainModelProvider, hostName, address, extensionRegistry, operation) ? new IgnoredOpExecutionSupport(ignoredDomainResourceRegistry) : new DomainOpExecutionSupport(ignoredDomainResourceRegistry, operation, address);
            }
            return result;
        }

        private static boolean isResourceExcluded(OperationContext context, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, boolean isRemoteDomainControllerIgnoreUnaffectedConfiguration, DomainModelProvider domainModelProvider, String hostName, PathAddress address, ExtensionRegistry extensionRegistry, ModelNode operation) {
            if (ignoredDomainResourceRegistry.getIgnoredClonedProfileRegistry().checkIgnoredProfileClone(operation)) {
                return true;
            }
            if (ignoredDomainResourceRegistry.isResourceExcluded(address)) {
                return true;
            }
            if (isRemoteDomainControllerIgnoreUnaffectedConfiguration) {
                IgnoredNonAffectedServerGroupsUtil util = IgnoredNonAffectedServerGroupsUtil.create(extensionRegistry);
                Set<IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo> serverConfigs = util.getServerConfigsOnSlave(domainModelProvider.getDomainModel().getChild(PathElement.pathElement((String)"host", (String)hostName)));
                return util.ignoreOperation(domainModelProvider.getDomainModel(), serverConfigs, address);
            }
            return false;
        }

        private static class IgnoredOpExecutionSupport
        extends SimpleOpExecutionSupport {
            private IgnoredOpExecutionSupport(IgnoredDomainResourceRegistry ignoredDomainResourceRegistry) {
                super(ignoredDomainResourceRegistry);
            }

            @Override
            public ModelNode getDomainOperation() {
                return null;
            }

            @Override
            public Map<ServerIdentity, ModelNode> getServerOps(ServerOperationProvider provider) {
                return Collections.emptyMap();
            }
        }

        private static class DomainOpExecutionSupport
        extends SimpleOpExecutionSupport {
            private final ModelNode domainOp;
            private final PathAddress domainOpAddress;

            private DomainOpExecutionSupport(IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, ModelNode domainOp, PathAddress domainOpAddress) {
                super(ignoredDomainResourceRegistry);
                this.domainOp = domainOp;
                this.domainOpAddress = domainOpAddress;
            }

            @Override
            public ModelNode getDomainOperation() {
                return this.domainOp;
            }

            @Override
            public Map<ServerIdentity, ModelNode> getServerOps(ServerOperationProvider provider) {
                Map<Set<ServerIdentity>, ModelNode> bundled = provider.getServerOperations(this.domainOp, this.domainOpAddress);
                HashMap<ServerIdentity, ModelNode> unbundled = new HashMap<ServerIdentity, ModelNode>();
                for (Map.Entry<Set<ServerIdentity>, ModelNode> entry : bundled.entrySet()) {
                    ModelNode op = entry.getValue();
                    for (ServerIdentity id : entry.getKey()) {
                        unbundled.put(id, op);
                    }
                }
                return unbundled;
            }
        }

        private static class DirectServerOpExecutionSupport
        extends SimpleOpExecutionSupport {
            private Map<ServerIdentity, ModelNode> serverOps;

            private DirectServerOpExecutionSupport(IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, ServerIdentity serverIdentity, ModelNode serverOp) {
                super(ignoredDomainResourceRegistry);
                this.serverOps = Collections.singletonMap(serverIdentity, serverOp);
            }

            @Override
            public ModelNode getDomainOperation() {
                return null;
            }

            @Override
            public Map<ServerIdentity, ModelNode> getServerOps(ServerOperationProvider provider) {
                return this.serverOps;
            }
        }

        private static class MultiStepOpExecutionSupport
        extends AbstractOpExecutionSupport {
            private final List<HostControllerExecutionSupport> steps;

            private MultiStepOpExecutionSupport(IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, List<HostControllerExecutionSupport> steps) {
                super(ignoredDomainResourceRegistry);
                this.steps = steps;
            }

            @Override
            public Map<ServerIdentity, ModelNode> getServerOps(ServerOperationProvider provider) {
                HashMap<ServerIdentity, ModelNode> result = new HashMap<ServerIdentity, ModelNode>();
                int stepNum = 1;
                for (HostControllerExecutionSupport step : this.steps) {
                    String stepLabel = "step-" + stepNum++;
                    Map<ServerIdentity, ModelNode> stepResults = step.getServerOps(provider);
                    for (Map.Entry<ServerIdentity, ModelNode> entry : stepResults.entrySet()) {
                        ModelNode serverNode = (ModelNode)result.get(entry.getKey());
                        if (serverNode == null) {
                            serverNode = new ModelNode();
                            result.put(entry.getKey(), serverNode);
                        }
                        serverNode.get(stepLabel).set(entry.getValue());
                    }
                }
                return result;
            }

            @Override
            public ModelNode getDomainOperation() {
                ArrayList<ModelNode> domainSteps = new ArrayList<ModelNode>();
                for (HostControllerExecutionSupport hostControllerExecutionSupport : this.steps) {
                    ModelNode stepNode = hostControllerExecutionSupport.getDomainOperation();
                    if (stepNode == null) continue;
                    domainSteps.add(stepNode);
                }
                if (domainSteps.isEmpty()) {
                    return null;
                }
                ModelNode stepsParam = new ModelNode();
                for (ModelNode stepNode : domainSteps) {
                    stepsParam.add(stepNode);
                }
                ModelNode modelNode = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
                modelNode.get("steps").set(stepsParam);
                return modelNode;
            }

            @Override
            public ModelNode getFormattedDomainResult(ModelNode resultNode) {
                ModelNode allSteps = new ModelNode();
                int resultStep = 0;
                for (int i = 0; i < this.steps.size(); ++i) {
                    HostControllerExecutionSupport po = this.steps.get(i);
                    if (po.getDomainOperation() != null) {
                        ModelNode formattedStepResponseNode;
                        String label = "step-" + ++resultStep;
                        ModelNode stepResponseNode = resultNode.get(label);
                        if (po instanceof MultiStepOpExecutionSupport) {
                            formattedStepResponseNode = stepResponseNode.clone();
                            ModelNode stepResultNode = stepResponseNode.get("result");
                            formattedStepResponseNode.get("result").set(po.getFormattedDomainResult(stepResultNode));
                        } else {
                            formattedStepResponseNode = po.getFormattedDomainResult(stepResponseNode);
                        }
                        allSteps.get("step-" + (i + 1)).set(formattedStepResponseNode);
                        continue;
                    }
                    allSteps.get(new String[]{"step-" + (i + 1), "outcome"}).set("ignored-by-unaffected-host-controller");
                }
                return allSteps;
            }
        }

        private static abstract class SimpleOpExecutionSupport
        extends AbstractOpExecutionSupport {
            private SimpleOpExecutionSupport(IgnoredDomainResourceRegistry ignoredDomainResourceRegistry) {
                super(ignoredDomainResourceRegistry);
            }

            @Override
            public ModelNode getFormattedDomainResult(ModelNode resultNode) {
                return resultNode.clone();
            }
        }

        private static abstract class AbstractOpExecutionSupport
        implements HostControllerExecutionSupport {
            private final IgnoredDomainResourceRegistry.IgnoredClonedProfileRegistry ignoredClonedProfileRegistry;

            private AbstractOpExecutionSupport(IgnoredDomainResourceRegistry ignoredDomainResourceRegistry) {
                this.ignoredClonedProfileRegistry = ignoredDomainResourceRegistry.getIgnoredClonedProfileRegistry();
            }

            @Override
            public boolean isReloadRequired() {
                return this.ignoredClonedProfileRegistry.isReloadRequired();
            }

            @Override
            public void complete(boolean rollback) {
                this.ignoredClonedProfileRegistry.complete(rollback);
            }
        }
    }

    public static interface DomainModelProvider {
        public Resource getDomainModel();
    }

    public static interface ServerOperationProvider {
        public Map<Set<ServerIdentity>, ModelNode> getServerOperations(ModelNode var1, PathAddress var2);
    }
}

