/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.EnumMarshaller;
import org.wildfly.clustering.marshalling.protostream.FieldSetWriter;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamOperation;
import org.wildfly.clustering.marshalling.protostream.Writable;

public interface ProtoStreamWriter
extends ProtoStreamOperation,
TagWriter {
    public <T> FieldSetWriter<T> createFieldSetWriter(Writable<T> var1, int var2);

    default public void writeAny(int index, Object value) throws IOException {
        this.writeTag(index, WireType.LENGTH_DELIMITED);
        this.writeAnyNoTag(value);
    }

    default public void writeObject(int index, Object value) throws IOException {
        this.writeTag(index, WireType.LENGTH_DELIMITED);
        this.writeObjectNoTag(value);
    }

    public void writeAnyNoTag(Object var1) throws IOException;

    public void writeObjectNoTag(Object var1) throws IOException;

    default public <E extends Enum<E>> void writeEnum(int index, E value) throws IOException {
        EnumMarshaller marshaller = (EnumMarshaller)this.getSerializationContext().getMarshaller(value.getDeclaringClass());
        this.writeEnum(index, marshaller.encode(value));
    }

    @Deprecated
    default public void writeTag(int index, int wireType) throws IOException {
        this.writeTag(index, WireType.fromValue((int)wireType));
    }

    @Deprecated
    public void writeInt32(int var1, int var2) throws IOException;

    @Deprecated
    public void writeInt64(int var1, long var2) throws IOException;

    @Deprecated
    public void writeFixed32(int var1, int var2) throws IOException;

    @Deprecated
    public void writeFixed64(int var1, long var2) throws IOException;
}

