/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded.user;

import java.util.function.Supplier;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.MarshalledValueMarshaller;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.server.cache.CacheStrategy;
import org.wildfly.clustering.server.infinispan.manager.AffinityIdentifierFactory;
import org.wildfly.clustering.server.manager.IdentifierFactory;
import org.wildfly.clustering.session.cache.user.CachedUserManager;
import org.wildfly.clustering.session.cache.user.CompositeUserFactory;
import org.wildfly.clustering.session.cache.user.DefaultUserManager;
import org.wildfly.clustering.session.cache.user.UserFactory;
import org.wildfly.clustering.session.infinispan.embedded.user.InfinispanUserContextFactory;
import org.wildfly.clustering.session.infinispan.embedded.user.InfinispanUserSessionsFactory;
import org.wildfly.clustering.session.user.UserManager;
import org.wildfly.clustering.session.user.UserManagerConfiguration;
import org.wildfly.clustering.session.user.UserManagerFactory;

public class InfinispanUserManagerFactory<C, D, S>
implements UserManagerFactory<C, D, S> {
    private final EmbeddedCacheConfiguration configuration;

    public InfinispanUserManagerFactory(EmbeddedCacheConfiguration configuration) {
        this.configuration = configuration;
    }

    public <T> UserManager<C, T, D, S> createUserManager(UserManagerConfiguration<T> configuration) {
        MarshalledValueMarshaller marshaller = new MarshalledValueMarshaller((MarshalledValueFactory)new ByteBufferMarshalledValueFactory(configuration.getMarshaller()));
        InfinispanUserContextFactory contextFactory = new InfinispanUserContextFactory(this.configuration, marshaller, configuration.getTransientContextFactory());
        InfinispanUserSessionsFactory sessionsFactory = new InfinispanUserSessionsFactory(this.configuration);
        CompositeUserFactory factory = new CompositeUserFactory(contextFactory, sessionsFactory, this.configuration.getCacheProperties());
        AffinityIdentifierFactory identifierFactory = new AffinityIdentifierFactory((Supplier)configuration.getIdentifierFactory(), this.configuration.getCache());
        return new CachedUserManager((UserManager)new DefaultUserManager((UserFactory)factory, (IdentifierFactory)identifierFactory, this.configuration.getBatchFactory()), (CacheFactory)CacheStrategy.CONCURRENT);
    }
}

