/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelType;

public class SimpleOperationDefinitionBuilder {
    private static final AttributeDefinition[] NO_ATTRIBUTES = new AttributeDefinition[0];
    ResourceDescriptionResolver resolver;
    ResourceDescriptionResolver attributeResolver;
    protected String name;
    protected OperationEntry.EntryType entryType = OperationEntry.EntryType.PUBLIC;
    protected Set<OperationEntry.Flag> flags = EnumSet.noneOf(OperationEntry.Flag.class);
    protected AttributeDefinition[] parameters = NO_ATTRIBUTES;
    protected ModelType replyType;
    protected ModelType replyValueType;
    protected boolean replyAllowNull;
    protected DeprecationData deprecationData = null;
    protected AttributeDefinition[] replyParameters = NO_ATTRIBUTES;
    protected AccessConstraintDefinition[] accessConstraints;
    DescriptionProvider descriptionProvider;
    Stability stability = Stability.DEFAULT;

    public static SimpleOperationDefinitionBuilder of(String name, ResourceDescriptionResolver resolver) {
        return new SimpleOperationDefinitionBuilder(name, resolver);
    }

    public static SimpleOperationDefinitionBuilder of(String name, OperationDefinition basis) {
        if (!(basis instanceof SimpleOperationDefinition)) {
            throw new IllegalArgumentException();
        }
        return SimpleOperationDefinitionBuilder.of(name, (SimpleOperationDefinition)basis);
    }

    public static SimpleOperationDefinitionBuilder of(String name, SimpleOperationDefinition basis) {
        DeprecationData deprecation;
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder(name, basis.getResolver()).setAccessConstraints((AccessConstraintDefinition[])basis.getAccessConstraints().toArray(AccessConstraintDefinition[]::new)).setAttributeResolver(basis.getAttributeResolver()).setDescriptionProvider(basis.descriptionProvider).setEntryType(basis.getEntryType()).setParameters(basis.getParameters()).setReplyParameters(basis.getReplyParameters()).setReplyType(basis.getReplyType()).setReplyValueType(basis.getReplyValueType()).setStability(basis.getStability()).withFlags(basis.getFlags());
        if (basis.isReplyAllowNull()) {
            builder.allowReturnNull();
        }
        if ((deprecation = basis.getDeprecationData()) != null) {
            builder.setDeprecated(deprecation.getSince(), deprecation.isNotificationUseful());
        }
        return builder;
    }

    public SimpleOperationDefinitionBuilder(String name, ResourceDescriptionResolver resolver) {
        this.name = name;
        this.resolver = resolver;
    }

    public SimpleOperationDefinition build() {
        if (this.attributeResolver == null) {
            this.attributeResolver = this.resolver;
        }
        return this.internalBuild(this.resolver, this.attributeResolver);
    }

    protected SimpleOperationDefinition internalBuild(ResourceDescriptionResolver resolver, ResourceDescriptionResolver attributeResolver) {
        return new SimpleOperationDefinition(this);
    }

    protected static EnumSet<OperationEntry.Flag> getFlagsSet(OperationEntry.Flag ... vararg) {
        EnumSet<OperationEntry.Flag> result = EnumSet.noneOf(OperationEntry.Flag.class);
        if (vararg != null && vararg.length > 0) {
            Collections.addAll(result, vararg);
        }
        return result;
    }

    public SimpleOperationDefinitionBuilder setEntryType(OperationEntry.EntryType entryType) {
        this.entryType = entryType;
        return this;
    }

    public SimpleOperationDefinitionBuilder setPrivateEntry() {
        this.entryType = OperationEntry.EntryType.PRIVATE;
        return this;
    }

    public SimpleOperationDefinitionBuilder withFlags(Set<OperationEntry.Flag> flags) {
        this.flags.addAll(flags);
        return this;
    }

    public SimpleOperationDefinitionBuilder withFlags(OperationEntry.Flag ... flags) {
        this.flags.addAll(SimpleOperationDefinitionBuilder.getFlagsSet(flags));
        return this;
    }

    public SimpleOperationDefinitionBuilder withFlag(OperationEntry.Flag flag) {
        this.flags.add(flag);
        return this;
    }

    public SimpleOperationDefinitionBuilder setRuntimeOnly() {
        return this.withFlag(OperationEntry.Flag.RUNTIME_ONLY);
    }

    public SimpleOperationDefinitionBuilder setReadOnly() {
        return this.withFlag(OperationEntry.Flag.READ_ONLY);
    }

    public SimpleOperationDefinitionBuilder setParameters(AttributeDefinition ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public SimpleOperationDefinitionBuilder addParameter(AttributeDefinition parameter) {
        int i = this.parameters.length;
        this.parameters = Arrays.copyOf(this.parameters, i + 1);
        this.parameters[i] = parameter;
        return this;
    }

    public SimpleOperationDefinitionBuilder setReplyType(ModelType replyType) {
        this.replyType = replyType;
        return this;
    }

    public SimpleOperationDefinitionBuilder setReplyValueType(ModelType replyValueType) {
        this.replyValueType = replyValueType;
        return this;
    }

    public SimpleOperationDefinitionBuilder allowReturnNull() {
        this.replyAllowNull = true;
        return this;
    }

    public SimpleOperationDefinitionBuilder setDeprecated(ModelVersion since) {
        return this.setDeprecated(since, true);
    }

    public SimpleOperationDefinitionBuilder setDeprecated(ModelVersion since, boolean notificationUseful) {
        this.deprecationData = new DeprecationData(since, notificationUseful);
        return this;
    }

    public SimpleOperationDefinitionBuilder setReplyParameters(AttributeDefinition ... replyParameters) {
        this.replyParameters = replyParameters;
        return this;
    }

    public SimpleOperationDefinitionBuilder setAttributeResolver(ResourceDescriptionResolver resolver) {
        this.attributeResolver = resolver;
        return this;
    }

    public SimpleOperationDefinitionBuilder setAccessConstraints(AccessConstraintDefinition ... accessConstraints) {
        this.accessConstraints = accessConstraints;
        return this;
    }

    public SimpleOperationDefinitionBuilder addAccessConstraint(AccessConstraintDefinition accessConstraint) {
        if (this.accessConstraints == null) {
            this.accessConstraints = new AccessConstraintDefinition[]{accessConstraint};
        } else {
            this.accessConstraints = Arrays.copyOf(this.accessConstraints, this.accessConstraints.length + 1);
            this.accessConstraints[this.accessConstraints.length - 1] = accessConstraint;
        }
        return this;
    }

    public SimpleOperationDefinitionBuilder setDescriptionProvider(DescriptionProvider provider) {
        this.descriptionProvider = provider;
        return this;
    }

    public SimpleOperationDefinitionBuilder setStability(Stability stability) {
        this.stability = stability;
        return this;
    }
}

