/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.stub;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.wsarjtx.ArjunaTXConstants;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.client.CompletionCoordinatorClient;
import com.arjuna.webservices11.wsat.processors.CompletionInitiatorCallback;
import com.arjuna.webservices11.wsat.processors.CompletionInitiatorProcessor;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.CompletionCoordinatorParticipant;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;

public class CompletionStub
implements CompletionCoordinatorParticipant {
    private W3CEndpointReference _completionCoordinator = null;
    private String _id;

    public CompletionStub(String id, W3CEndpointReference completionCoordinator) throws Exception {
        this._completionCoordinator = completionCoordinator;
        this._id = id;
    }

    @Override
    public void commit() throws TransactionRolledBackException, UnknownTransactionException, SystemException {
        MAP map = AddressingHelper.createNotificationContext(MessageId.getMessageId());
        RequestCallback callback = new RequestCallback();
        CompletionInitiatorProcessor completionInitiator = CompletionInitiatorProcessor.getProcessor();
        completionInitiator.registerCallback(this._id, callback);
        try {
            CompletionCoordinatorClient.getClient().sendCommit(this._completionCoordinator, map, new InstanceIdentifier(this._id));
            callback.waitUntilTriggered();
        }
        catch (Throwable th) {
            WSTLogger.logger.warn((Object)th.getMessage(), th);
            throw new SystemException();
        }
        finally {
            completionInitiator.removeCallback(this._id);
        }
        if (callback.hasTriggered()) {
            if (callback.receivedCommitted()) {
                return;
            }
            if (callback.receivedAborted()) {
                throw new TransactionRolledBackException();
            }
            SoapFault soapFault = callback.getSoapFault();
            if (soapFault != null && ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME.equals(soapFault.getSubcode())) {
                throw new UnknownTransactionException();
            }
        }
        throw new SystemException();
    }

    @Override
    public void rollback() throws UnknownTransactionException, SystemException {
        MAP map = AddressingHelper.createNotificationContext(MessageId.getMessageId());
        RequestCallback callback = new RequestCallback();
        CompletionInitiatorProcessor completionInitiator = CompletionInitiatorProcessor.getProcessor();
        completionInitiator.registerCallback(this._id, callback);
        try {
            CompletionCoordinatorClient.getClient().sendRollback(this._completionCoordinator, map, new InstanceIdentifier(this._id));
            callback.waitUntilTriggered();
        }
        catch (Throwable th) {
            WSTLogger.logger.warn((Object)th.getMessage(), th);
            throw new SystemException();
        }
        finally {
            completionInitiator.removeCallback(this._id);
        }
        if (callback.hasTriggered()) {
            if (callback.receivedAborted()) {
                return;
            }
            SoapFault soapFault = callback.getSoapFault();
            if (soapFault != null && ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME.equals(soapFault.getSubcode())) {
                throw new UnknownTransactionException();
            }
        }
        throw new SystemException();
    }

    private static class RequestCallback
    extends CompletionInitiatorCallback {
        private MAP map;
        private ArjunaContext arjunaContext;
        private SoapFault soapFault;
        private boolean aborted;
        private boolean committed;

        private RequestCallback() {
        }

        MAP getMAP() {
            return this.map;
        }

        ArjunaContext getArjunaContext() {
            return this.arjunaContext;
        }

        SoapFault getSoapFault() {
            return this.soapFault;
        }

        boolean receivedAborted() {
            return this.aborted;
        }

        boolean receivedCommitted() {
            return this.committed;
        }

        @Override
        public void aborted(Notification aborted, MAP map, ArjunaContext arjunaContext) {
            this.aborted = true;
            this.map = map;
            this.arjunaContext = arjunaContext;
        }

        @Override
        public void committed(Notification committed, MAP map, ArjunaContext arjunaContext) {
            this.committed = true;
            this.map = map;
            this.arjunaContext = arjunaContext;
        }

        @Override
        public void soapFault(SoapFault soapFault, MAP map, ArjunaContext arjunaContext) {
            this.soapFault = soapFault;
            this.map = map;
            this.arjunaContext = arjunaContext;
        }
    }
}

