/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.identity.impl;

import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;

abstract class AbstractIdentityMappingCollectorNode {
    final PojoMappingHelper mappingHelper;

    AbstractIdentityMappingCollectorNode(PojoMappingHelper mappingHelper) {
        this.mappingHelper = mappingHelper;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.getModelPath()) + "]";
    }

    abstract BoundPojoModelPath getModelPath();

    public final ContextualFailureCollector failureCollector() {
        BoundPojoModelPath modelPath = this.getModelPath();
        ContextualFailureCollector failureCollector = this.mappingHelper.failureCollector().withContext(PojoEventContexts.fromType(modelPath.getRootType().rawType()));
        PojoModelPath unboundPath = modelPath.toUnboundPath();
        if (unboundPath != null) {
            failureCollector = failureCollector.withContext(PojoEventContexts.fromPath(modelPath.toUnboundPath()));
        }
        return failureCollector;
    }
}

