/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.message.impl;

import io.netty.buffer.ByteBuf;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;

public class CoreMessagePersister
implements Persister<Message> {
    public static final byte ID = 1;
    private static CoreMessagePersister theInstance;

    public static void registerPersister(CoreMessagePersister newPersister) {
        theInstance = newPersister;
    }

    public static void resetPersister() {
        theInstance = null;
    }

    public static CoreMessagePersister getInstance() {
        if (theInstance == null) {
            theInstance = new CoreMessagePersister();
        }
        return theInstance;
    }

    protected CoreMessagePersister() {
    }

    public byte getID() {
        return 1;
    }

    public int getEncodeSize(Message record) {
        return 1 + record.getPersistSize() + SimpleString.sizeofNullableString((SimpleString)record.getAddressSimpleString()) + 8;
    }

    public void encode(ActiveMQBuffer buffer, Message record) {
        buffer.writeByte((byte)1);
        buffer.writeLong(record.getMessageID());
        buffer.writeNullableSimpleString(record.getAddressSimpleString());
        record.persist(buffer);
    }

    public Message decode(ActiveMQBuffer buffer, Message record, CoreMessageObjectPools pool) {
        long id = buffer.readLong();
        SimpleString address = pool == null ? buffer.readNullableSimpleString() : SimpleString.readNullableSimpleString((ByteBuf)buffer.byteBuf(), (SimpleString.ByteBufSimpleStringPool)pool.getAddressDecoderPool());
        record = new CoreMessage();
        record.reloadPersistence(buffer, pool);
        record.setMessageID(id);
        record.setAddress(address);
        return record;
    }
}

