/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicLong;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.web.undertow.session.Recordable;
import org.wildfly.clustering.web.undertow.session.RecordableInactiveSessionStatistics;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;

public class DistributableSessionManagerStatistics
implements RecordableSessionManagerStatistics {
    private final RecordableInactiveSessionStatistics inactiveSessionStatistics;
    private final SessionStatistics activeSessionStatistics;
    private final OptionalInt maxActiveSessions;
    private volatile long startTime = System.currentTimeMillis();
    private final AtomicLong createdSessionCount = new AtomicLong();

    public DistributableSessionManagerStatistics(SessionStatistics activeSessionStatistics, RecordableInactiveSessionStatistics inactiveSessionStatistics, OptionalInt maxActiveSessions) {
        this.activeSessionStatistics = activeSessionStatistics;
        this.inactiveSessionStatistics = inactiveSessionStatistics;
        this.maxActiveSessions = maxActiveSessions;
        this.reset();
    }

    @Override
    public Recordable<ImmutableSessionMetaData> getInactiveSessionRecorder() {
        return this.inactiveSessionStatistics;
    }

    @Override
    public void record(ImmutableSessionMetaData metaData) {
        this.createdSessionCount.incrementAndGet();
    }

    @Override
    public void reset() {
        this.createdSessionCount.set(0L);
        this.startTime = System.currentTimeMillis();
        this.inactiveSessionStatistics.reset();
    }

    public long getCreatedSessionCount() {
        return this.createdSessionCount.get();
    }

    public long getMaxActiveSessions() {
        return this.maxActiveSessions.orElse(-1);
    }

    public long getActiveSessionCount() {
        return this.activeSessionStatistics.getActiveSessionCount();
    }

    public long getExpiredSessionCount() {
        return this.inactiveSessionStatistics.getExpiredSessionCount();
    }

    public long getRejectedSessions() {
        return 0L;
    }

    public long getMaxSessionAliveTime() {
        return this.inactiveSessionStatistics.getMaxSessionLifetime().toMillis();
    }

    public long getAverageSessionAliveTime() {
        return this.inactiveSessionStatistics.getMeanSessionLifetime().toMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }
}

