/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.internal.AbstractSingleMutationExecutor;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementGroupSingleTable;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.ValuesAnalysis;

public class MutationExecutorSingleNonBatched
extends AbstractSingleMutationExecutor {
    private final PreparedStatementGroupSingleTable statementGroup;
    private final GeneratedValuesMutationDelegate generatedValuesDelegate;

    public MutationExecutorSingleNonBatched(PreparableMutationOperation mutationOperation, GeneratedValuesMutationDelegate generatedValuesDelegate, SharedSessionContractImplementor session) {
        super(mutationOperation, session);
        this.generatedValuesDelegate = generatedValuesDelegate;
        this.statementGroup = new PreparedStatementGroupSingleTable(mutationOperation, generatedValuesDelegate, session);
        this.prepareForNonBatchedWork(null, session);
    }

    @Override
    protected PreparedStatementGroupSingleTable getStatementGroup() {
        return this.statementGroup;
    }

    @Override
    protected GeneratedValues performNonBatchedOperations(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        if (this.generatedValuesDelegate != null) {
            return this.generatedValuesDelegate.performMutation(this.statementGroup.getSingleStatementDetails(), this.getJdbcValueBindings(), modelReference, session);
        }
        this.performNonBatchedMutation(this.statementGroup.getSingleStatementDetails(), null, this.getJdbcValueBindings(), inclusionChecker, resultChecker, session);
        return null;
    }

    @Override
    public void release() {
        assert (this.statementGroup.getSingleStatementDetails().getStatement() == null);
    }
}

