/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.search.predicate.spi.MinimumShouldMatchBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class LuceneCommonMinimumShouldMatchConstraints
implements MinimumShouldMatchBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private NavigableMap<Integer, MinimumShouldMatchConstraint> minimumShouldMatchConstraints;

    public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
        this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new MinimumShouldMatchConstraint(matchingClausesNumber, null));
    }

    public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
        this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new MinimumShouldMatchConstraint(null, matchingClausesPercent));
    }

    private void addMinimumShouldMatchConstraint(int ignoreConstraintCeiling, MinimumShouldMatchConstraint constraint) {
        MinimumShouldMatchConstraint previous;
        if (this.minimumShouldMatchConstraints == null) {
            this.minimumShouldMatchConstraints = new TreeMap<Integer, MinimumShouldMatchConstraint>();
        }
        if ((previous = this.minimumShouldMatchConstraints.put(ignoreConstraintCeiling, constraint)) != null) {
            throw log.minimumShouldMatchConflictingConstraints(ignoreConstraintCeiling);
        }
    }

    public boolean isEmpty() {
        return this.minimumShouldMatchConstraints == null;
    }

    public int minimumShouldMatch(Collection<?> shouldClauses) {
        return this.minimumShouldMatch(shouldClauses.size());
    }

    private int minimumShouldMatch(int shouldClauses) {
        Map.Entry<Integer, MinimumShouldMatchConstraint> entry = this.minimumShouldMatchConstraints.lowerEntry(shouldClauses);
        if (entry != null) {
            return entry.getValue().toMinimum(shouldClauses);
        }
        return shouldClauses;
    }

    public Query apply(Query query) {
        if (this.minimumShouldMatchConstraints == null) {
            return query;
        }
        if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            int shouldClauses = (int)booleanQuery.clauses().stream().map(BooleanClause::getOccur).filter(arg_0 -> BooleanClause.Occur.SHOULD.equals(arg_0)).count();
            int minimumShouldMatch = this.minimumShouldMatch(shouldClauses);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (BooleanClause clause : booleanQuery.clauses()) {
                builder.add(clause);
            }
            query = builder.setMinimumNumberShouldMatch(minimumShouldMatch).build();
        }
        return query;
    }

    private static final class MinimumShouldMatchConstraint {
        private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
        private final Integer matchingClausesNumber;
        private final Integer matchingClausesPercent;

        MinimumShouldMatchConstraint(Integer matchingClausesNumber, Integer matchingClausesPercent) {
            this.matchingClausesNumber = matchingClausesNumber;
            this.matchingClausesPercent = matchingClausesPercent;
        }

        int toMinimum(int totalShouldClauseNumber) {
            int minimum = this.matchingClausesNumber != null ? (this.matchingClausesNumber >= 0 ? this.matchingClausesNumber : totalShouldClauseNumber + this.matchingClausesNumber) : (this.matchingClausesPercent >= 0 ? this.matchingClausesPercent * totalShouldClauseNumber / 100 : totalShouldClauseNumber + this.matchingClausesPercent * totalShouldClauseNumber / 100);
            if (minimum < 1 || minimum > totalShouldClauseNumber) {
                throw log.minimumShouldMatchMinimumOutOfBounds(totalShouldClauseNumber, minimum);
            }
            return minimum;
        }
    }
}

