#!/bin/bash
set -e

fail() {
    echo "$1"
    usage
    exit 1
}

usage() {
    echo "${0##*/} old-version new-version"
}

if [ "x$1" == "x" ]; then
    fail "Missing old version"
fi

if [ "x$2" == "x" ]; then
    fail "Missing new version"
fi

FILES=$(find . -name "pom.xml" -type f)

for f in $FILES
do
    p=$(realpath $f)
    eval "sed -i -e 's/$1/$2/g' $p"
done

if [[ "$1" == *"SNAPSHOT" ]]; then
    # Check for SNAPSHOT
    git grep "\-SNAPSHOT"
fi
