/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.PathTemplateMatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Deque;
import java.util.function.Function;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.ByteInputs;
import org.wildfly.httpclient.common.ByteOutputs;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.HeadersHelper;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpServerHelper;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.naming.Constants;
import org.wildfly.httpclient.naming.HttpNamingClientMessages;
import org.wildfly.httpclient.naming.HttpNamingServerObjectResolver;
import org.wildfly.httpclient.naming.RequestType;
import org.wildfly.httpclient.naming.Serializer;

final class ServerHandlers {
    private final Context ctx;
    private final Function<String, Boolean> classFilter;
    private final HttpServiceConfig config;

    private ServerHandlers(HttpServiceConfig config, Context ctx, Function<String, Boolean> classFilter) {
        this.config = config;
        this.ctx = ctx;
        this.classFilter = classFilter;
    }

    static ServerHandlers newInstance(HttpServiceConfig config, Context ctx, Function<String, Boolean> classFilter) {
        return new ServerHandlers(config, ctx, classFilter);
    }

    HttpHandler handlerOf(RequestType requestType) {
        switch (requestType) {
            case BIND: {
                return new BindHandler(this.config, this.ctx, this.classFilter);
            }
            case CREATE_SUBCONTEXT: {
                return new CreateSubContextHandler(this.config, this.ctx);
            }
            case DESTROY_SUBCONTEXT: {
                return new DestroySubContextHandler(this.config, this.ctx);
            }
            case LIST: {
                return new ListHandler(this.config, this.ctx);
            }
            case LIST_BINDINGS: {
                return new ListBindingsHandler(this.config, this.ctx);
            }
            case LOOKUP: {
                return new LookupHandler(this.config, this.ctx);
            }
            case LOOKUP_LINK: {
                return new LookupLinkHandler(this.config, this.ctx);
            }
            case REBIND: {
                return new RebindHandler(this.config, this.ctx, this.classFilter);
            }
            case RENAME: {
                return new RenameHandler(this.config, this.ctx);
            }
            case UNBIND: {
                return new UnbindHandler(this.config, this.ctx);
            }
        }
        throw new IllegalStateException();
    }

    private static final class FilterClassResolver
    extends ContextClassResolver {
        private final Function<String, Boolean> filter;

        private FilterClassResolver(Function<String, Boolean> filter) {
            this.filter = filter;
        }

        @Override
        public Class<?> resolveClass(Unmarshaller unmarshaller, String name, long serialVersionUID) throws IOException, ClassNotFoundException {
            this.checkFilter(name);
            return super.resolveClass(unmarshaller, name, serialVersionUID);
        }

        @Override
        public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] interfaces) throws IOException, ClassNotFoundException {
            for (String name : interfaces) {
                this.checkFilter(name);
            }
            return super.resolveProxyClass(unmarshaller, interfaces);
        }

        private void checkFilter(String className) throws InvalidClassException {
            if (this.filter.apply(className) != Boolean.TRUE) {
                throw HttpNamingClientMessages.MESSAGES.cannotResolveFilteredClass(className);
            }
        }
    }

    private static abstract class AbstractClassFilteringNamingHandler
    extends AbstractNamingHandler {
        private AbstractClassFilteringNamingHandler(HttpServiceConfig config, Context ctx, Function<String, Boolean> classFilter) {
            super(config, ctx, classFilter);
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            ContentType contentType = ContentType.parse(HeadersHelper.getRequestHeader(exchange, Headers.CONTENT_TYPE));
            if (contentType == null || !contentType.getType().equals(Constants.VALUE.getType()) || contentType.getVersion() != 1) {
                exchange.setStatusCode(400);
                exchange.endExchange();
                return null;
            }
            HttpMarshallerFactory marshallerFactory = this.config.getHttpUnmarshallerFactory(exchange);
            InputStream is = exchange.getInputStream();
            try (ByteInput in = ByteInputs.byteInputOf(is);){
                Unmarshaller unmarshaller = this.classFilter != null ? marshallerFactory.createUnmarshaller(new FilterClassResolver(this.classFilter)) : marshallerFactory.createUnmarshaller();
                unmarshaller.start(in);
                Object object = Serializer.deserializeObject(unmarshaller);
                unmarshaller.finish();
                this.doOperation(name, object);
            }
            catch (Exception e) {
                if (e instanceof NamingException) {
                    throw (NamingException)e;
                }
                NamingException nm = new NamingException(e.getMessage());
                nm.initCause(e);
                throw nm;
            }
            return null;
        }

        protected abstract void doOperation(String var1, Object var2) throws NamingException;
    }

    private class BindHandler
    extends AbstractClassFilteringNamingHandler {
        private BindHandler(HttpServiceConfig config, Context ctx, Function<String, Boolean> classFilter) {
            super(config, ctx, classFilter);
        }

        @Override
        protected void doOperation(String name, Object object) throws NamingException {
            this.ctx.bind(name, object);
        }
    }

    private class RebindHandler
    extends AbstractClassFilteringNamingHandler {
        private RebindHandler(HttpServiceConfig config, Context ctx, Function<String, Boolean> classFilter) {
            super(config, ctx, classFilter);
        }

        @Override
        protected void doOperation(String name, Object object) throws NamingException {
            this.ctx.rebind(name, object);
        }
    }

    private static final class ListHandler
    extends AbstractNamingHandler {
        private ListHandler(HttpServiceConfig config, Context ctx) {
            super(config, ctx);
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            NamingEnumeration<NameClassPair> namingEnumeration = this.ctx.list(name);
            return Collections.list(namingEnumeration);
        }
    }

    private static final class DestroySubContextHandler
    extends AbstractNamingHandler {
        private DestroySubContextHandler(HttpServiceConfig config, Context ctx) {
            super(config, ctx);
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            this.ctx.destroySubcontext(name);
            return null;
        }
    }

    private static final class RenameHandler
    extends AbstractNamingHandler {
        private RenameHandler(HttpServiceConfig config, Context ctx) {
            super(config, ctx);
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            Deque<String> newName = exchange.getQueryParameters().get("new");
            if (newName == null || newName.isEmpty()) {
                exchange.setStatusCode(400);
                exchange.endExchange();
                return null;
            }
            String nn = URLDecoder.decode(newName.getFirst(), StandardCharsets.UTF_8);
            this.ctx.rename(name, nn);
            return null;
        }
    }

    private static final class ListBindingsHandler
    extends AbstractNamingHandler {
        private ListBindingsHandler(HttpServiceConfig config, Context ctx) {
            super(config, ctx);
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            NamingEnumeration<Binding> namingEnumeration = this.ctx.listBindings(name);
            return Collections.list(namingEnumeration);
        }
    }

    private static final class UnbindHandler
    extends AbstractNamingHandler {
        private UnbindHandler(HttpServiceConfig config, Context ctx) {
            super(config, ctx);
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            this.ctx.unbind(name);
            return null;
        }
    }

    private static final class CreateSubContextHandler
    extends AbstractNamingHandler {
        private CreateSubContextHandler(HttpServiceConfig config, Context ctx) {
            super(config, ctx);
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return this.ctx.createSubcontext(name);
        }
    }

    private static final class LookupLinkHandler
    extends AbstractNamingHandler {
        private LookupLinkHandler(HttpServiceConfig config, Context ctx) {
            super(config, ctx);
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return this.ctx.lookupLink(name);
        }
    }

    private static final class LookupHandler
    extends AbstractNamingHandler {
        private LookupHandler(HttpServiceConfig config, Context ctx) {
            super(config, ctx);
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return this.ctx.lookup(name);
        }
    }

    private static abstract class AbstractNamingHandler
    implements HttpHandler {
        protected final Context ctx;
        protected final HttpServiceConfig config;
        protected final Function<String, Boolean> classFilter;

        private AbstractNamingHandler(HttpServiceConfig config, Context ctx) {
            this(config, ctx, null);
        }

        private AbstractNamingHandler(HttpServiceConfig config, Context ctx, Function<String, Boolean> classFilter) {
            this.ctx = ctx;
            this.classFilter = classFilter;
            this.config = config;
        }

        @Override
        public final void handleRequest(HttpServerExchange exchange) throws Exception {
            block11: {
                PathTemplateMatch params = exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY);
                String name = URLDecoder.decode(params.getParameters().get("name"), StandardCharsets.UTF_8);
                try {
                    ByteOutput out;
                    Object result = this.doOperation(exchange, name);
                    if (exchange.isComplete()) {
                        return;
                    }
                    if (result == null) {
                        exchange.setStatusCode(200);
                        break block11;
                    }
                    if (result instanceof Context) {
                        exchange.setStatusCode(204);
                        break block11;
                    }
                    HeadersHelper.putResponseHeader(exchange, Headers.CONTENT_TYPE, Constants.VALUE);
                    HttpNamingServerObjectResolver resolver = new HttpNamingServerObjectResolver(exchange);
                    Marshaller marshaller = this.config.getHttpMarshallerFactory(exchange).createMarshaller(resolver);
                    try (ByteOutput byteOutput = out = ByteOutputs.byteOutputOf(exchange.getOutputStream());){
                        marshaller.start(out);
                        Serializer.serializeObject(marshaller, result);
                        marshaller.finish();
                    }
                }
                catch (Throwable e) {
                    HttpServerHelper.sendException(exchange, this.config, 500, e);
                }
            }
        }

        protected abstract Object doOperation(HttpServerExchange var1, String var2) throws NamingException;
    }
}

