/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.protocols.BaseBundler;
import org.jgroups.util.ConcurrentLinkedBlockingQueue;
import org.jgroups.util.FastArray;

public class TransferQueueBundler
extends BaseBundler
implements Runnable {
    protected BlockingQueue<Message> queue;
    protected List<Message> remove_queue;
    protected Thread bundler_thread;
    protected volatile boolean running = true;
    protected static final String THREAD_NAME = "TQ-Bundler";

    @Override
    @ManagedAttribute(description="Size of the queue")
    public int getQueueSize() {
        return this.queue.size();
    }

    @ManagedAttribute(description="Size of the remove-queue")
    public int removeQueueSize() {
        return this.remove_queue.size();
    }

    @Override
    @ManagedAttribute(description="Capacity of the remove-queue")
    public int removeQueueCapacity() {
        return ((FastArray)this.remove_queue).capacity();
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            this.stop();
        }
        this.queue = new ConcurrentLinkedBlockingQueue<Message>(this.capacity, true, false);
        if (this.remove_queue_capacity == 0) {
            this.remove_queue_capacity = Math.max(this.capacity / 4, 1024);
        }
        this.remove_queue = new FastArray<Message>(this.remove_queue_capacity);
        this.bundler_thread = this.transport.getThreadFactory().newThread(this, THREAD_NAME);
        this.running = true;
        this.bundler_thread.start();
    }

    @Override
    public synchronized void stop() {
        this.running = false;
        Thread tmp = this.bundler_thread;
        this.bundler_thread = null;
        if (tmp != null) {
            tmp.interrupt();
            if (tmp.isAlive()) {
                try {
                    tmp.join(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.drain();
    }

    @Override
    public void renameThread() {
        this.transport.getThreadFactory().renameThread(THREAD_NAME, this.bundler_thread);
    }

    @Override
    public int size() {
        return super.size() + this.removeQueueSize() + this.getQueueSize();
    }

    @Override
    public void send(Message msg) throws Exception {
        if (!this.running) {
            return;
        }
        if (!this.queue.offer(msg)) {
            this.num_drops_on_full_queue.increment();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            Message msg = null;
            try {
                msg = this.queue.take();
                if (msg == null) continue;
                this.addAndSendIfSizeExceeded(msg);
                while (true) {
                    this.remove_queue.clear();
                    int num_msgs = this.queue.drainTo(this.remove_queue, this.remove_queue_capacity);
                    if (num_msgs <= 0) break;
                    this.avg_remove_queue_size.add(num_msgs);
                    this.remove_queue.forEach(this::addAndSendIfSizeExceeded);
                }
                if (this.count <= 0L) continue;
                if (this.transport.statsEnabled()) {
                    this.avg_fill_count.add(this.count);
                }
                this.sendBundledMessages();
                this.num_sends_because_no_msgs.increment();
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                this.log.trace("%s: failed sending message: %s", this.transport.addr(), t);
            }
        }
    }

    protected void addAndSendIfSizeExceeded(Message msg) {
        int size = msg.size();
        if (this.count + (long)size > (long)this.max_size) {
            if (this.transport.statsEnabled()) {
                this.avg_fill_count.add(this.count);
            }
            this.sendBundledMessages();
            this.num_sends_because_full_queue.increment();
        }
        this.addMessage(msg, size);
    }

    protected void drain() {
        if (this.queue != null) {
            Message msg;
            while ((msg = (Message)this.queue.poll()) != null) {
                this.addAndSendIfSizeExceeded(msg);
            }
        }
        if (!this.msgs.isEmpty()) {
            this.sendBundledMessages();
        }
    }
}

