/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.ToDoubleFunction;
import org.wildfly.clustering.function.IntPredicate;
import org.wildfly.clustering.function.LongPredicate;
import org.wildfly.clustering.function.Predicate;

public interface DoublePredicate
extends java.util.function.DoublePredicate {
    public static final DoublePredicate ALWAYS = value -> true;
    public static final DoublePredicate NEVER = value -> false;
    public static final DoublePredicate POSITIVE = DoublePredicate.greaterThan(0.0);
    public static final DoublePredicate ZERO = DoublePredicate.equalTo(0.0);
    public static final DoublePredicate NEGATIVE = DoublePredicate.lessThan(0.0);

    default public <V> Predicate<V> compose(final ToDoubleFunction<V> function) {
        return new Predicate<V>(){

            @Override
            public boolean test(V value) {
                return DoublePredicate.this.test(function.applyAsDouble(value));
            }
        };
    }

    default public DoublePredicate composeDouble(final DoubleUnaryOperator function) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return DoublePredicate.this.test(function.applyAsDouble(value));
            }
        };
    }

    default public IntPredicate composeInt(final IntToDoubleFunction function) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return DoublePredicate.this.test(function.applyAsDouble(value));
            }
        };
    }

    default public LongPredicate composeLong(final LongToDoubleFunction function) {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                return DoublePredicate.this.test(function.applyAsDouble(value));
            }
        };
    }

    @Override
    default public DoublePredicate and(final java.util.function.DoublePredicate other) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return DoublePredicate.this.test(value) && other.test(value);
            }
        };
    }

    @Override
    default public DoublePredicate negate() {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return !DoublePredicate.this.test(value);
            }
        };
    }

    @Override
    default public DoublePredicate or(final java.util.function.DoublePredicate other) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return DoublePredicate.this.test(value) || other.test(value);
            }
        };
    }

    default public DoublePredicate xor(final java.util.function.DoublePredicate other) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return DoublePredicate.this.test(value) ^ other.test(value);
            }
        };
    }

    public static DoublePredicate of(boolean result) {
        return result ? ALWAYS : NEVER;
    }

    public static DoublePredicate lessThan(final double base) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return Double.compare(value, base) < 0;
            }
        };
    }

    public static DoublePredicate equalTo(final double base) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return Double.compare(base, value) == 0;
            }
        };
    }

    public static DoublePredicate greaterThan(final double base) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return Double.compare(value, base) > 0;
            }
        };
    }
}

