/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.function.Function;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.validation.ModuleNameValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.service.ServiceDependency;

public class ModuleAttributeDefinition
extends SimpleAttributeDefinition
implements ResourceModelResolver<ServiceDependency<Module>> {
    ModuleAttributeDefinition(Builder builder) {
        super((AbstractAttributeDefinitionBuilder)builder);
    }

    public ServiceDependency<Module> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final String moduleId = this.resolveModelAttribute(context, model).asStringOrNull();
        if (moduleId == null) {
            return ServiceDependency.of(null);
        }
        ServiceDependency loader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        return loader.map((Function)new Function<ModuleLoader, Module>(){

            @Override
            public Module apply(ModuleLoader loader) {
                try {
                    return loader.loadModule(moduleId);
                }
                catch (ModuleLoadException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, ModuleAttributeDefinition> {
        public Builder() {
            this("module");
        }

        public Builder(String attributeName) {
            super(attributeName, ModelType.STRING);
            this.setAllowExpression(true);
            this.setAttributeParser(AttributeParser.SIMPLE);
            this.setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
        }

        public Builder(String attributeName, ModuleAttributeDefinition basis) {
            super(attributeName, (AttributeDefinition)basis);
        }

        public Builder setDefaultValue(Module defaultModule) {
            this.setRequired(false);
            return (Builder)this.setDefaultValue(defaultModule != null ? new ModelNode(defaultModule.getName()) : null);
        }

        public ModuleAttributeDefinition build() {
            this.setValidator(ModuleNameValidator.INSTANCE);
            return new ModuleAttributeDefinition(this);
        }
    }
}

