/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.service.AbstractService;
import org.jboss.as.service.component.ServiceComponentInstantiator;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class CreateDestroyService
extends AbstractService {
    private final Method createMethod;
    private final Method destroyMethod;
    private final ServiceComponentInstantiator componentInstantiator;
    private final Map<Method, Supplier<Object>> injections = new HashMap<Method, Supplier<Object>>();
    private ManagedReference managedReference;

    CreateDestroyService(Object mBeanInstance, Method createMethod, Method destroyMethod, ServiceComponentInstantiator componentInstantiator, List<SetupAction> setupActions, ClassLoader mbeanContextClassLoader, Consumer<Object> mBeanInstanceConsumer) {
        super(mBeanInstance, setupActions, mbeanContextClassLoader, mBeanInstanceConsumer);
        this.createMethod = createMethod;
        this.destroyMethod = destroyMethod;
        this.componentInstantiator = componentInstantiator;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Creating Service: %s", context.getController().provides());
        }
        try {
            this.injectDependencies();
            this.invokeLifecycleMethod(this.createMethod, (LifecycleContext)context);
            if (this.componentInstantiator != null) {
                this.managedReference = this.componentInstantiator.initializeInstance(this.mBeanInstance);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.uninjectDependencies();
            throw new StartException(SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod("create()"), (Throwable)e);
        }
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Destroying Service: %s", context.getController().provides());
        }
        try {
            if (this.managedReference != null) {
                this.managedReference.release();
            }
            this.invokeLifecycleMethod(this.destroyMethod, (LifecycleContext)context);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            SarLogger.ROOT_LOGGER.error(SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod("destroy()"), e);
        }
        finally {
            this.uninjectDependencies();
        }
    }

    void inject(Method setter, Supplier<Object> injectionSupplier) {
        this.injections.put(setter, injectionSupplier);
    }

    private void injectDependencies() throws IllegalAccessException, InvocationTargetException {
        for (Map.Entry<Method, Supplier<Object>> injection : this.injections.entrySet()) {
            Method setter = injection.getKey();
            Object arg = injection.getValue().get();
            setter.invoke(this.mBeanInstance, arg);
        }
    }

    private void uninjectDependencies() {
        for (Map.Entry<Method, Supplier<Object>> injection : this.injections.entrySet()) {
            try {
                Method setter = injection.getKey();
                setter.invoke(this.mBeanInstance, (Object[])null);
            }
            catch (Throwable throwable) {}
        }
    }
}

