/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanResource;
import org.jboss.as.platform.mbean.LeafPlatformMBeanResource;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;

public class MemoryManagerMXBeanResource
extends AbstractPlatformMBeanResource {
    MemoryManagerMXBeanResource() {
        super(PlatformMBeanConstants.MEMORY_MANAGER_PATH);
    }

    @Override
    Resource.ResourceEntry getChildEntry(String name) {
        for (MemoryManagerMXBean mbean : ManagementFactory.getMemoryManagerMXBeans()) {
            if (!name.equals(PlatformMBeanUtil.escapeMBeanName(mbean.getName())) || !mbean.getObjectName().getKeyProperty("type").equals(PlatformMBeanConstants.MEMORY_MANAGER_TYPE)) continue;
            return new LeafPlatformMBeanResource(PathElement.pathElement((String)"name", (String)name));
        }
        return null;
    }

    @Override
    Set<String> getChildrenNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (MemoryManagerMXBean mbean : ManagementFactory.getMemoryManagerMXBeans()) {
            if (!mbean.getObjectName().getKeyProperty("type").equals(PlatformMBeanConstants.MEMORY_MANAGER_TYPE)) continue;
            result.add(PlatformMBeanUtil.escapeMBeanName(mbean.getName()));
        }
        return result;
    }

    public Set<String> getChildTypes() {
        return Collections.singleton("name");
    }
}

