/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence.xml;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.FeatureFilter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.xml.NamedResourceRegistrationXMLElement;
import org.jboss.as.controller.persistence.xml.ResourceRegistrationXMLElement;
import org.jboss.as.controller.persistence.xml.ResourceXMLChoice;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLChoice;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElement;
import org.jboss.as.controller.xml.XMLElementGroup;
import org.jboss.as.controller.xml.XMLParticle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.Functions;

public interface NamedResourceRegistrationXMLChoice
extends ResourceXMLChoice {

    public static class DefaultResourceRegistrationXMLChoice
    extends XMLChoice.DefaultXMLElementChoice<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode>
    implements NamedResourceRegistrationXMLChoice {
        DefaultResourceRegistrationXMLChoice(final ResourceRegistration registration, final QName pathValueAttributeName, final Map<QName, Map<PathElement, ResourceRegistrationXMLElement>> choices, final Function<PathElement, ResourceRegistrationXMLElement> elements, XMLCardinality cardinality) {
            super(choices.keySet(), cardinality, new ExceptionFunction<XMLExtendedStreamReader, XMLElement<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode>, XMLStreamException>(){

                public XMLElement<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode> apply(XMLExtendedStreamReader reader) throws XMLStreamException {
                    Map choice = (Map)choices.get(reader.getName());
                    if (choice != null) {
                        String value = reader.getAttributeValue(null, pathValueAttributeName.getLocalPart());
                        if (value == null) {
                            throw ParseUtils.missingRequired(reader, pathValueAttributeName.getLocalPart());
                        }
                        ResourceRegistrationXMLElement element = (ResourceRegistrationXMLElement)choice.get(PathElement.pathElement(registration.getPathElement().getKey(), value));
                        return element != null ? element : (XMLElement)choice.get(registration.getPathElement());
                    }
                    return null;
                }
            }, Functions.discardingConsumer(), new XMLContentWriter<ModelNode>(){

                public void writeContent(XMLExtendedStreamWriter writer, ModelNode parent) throws XMLStreamException {
                    String key = registration.getPathElement().getKey();
                    if (parent.hasDefined(key)) {
                        for (Property property : parent.get(key).asPropertyListOrEmpty()) {
                            String value = property.getName();
                            ModelNode model = property.getValue();
                            PathElement path = PathElement.pathElement(key, value);
                            ModelNode parentWrapper = new ModelNode();
                            parentWrapper.get(path.getKeyValuePair()).set(model);
                            ((ResourceRegistrationXMLElement)elements.apply(path)).getWriter().writeContent(writer, parentWrapper);
                        }
                    }
                }

                @Override
                public boolean isEmpty(ModelNode parent) {
                    String pathKey = registration.getPathElement().getKey();
                    return !parent.hasDefined(pathKey) || parent.get(pathKey).asPropertyListOrEmpty().isEmpty();
                }
            }, registration.getStability());
        }
    }

    public static class DefaultBuilder
    extends XMLParticle.AbstractBuilder<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode, NamedResourceRegistrationXMLChoice, Builder>
    implements Builder {
        static final Comparator<PathElement> PATH_COMPARATOR = Comparator.comparing(PathElement::getValue);
        private final NamedResourceRegistrationXMLElement element;
        private final Map<PathElement, ResourceRegistrationXMLElement> overrides = new TreeMap<PathElement, ResourceRegistrationXMLElement>(PATH_COMPARATOR);
        private final FeatureFilter filter;

        DefaultBuilder(NamedResourceRegistrationXMLElement element, FeatureFilter filter) {
            Assert.assertTrue((boolean)element.getPathElement().isWildcard());
            this.element = element;
            this.filter = filter;
        }

        @Override
        protected Builder builder() {
            return this;
        }

        @Override
        public Builder addElement(NamedResourceRegistrationXMLElement element) {
            PathElement path = element.getPathElement();
            PathElement wildcardPath = this.element.getPathElement();
            if (path.isWildcard() || !path.getKey().equals(wildcardPath.getKey())) {
                throw ControllerLogger.ROOT_LOGGER.invalidOverridePath(path, wildcardPath);
            }
            if (this.filter.enables(element) && element.getCardinality().isEnabled() && this.overrides.putIfAbsent(path, element) != null) {
                throw ControllerLogger.ROOT_LOGGER.duplicatePathElement(path);
            }
            return this;
        }

        @Override
        public NamedResourceRegistrationXMLChoice build() {
            PathElement wildcardPath = this.element.getPathElement();
            QName pathValueAttributeName = this.element.getResourceAttributeName();
            XMLCardinality cardinality = this.getCardinality();
            Function<PathElement, ResourceRegistrationXMLElement> elements = path -> this.overrides.getOrDefault(path, this.element);
            TreeMap<QName, Map<PathElement, ResourceRegistrationXMLElement>> choices = new TreeMap<QName, Map<PathElement, ResourceRegistrationXMLElement>>(QNameResolver.COMPARATOR);
            TreeMap<PathElement, NamedResourceRegistrationXMLElement> defaultChoice = new TreeMap<PathElement, NamedResourceRegistrationXMLElement>(PATH_COMPARATOR);
            defaultChoice.put(wildcardPath, this.element);
            choices.put(this.element.getName(), defaultChoice);
            for (ResourceRegistrationXMLElement override : this.overrides.values()) {
                TreeMap<PathElement, ResourceRegistrationXMLElement> choiceElements = (TreeMap<PathElement, ResourceRegistrationXMLElement>)choices.get(override.getName());
                if (choiceElements == null) {
                    choiceElements = new TreeMap<PathElement, ResourceRegistrationXMLElement>(PATH_COMPARATOR);
                    choices.put(override.getName(), choiceElements);
                }
                choiceElements.put(override.getPathElement(), override);
            }
            return new DefaultResourceRegistrationXMLChoice(this.element, pathValueAttributeName, choices, elements, cardinality);
        }
    }

    public static interface Builder
    extends XMLElementGroup.Builder<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode, NamedResourceRegistrationXMLElement, NamedResourceRegistrationXMLChoice, Builder> {
    }
}

