/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.types.converter.spi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.function.Function;
import org.hibernate.search.engine.backend.types.converter.FromDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.cfg.spi.FormatUtils;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.annotation.Incubating;

@Incubating
public final class DefaultStringConverters {
    public static final Converter<BigDecimal> BIG_DECIMAL = new Converter<BigDecimal>(ParseUtils::parseBigDecimal, FormatUtils::format);
    public static final Converter<BigInteger> BIG_INTEGER = new Converter<BigInteger>(ParseUtils::parseBigInteger, FormatUtils::format);
    public static final Converter<Boolean> BOOLEAN = new Converter<Boolean>(ParseUtils::parseBoolean, FormatUtils::format);
    public static final Converter<Byte> BYTE = new Converter<Byte>(ParseUtils::parseByte, FormatUtils::format);
    public static final Converter<Double> DOUBLE = new Converter<Double>(ParseUtils::parseDouble, FormatUtils::format);
    public static final Converter<Float> FLOAT = new Converter<Float>(ParseUtils::parseFloat, FormatUtils::format);
    public static final Converter<GeoPoint> GEO_POINT = new Converter<GeoPoint>(ParseUtils::parseGeoPoint, FormatUtils::format);
    public static final Converter<Instant> INSTANT = new Converter<Instant>(ParseUtils::parseInstant, FormatUtils::format);
    public static final Converter<Integer> INTEGER = new Converter<Integer>(ParseUtils::parseInteger, FormatUtils::format);
    public static final Converter<LocalDate> LOCAL_DATE = new Converter<LocalDate>(ParseUtils::parseLocalDate, FormatUtils::format);
    public static final Converter<LocalDateTime> LOCAL_DATE_TIME = new Converter<LocalDateTime>(ParseUtils::parseLocalDateTime, FormatUtils::format);
    public static final Converter<LocalTime> LOCAL_TIME = new Converter<LocalTime>(ParseUtils::parseLocalTime, FormatUtils::format);
    public static final Converter<Long> LONG = new Converter<Long>(ParseUtils::parseLong, FormatUtils::format);
    public static final Converter<MonthDay> MONTH_DAY = new Converter<MonthDay>(ParseUtils::parseMonthDay, FormatUtils::format);
    public static final Converter<OffsetDateTime> OFFSET_DATE_TIME = new Converter<OffsetDateTime>(ParseUtils::parseOffsetDateTime, FormatUtils::format);
    public static final Converter<OffsetTime> OFFSET_TIME = new Converter<OffsetTime>(ParseUtils::parseOffsetTime, FormatUtils::format);
    public static final Converter<Short> SHORT = new Converter<Short>(ParseUtils::parseShort, FormatUtils::format);
    public static final Converter<String> STRING = new Converter<String>(ParseUtils::parseString, FormatUtils::format);
    public static final Converter<Year> YEAR = new Converter<Year>(ParseUtils::parseYear, FormatUtils::format);
    public static final Converter<YearMonth> YEAR_MONTH = new Converter<YearMonth>(ParseUtils::parseYearMonth, FormatUtils::format);
    public static final Converter<ZonedDateTime> ZONED_DATE_TIME = new Converter<ZonedDateTime>(ParseUtils::parseZonedDateTime, FormatUtils::format);

    private DefaultStringConverters() {
    }

    public static class Converter<F>
    implements ToDocumentValueConverter<String, F>,
    FromDocumentValueConverter<F, String> {
        private final Function<String, F> parseDelegate;
        private final Function<F, String> formatDelegate;

        private Converter(Function<String, F> parseDelegate, Function<F, String> formatDelegate) {
            this.parseDelegate = parseDelegate;
            this.formatDelegate = formatDelegate;
        }

        @Override
        public F toDocumentValue(String value, ToDocumentValueConvertContext context) {
            return value == null ? null : (F)this.parseDelegate.apply(value);
        }

        @Override
        public boolean isCompatibleWith(ToDocumentValueConverter<?, ?> other) {
            return other == this;
        }

        @Override
        public String fromDocumentValue(F value, FromDocumentValueConvertContext context) {
            if (value == null) {
                return null;
            }
            return this.formatDelegate.apply(value);
        }
    }
}

