/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.util.Iterator;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.server.infinispan.scheduler.Scheduler;

public class CacheKeysTask<K, V>
implements java.util.function.Consumer<CacheStreamFilter<K>> {
    private final Cache<K, V> cache;
    private final Predicate<? super K> filter;
    private final java.util.function.Consumer<K> task;

    public static <I, K extends Key<I>, V, M> CacheKeysTask<K, V> schedule(Cache<K, V> cache, Predicate<? super K> filter, Scheduler<I, M> scheduler) {
        Consumer schedule = scheduler::schedule;
        return new CacheKeysTask<K, V>(cache, filter, schedule.compose(Key::getId));
    }

    public static <I, K extends Key<I>, V, M> CacheKeysTask<K, V> cancel(Cache<K, V> cache, Predicate<? super K> filter, Scheduler<I, M> scheduler) {
        Consumer cancel = arg_0 -> scheduler.cancel(arg_0);
        return new CacheKeysTask<K, V>(cache, filter, cancel.compose(Key::getId));
    }

    public CacheKeysTask(Cache<K, V> cache, Predicate<? super K> filter, java.util.function.Consumer<K> task) {
        this.cache = cache;
        this.filter = filter;
        this.task = task;
    }

    @Override
    public void accept(CacheStreamFilter<K> filter) {
        try (CacheStream stream = ((CacheStream)filter.apply((Object)this.cache.keySet().stream())).filter(this.filter);){
            Iterator keys = stream.iterator();
            while (keys.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                this.task.accept(keys.next());
            }
        }
    }
}

