/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.query.core.impl.Log;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.LogFactory;

@Listener(observation=Listener.Observation.POST)
final class SegmentListener {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private final Consumer<IntSet> segmentDeleted;
    private final Address address;
    private final BlockingManager blockingManager;

    SegmentListener(Address address, Consumer<IntSet> segmentsDeleted, BlockingManager blockingManager) {
        this.segmentDeleted = segmentsDeleted;
        this.address = address;
        this.blockingManager = blockingManager;
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<?, ?> event) {
        if (event.isPre()) {
            return CompletableFutures.completedNull();
        }
        ConsistentHash newWriteCh = event.getWriteConsistentHashAtEnd();
        if (!newWriteCh.getMembers().contains(this.address)) {
            return CompletableFutures.completedNull();
        }
        IntSet removedSegments = IntSets.mutableCopyFrom((Set)event.getWriteConsistentHashAtStart().getSegmentsForOwner(this.address));
        removedSegments.removeAll(IntSets.from((Set)newWriteCh.getSegmentsForOwner(this.address)));
        if (removedSegments.isEmpty()) {
            return CompletableFutures.completedNull();
        }
        return this.blockingManager.runBlocking(() -> this.segmentDeleted.accept(removedSegments), (Object)this).exceptionally(throwable -> {
            log.failedToPurgeIndexForSegments(throwable, removedSegments);
            return null;
        });
    }
}

