/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.Name;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.x500.X500Principal;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.LdapUtils;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;
import org.apache.cxf.sts.token.realm.RealmSupport;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;

public class LdapGroupClaimsHandler
implements ClaimsHandler,
RealmSupport {
    private static final Logger LOG = LogUtils.getL7dLogger(LdapGroupClaimsHandler.class);
    private static final String SCOPE = "%SCOPE%";
    private static final String ROLE = "%ROLE%";
    private LdapTemplate ldap;
    private String userBaseDn;
    private String groupBaseDn;
    private String userObjectClass = "person";
    private String groupObjectClass = "groupOfNames";
    private String userNameAttribute = "cn";
    private String groupMemberAttribute = "member";
    private String groupURI = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";
    private String groupNameGlobalFilter = "%ROLE%";
    private String groupNameScopedFilter = "%SCOPE%_%ROLE%";
    private Map<String, String> appliesToScopeMapping;
    private boolean useFullGroupNameAsValue;
    private List<String> supportedRealms;
    private List<Filter> customFilters;
    private String realm;

    public void setSupportedRealms(List<String> supportedRealms) {
        this.supportedRealms = supportedRealms;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public boolean isUseFullGroupNameAsValue() {
        return this.useFullGroupNameAsValue;
    }

    public void setUseFullGroupNameAsValue(boolean useFullGroupNameAsValue) {
        this.useFullGroupNameAsValue = useFullGroupNameAsValue;
    }

    public String getUserObjectClass() {
        return this.userObjectClass;
    }

    public void setUserObjectClass(String userObjectClass) {
        this.userObjectClass = userObjectClass;
    }

    public String getGroupObjectClass() {
        return this.groupObjectClass;
    }

    public void setGroupObjectClass(String groupObjectClass) {
        this.groupObjectClass = groupObjectClass;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldap = ldapTemplate;
    }

    public LdapTemplate getLdapTemplate() {
        return this.ldap;
    }

    public void setUserBaseDN(String userBaseDN) {
        this.userBaseDn = userBaseDN;
    }

    public String getUserBaseDN() {
        return this.userBaseDn;
    }

    public String getGroupMemberAttribute() {
        return this.groupMemberAttribute;
    }

    public void setGroupMemberAttribute(String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
    }

    public String getGroupURI() {
        return this.groupURI;
    }

    public void setGroupURI(String groupURI) {
        this.groupURI = groupURI;
    }

    public void setAppliesToScopeMapping(Map<String, String> appliesToScopeMapping) {
        this.appliesToScopeMapping = appliesToScopeMapping;
    }

    public Map<String, String> getAppliesToScopeMapping() {
        return this.appliesToScopeMapping;
    }

    public String getGroupBaseDN() {
        return this.groupBaseDn;
    }

    public void setGroupBaseDN(String groupBaseDN) {
        this.groupBaseDn = groupBaseDN;
    }

    public String getGroupNameGlobalFilter() {
        return this.groupNameGlobalFilter;
    }

    public void setGroupNameGlobalFilter(String groupNameGlobalFilter) {
        this.groupNameGlobalFilter = groupNameGlobalFilter;
    }

    public String getGroupNameScopedFilter() {
        return this.groupNameScopedFilter;
    }

    public void setGroupNameScopedFilter(String groupNameScopedFilter) {
        this.groupNameScopedFilter = groupNameScopedFilter;
    }

    @Override
    public List<String> getSupportedClaimTypes() {
        return Collections.singletonList(this.groupURI);
    }

    @Override
    public ProcessedClaimCollection retrieveClaimValues(ClaimCollection claims, ClaimsParameters parameters) {
        List<String> groups;
        boolean found = false;
        for (Claim claim : claims) {
            if (!claim.getClaimType().equals(this.groupURI)) continue;
            found = true;
            break;
        }
        if (!found) {
            return new ProcessedClaimCollection();
        }
        String user = null;
        Principal principal = parameters.getPrincipal();
        if (principal instanceof KerberosPrincipal) {
            KerberosPrincipal kp = (KerberosPrincipal)principal;
            StringTokenizer st = new StringTokenizer(kp.getName(), "@");
            user = st.nextToken();
        } else if (principal instanceof X500Principal) {
            X500Principal x500p = (X500Principal)principal;
            LOG.warning("Unsupported principal type X500: " + x500p.getName());
        } else if (principal != null) {
            user = principal.getName();
            if (user == null) {
                LOG.warning("Principal name must not be null");
            }
        } else {
            LOG.warning("Principal is null");
        }
        if (user == null) {
            return new ProcessedClaimCollection();
        }
        if (!LdapUtils.isDN(user)) {
            Name dn = LdapUtils.getDnOfEntry(this.ldap, this.userBaseDn, this.getUserObjectClass(), this.getUserNameAttribute(), user);
            if (dn != null) {
                user = dn.toString();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("DN for (" + this.getUserNameAttribute() + "=" + user + ") found: " + user);
                }
            } else {
                LOG.warning("DN not found for user '" + user + "'");
                return new ProcessedClaimCollection();
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Retrieve groups for user " + user);
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add((Filter)new EqualsFilter(this.groupMemberAttribute, user));
        if (this.customFilters != null && !this.customFilters.isEmpty()) {
            filters.addAll(this.customFilters);
        }
        if ((groups = LdapUtils.getAttributeOfEntries(this.ldap, this.groupBaseDn, this.getGroupObjectClass(), filters, "cn")) == null || groups.isEmpty()) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("No groups found for user '" + user + "'");
            }
            return new ProcessedClaimCollection();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Groups for user '" + parameters.getPrincipal().getName() + "': " + String.valueOf(groups));
        }
        String scope = null;
        if (this.getAppliesToScopeMapping() != null && !this.getAppliesToScopeMapping().isEmpty() && parameters.getAppliesToAddress() != null) {
            scope = this.getAppliesToScopeMapping().get(parameters.getAppliesToAddress());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("AppliesTo matches with scope: " + scope);
            }
        }
        String regex = this.groupNameGlobalFilter;
        regex = regex.replaceAll(ROLE, ".*");
        Pattern globalPattern = Pattern.compile(regex);
        Pattern scopePattern = null;
        if (scope != null) {
            regex = this.groupNameScopedFilter;
            regex = regex.replaceAll(SCOPE, scope).replaceAll(ROLE, ".*");
            scopePattern = Pattern.compile(regex);
        }
        ArrayList<String> filteredGroups = new ArrayList<String>();
        for (String group : groups) {
            if (scopePattern != null && scopePattern.matcher(group).matches()) {
                String filter = this.groupNameScopedFilter;
                String role = this.isUseFullGroupNameAsValue() ? group : this.parseRole(group, filter.replaceAll(SCOPE, scope));
                filteredGroups.add(role);
                continue;
            }
            if (globalPattern.matcher(group).matches()) {
                String role = this.isUseFullGroupNameAsValue() ? group : this.parseRole(group, this.groupNameGlobalFilter);
                filteredGroups.add(role);
                continue;
            }
            if (!LOG.isLoggable(Level.FINER)) continue;
            LOG.finer("Group '" + group + "' doesn't match scoped and global group filter");
        }
        LOG.info("Filtered groups: " + String.valueOf(filteredGroups));
        if (filteredGroups.isEmpty()) {
            LOG.info("No matching groups found for user '" + String.valueOf(principal) + "'");
            return new ProcessedClaimCollection();
        }
        ProcessedClaimCollection claimsColl = new ProcessedClaimCollection();
        ProcessedClaim c = new ProcessedClaim();
        c.setClaimType(URI.create(this.groupURI));
        c.setPrincipal(principal);
        c.setValues(new ArrayList(filteredGroups));
        claimsColl.add(c);
        return claimsColl;
    }

    @Override
    public List<String> getSupportedRealms() {
        return this.supportedRealms;
    }

    @Override
    public String getHandlerRealm() {
        return this.realm;
    }

    private String parseRole(String group, String filter) {
        int roleStart = filter.indexOf(ROLE);
        int trimEnd = filter.length() - ROLE.length() - roleStart;
        return group.substring(roleStart, group.length() - trimEnd);
    }

    public List<Filter> getCustomFilters() {
        return this.customFilters;
    }

    public void setCustomFilters(List<Filter> customFilters) {
        this.customFilters = customFilters;
    }
}

