/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Policy;
import io.reactivex.rxjava3.core.Flowable;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ObjIntConsumer;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.EntrySizeCalculator;
import org.infinispan.commons.util.FilterIterator;
import org.infinispan.commons.util.FilterSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntrySizeCalculator;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.PrimitiveEntrySizeCalculator;
import org.infinispan.container.impl.AbstractInternalDataContainer;
import org.infinispan.container.impl.PeekableTouchableCaffeineMap;
import org.infinispan.container.impl.PeekableTouchableContainerMap;
import org.infinispan.container.impl.PeekableTouchableMap;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.marshall.core.WrappedByteArraySizeCalculator;
import org.reactivestreams.Publisher;

@ThreadSafe
public class DefaultDataContainer<K, V>
extends AbstractInternalDataContainer<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final PeekableTouchableMap<K, V> entries;
    private final Cache<K, InternalCacheEntry<K, V>> evictionCache;

    public DefaultDataContainer(int concurrencyLevel) {
        this.entries = new PeekableTouchableContainerMap(new ConcurrentHashMap(128));
        this.evictionCache = null;
    }

    protected DefaultDataContainer(int concurrencyLevel, long thresholdSize, EvictionType thresholdPolicy) {
        AbstractInternalDataContainer.DefaultEvictionListener evictionListener = new AbstractInternalDataContainer.DefaultEvictionListener();
        Caffeine caffeine = DefaultDataContainer.caffeineBuilder();
        switch (thresholdPolicy) {
            case MEMORY: {
                CacheEntrySizeCalculator calc = new CacheEntrySizeCalculator(new WrappedByteArraySizeCalculator((EntrySizeCalculator<?, ?>)new PrimitiveEntrySizeCalculator()));
                caffeine.weigher((k, v) -> (int)calc.calculateSize(k, v)).maximumWeight(thresholdSize);
                break;
            }
            case COUNT: {
                caffeine.maximumSize(thresholdSize);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Policy not supported: " + String.valueOf((Object)thresholdPolicy));
            }
        }
        this.evictionCache = this.applyListener(caffeine, evictionListener).build();
        this.entries = new PeekableTouchableCaffeineMap<K, V>(this.evictionCache);
    }

    protected DefaultDataContainer(int concurrencyLevel, long thresholdSize, EntrySizeCalculator<? super K, ? super V> sizeCalculator) {
        this(thresholdSize, (EntrySizeCalculator<? super K, InternalCacheEntry<? super K, V>>)new CacheEntrySizeCalculator<K, V>(sizeCalculator));
    }

    protected DefaultDataContainer(long thresholdSize, EntrySizeCalculator<? super K, ? super InternalCacheEntry<K, V>> sizeCalculator) {
        AbstractInternalDataContainer.DefaultEvictionListener evictionListener = new AbstractInternalDataContainer.DefaultEvictionListener();
        this.evictionCache = this.applyListener(Caffeine.newBuilder().weigher((k, v) -> (int)sizeCalculator.calculateSize(k, v)).maximumWeight(thresholdSize), evictionListener).build();
        this.entries = new PeekableTouchableCaffeineMap<K, V>(this.evictionCache);
    }

    public static <K, V> DefaultDataContainer<K, V> boundedDataContainer(int concurrencyLevel, long maxEntries, EvictionType thresholdPolicy) {
        return new DefaultDataContainer<K, V>(concurrencyLevel, maxEntries, thresholdPolicy);
    }

    public static <K, V> DefaultDataContainer<K, V> boundedDataContainer(int concurrencyLevel, long maxEntries, EntrySizeCalculator<? super K, ? super V> sizeCalculator) {
        return new DefaultDataContainer<K, V>(concurrencyLevel, maxEntries, sizeCalculator);
    }

    public static <K, V> DefaultDataContainer<K, V> unBoundedDataContainer(int concurrencyLevel) {
        return new DefaultDataContainer<K, V>(concurrencyLevel);
    }

    @Override
    protected PeekableTouchableMap<K, V> getMapForSegment(int segment) {
        return this.entries;
    }

    @Override
    protected int getSegmentForKey(Object key) {
        return -1;
    }

    private Policy.Eviction<K, InternalCacheEntry<K, V>> eviction() {
        Optional eviction;
        if (this.evictionCache != null && (eviction = this.evictionCache.policy().eviction()).isPresent()) {
            return (Policy.Eviction)eviction.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long capacity() {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        return evict.getMaximum();
    }

    @Override
    public void resize(long newSize) {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        evict.setMaximum(newSize);
    }

    @Override
    public int sizeIncludingExpired() {
        return this.entries.size();
    }

    @Override
    public void clear(IntSet segments) {
        Iterator<InternalCacheEntry<K, V>> iter = this.iteratorIncludingExpired(segments);
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    @Stop
    public void clear() {
        log.tracef("Clearing data container", new Object[0]);
        this.entries.clear();
    }

    @Override
    public Publisher<InternalCacheEntry<K, V>> publisher(IntSet segments) {
        return Flowable.fromIterable(() -> this.iterator(segments));
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator() {
        return new AbstractInternalDataContainer.EntryIterator(this.entries.values().iterator());
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator(IntSet segments) {
        return new FilterIterator(this.iterator(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliterator() {
        return this.filterExpiredEntries(this.spliteratorIncludingExpired());
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliterator(IntSet segments) {
        return new FilterSpliterator(this.spliterator(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired() {
        return this.entries.values().spliterator();
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired(IntSet segments) {
        return new FilterSpliterator(this.spliteratorIncludingExpired(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired() {
        return this.entries.values().iterator();
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired(IntSet segments) {
        return new FilterIterator(this.iteratorIncludingExpired(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public long evictionSize() {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        return evict.weightedSize().orElse(this.entries.size());
    }

    @Override
    public void addSegments(IntSet segments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSegments(IntSet segments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanUp() {
        if (this.evictionCache != null) {
            this.evictionCache.cleanUp();
        }
    }

    @Override
    public void forEachSegment(ObjIntConsumer<PeekableTouchableMap<K, V>> segmentMapConsumer) {
        segmentMapConsumer.accept(this.entries, 0);
    }
}

