/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.cpu.CacheInfo;
import io.smallrye.common.cpu.ProcessorInfo;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.management.ManagementFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.threads.ContextClassLoaderSavingRunnable;
import org.jboss.threads.ContextHandler;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.Messages;
import org.jboss.threads.NullRunnable;
import org.jboss.threads.TimeUtil;
import org.jboss.threads.Version;
import org.jboss.threads.Waiter;
import org.jboss.threads.management.ManageableThreadPoolExecutorService;
import org.jboss.threads.management.StandardThreadPoolMXBean;

public final class EnhancedQueueExecutor
extends AbstractExecutorService
implements ManageableThreadPoolExecutorService,
ScheduledExecutorService {
    private static final Thread[] NO_THREADS = new Thread[0];
    private static final VarHandle objArrayHandle = MethodHandles.arrayElementVarHandle(TaskNode[].class);
    private static final VarHandle longArrayHandle = MethodHandles.arrayElementVarHandle(long[].class);
    private static final VarHandle terminationWaitersHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "terminationWaiters", VarHandle.class, EnhancedQueueExecutor.class, Waiter.class);
    private static final VarHandle peakThreadCountHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "peakThreadCount", VarHandle.class, EnhancedQueueExecutor.class, Integer.TYPE);
    private static final VarHandle activeCountHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "activeCount", VarHandle.class, EnhancedQueueExecutor.class, Integer.TYPE);
    private static final VarHandle peakQueueSizeHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "peakQueueSize", VarHandle.class, EnhancedQueueExecutor.class, Integer.TYPE);
    public static final boolean DISABLE_HINT;
    static final boolean UPDATE_STATISTICS;
    static final boolean UPDATE_ACTIVE_COUNT;
    static final boolean NO_QUEUE_LIMIT;
    static final boolean REGISTER_MBEAN;
    static final boolean DISABLE_MBEAN;
    static final int PARK_SPINS;
    static final int YIELD_FACTOR;
    static final Executor DEFAULT_HANDLER;
    private final ThreadFactory threadFactory;
    private final Set<Thread> runningThreads = Collections.newSetFromMap(new ConcurrentHashMap());
    private final MXBeanImpl mxBean;
    private final Object handle;
    private volatile AccessControlContext acc;
    private final ContextHandler<?> contextHandler;
    private final SchedulerTask schedulerTask = new SchedulerTask();
    private final Thread schedulerThread;
    final TaskNode[] unsharedTaskNodes = new TaskNode[RuntimeFields.unsharedTaskNodesSize];
    final long[] unsharedLongs = new long[RuntimeFields.unsharedLongsSize];
    volatile Waiter terminationWaiters;
    volatile long timeoutNanos;
    volatile float growthResistance;
    volatile Executor handoffExecutor;
    volatile Thread.UncaughtExceptionHandler exceptionHandler;
    volatile Runnable terminationTask;
    volatile int peakThreadCount;
    volatile int peakQueueSize;
    private final boolean queueLimited;
    private final LongAdder submittedTaskCounter = new LongAdder();
    private final LongAdder completedTaskCounter = new LongAdder();
    private final LongAdder rejectedTaskCounter = new LongAdder();
    private final LongAdder spinMisses = new LongAdder();
    volatile int activeCount;
    private static final int numUnsharedLongs = 2;
    private static final int numUnsharedObjects = 2;
    private static final long TS_THREAD_CNT_MASK = 1048575L;
    private static final long TS_CURRENT_SHIFT = 0L;
    private static final long TS_CORE_SHIFT = 20L;
    private static final long TS_MAX_SHIFT = 40L;
    private static final long TS_ALLOW_CORE_TIMEOUT = 0x1000000000000000L;
    private static final long TS_SHUTDOWN_REQUESTED = 0x2000000000000000L;
    private static final long TS_SHUTDOWN_INTERRUPT = 0x4000000000000000L;
    private static final long TS_SHUTDOWN_COMPLETE = Long.MIN_VALUE;
    private static final int EXE_OK = 0;
    private static final int EXE_REJECT_QUEUE_FULL = 1;
    private static final int EXE_REJECT_SHUTDOWN = 2;
    private static final int EXE_CREATE_THREAD = 3;
    private static final int AT_YES = 0;
    private static final int AT_NO = 1;
    private static final int AT_SHUTDOWN = 2;
    static final QNode TERMINATE_REQUESTED;
    static final QNode TERMINATE_COMPLETE;
    static final Waiter TERMINATE_COMPLETE_WAITER;
    static final Runnable WAITING;
    static final Runnable GAVE_UP;
    static final Runnable ACCEPTED;
    static final Runnable EXIT;
    static final AtomicInteger sequence;
    static final int ASF_ST_WAITING = 0;
    static final int ASF_ST_CANCELLED = 1;
    static final int ASF_ST_CANCEL_PENDING = 2;
    static final int ASF_ST_SUBMITTED = 3;
    static final int ASF_ST_RUNNING = 4;
    static final int ASF_ST_FINISHED = 5;
    static final int ASF_ST_FAILED = 6;
    static final int ASF_ST_REJECTED = 7;
    static final AbstractScheduledFuture<?>[] NO_FUTURES;
    static final AtomicLong SCHEDULED_TASK_SEQ;

    EnhancedQueueExecutor(Builder builder) {
        this.setHeadPlain(this.setTailPlain(new TaskNode(null)));
        int maxSize = builder.getMaximumPoolSize();
        int coreSize = Math.min(builder.getCorePoolSize(), maxSize);
        this.handoffExecutor = builder.getHandoffExecutor();
        this.exceptionHandler = builder.getExceptionHandler();
        this.threadFactory = builder.getThreadFactory();
        this.schedulerThread = this.threadFactory.newThread(this.schedulerTask);
        String schedulerName = this.schedulerThread.getName();
        this.schedulerThread.setName(schedulerName + " (scheduler)");
        this.terminationTask = builder.getTerminationTask();
        this.growthResistance = builder.getGrowthResistance();
        this.contextHandler = builder.getContextHandler();
        Duration keepAliveTime = builder.getKeepAliveTime();
        this.setThreadStatusPlain(EnhancedQueueExecutor.withCoreSize(EnhancedQueueExecutor.withMaxSize(EnhancedQueueExecutor.withAllowCoreTimeout(0L, builder.allowsCoreThreadTimeOut()), maxSize), coreSize));
        this.timeoutNanos = TimeUtil.clampedPositiveNanos(keepAliveTime);
        this.queueLimited = builder.getQueueLimited();
        int maximumQueueSize = this.getQueueLimited() ? builder.getMaximumQueueSize() : Integer.MAX_VALUE;
        this.setQueueSizePlain(EnhancedQueueExecutor.withMaxQueueSize(EnhancedQueueExecutor.withCurrentQueueSize(0L, 0), maximumQueueSize));
        this.mxBean = new MXBeanImpl();
        if (!DISABLE_MBEAN && builder.isRegisterMBean()) {
            this.acc = AccessController.getContext();
            String configuredName = builder.getMBeanName();
            String finalName = configuredName != null ? configuredName : "threadpool-" + sequence.getAndIncrement();
            this.handle = AccessController.doPrivileged(new MBeanRegisterAction(finalName, this.mxBean), this.acc);
        } else {
            this.handle = null;
            this.acc = null;
        }
    }

    private boolean getQueueLimited() {
        return !NO_QUEUE_LIMIT && this.queueLimited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        Assert.checkNotNullParam("runnable", runnable);
        Task realRunnable = new Task(runnable, this.contextHandler.captureContext());
        int result = this.tryExecute(realRunnable);
        boolean ok = false;
        if (result == 0) {
            if (EnhancedQueueExecutor.currentSizeOf(this.getThreadStatus()) == 0 && this.tryAllocateThread(0.0f) == 0 && !this.doStartThread(null)) {
                this.deallocateThread();
            }
            if (UPDATE_STATISTICS) {
                this.submittedTaskCounter.increment();
            }
            return;
        }
        if (result == 3) {
            try {
                ok = this.doStartThread(realRunnable);
            }
            finally {
                if (!ok) {
                    this.deallocateThread();
                }
            }
        } else {
            if (UPDATE_STATISTICS) {
                this.rejectedTaskCounter.increment();
            }
            if (result == 2) {
                this.rejectShutdown(realRunnable);
            } else {
                assert (result == 1);
                this.rejectQueueFull(realRunnable);
            }
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown(true);
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        TaskNode[] unsharedTaskNodes = this.unsharedTaskNodes;
        TaskNode head = EnhancedQueueExecutor.getHead(unsharedTaskNodes);
        while (true) {
            QNode headNext;
            if ((headNext = head.getNext()) == head) {
                head = EnhancedQueueExecutor.getHead(unsharedTaskNodes);
                continue;
            }
            if (!(headNext instanceof TaskNode)) break;
            TaskNode taskNode = (TaskNode)headNext;
            if (!EnhancedQueueExecutor.compareAndSetHead(unsharedTaskNodes, head, taskNode)) continue;
            head.setNextOrdered(head);
            if (this.getQueueLimited()) {
                this.decreaseQueueSize();
            }
            head = taskNode;
            list.add(taskNode.task.handoff());
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return EnhancedQueueExecutor.isShutdownRequested(this.getThreadStatus());
    }

    @Override
    public boolean isTerminated() {
        return EnhancedQueueExecutor.isShutdownComplete(this.getThreadStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Assert.checkMinimumParameter("timeout", 0L, timeout);
        Assert.checkNotNullParam("unit", unit);
        if (timeout > 0L) {
            Thread thread = Thread.currentThread();
            if (this.runningThreads.contains(thread) || thread == this.schedulerThread) {
                throw Messages.msg.cannotAwaitWithin();
            }
            Waiter waiters = this.terminationWaiters;
            if (waiters == TERMINATE_COMPLETE_WAITER) {
                return true;
            }
            Waiter waiter = new Waiter(waiters);
            waiter.setThread(Thread.currentThread());
            while (!this.compareAndSetTerminationWaiters(waiters, waiter)) {
                waiters = this.terminationWaiters;
                if (waiters == TERMINATE_COMPLETE_WAITER) {
                    return true;
                }
                waiter.setNext(waiters);
            }
            try {
                LockSupport.parkNanos(this, unit.toNanos(timeout));
            }
            finally {
                waiter.setThread(null);
            }
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.isTerminated();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.startScheduleThread();
        return this.schedulerTask.schedule(new RunnableScheduledFuture(command, delay, unit));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.startScheduleThread();
        return this.schedulerTask.schedule(new CallableScheduledFuture<V>(callable, delay, unit));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.startScheduleThread();
        return this.schedulerTask.schedule(new FixedRateRunnableScheduledFuture(command, initialDelay, period, unit));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.startScheduleThread();
        return this.schedulerTask.schedule(new FixedDelayRunnableScheduledFuture(command, initialDelay, delay, unit));
    }

    private void startScheduleThread() {
        if (this.schedulerThread.getState() == Thread.State.NEW) {
            try {
                this.schedulerThread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public StandardThreadPoolMXBean getThreadPoolMXBean() {
        return this.mxBean;
    }

    public void shutdown(boolean interrupt) {
        long newStatus;
        long oldStatus;
        block16: {
            do {
                oldStatus = this.getThreadStatus();
                newStatus = EnhancedQueueExecutor.withShutdownRequested(oldStatus);
                if (interrupt) {
                    newStatus = EnhancedQueueExecutor.withShutdownInterrupt(newStatus);
                }
                if (EnhancedQueueExecutor.currentSizeOf(oldStatus) == 0) {
                    newStatus = EnhancedQueueExecutor.withShutdownComplete(newStatus);
                }
                if (newStatus != oldStatus) continue;
                return;
            } while (!this.compareAndSetThreadStatus(oldStatus, newStatus));
            assert (oldStatus != newStatus);
            if (EnhancedQueueExecutor.isShutdownRequested(newStatus) != EnhancedQueueExecutor.isShutdownRequested(oldStatus)) {
                QNode tailNext;
                block15: {
                    PoolThreadNode node;
                    assert (!EnhancedQueueExecutor.isShutdownRequested(oldStatus));
                    this.schedulerTask.shutdown();
                    TaskNode tail = this.getTail();
                    while (true) {
                        if ((tailNext = tail.getNext()) instanceof TaskNode) {
                            tail = (TaskNode)tailNext;
                            continue;
                        }
                        if (!(tailNext instanceof PoolThreadNode) && tailNext != null) break block15;
                        node = (PoolThreadNode)tailNext;
                        if (tail.compareAndSetNext(node, TERMINATE_REQUESTED)) break;
                    }
                    while (node != null) {
                        node.compareAndSetTask(WAITING, EXIT);
                        node.unpark();
                        node = node.getNext();
                    }
                    break block16;
                }
                if (!(tailNext instanceof TerminateWaiterNode)) {
                    throw Assert.unreachableCode();
                }
            }
        }
        if (EnhancedQueueExecutor.isShutdownInterrupt(newStatus) != EnhancedQueueExecutor.isShutdownInterrupt(oldStatus)) {
            assert (!EnhancedQueueExecutor.isShutdownInterrupt(oldStatus));
            for (Thread thread : this.runningThreads) {
                thread.interrupt();
            }
        }
        if (EnhancedQueueExecutor.isShutdownComplete(newStatus) != EnhancedQueueExecutor.isShutdownComplete(oldStatus)) {
            assert (!EnhancedQueueExecutor.isShutdownComplete(oldStatus));
            this.completeTermination();
        }
    }

    public boolean isTerminating() {
        long threadStatus = this.getThreadStatus();
        return EnhancedQueueExecutor.isShutdownRequested(threadStatus) && !EnhancedQueueExecutor.isShutdownComplete(threadStatus);
    }

    public boolean prestartCoreThread() {
        if (this.tryAllocateThread(1.0f) != 0) {
            return false;
        }
        if (this.doStartThread(null)) {
            return true;
        }
        this.deallocateThread();
        return false;
    }

    public int prestartAllCoreThreads() {
        int cnt = 0;
        while (this.prestartCoreThread()) {
            ++cnt;
        }
        return cnt;
    }

    public float getGrowthResistance() {
        return this.growthResistance;
    }

    public void setGrowthResistance(float growthResistance) {
        Assert.checkMinimumParameter("growthResistance", 0.0f, growthResistance);
        Assert.checkMaximumParameter("growthResistance", 1.0f, growthResistance);
        this.growthResistance = growthResistance;
    }

    public int getCorePoolSize() {
        return EnhancedQueueExecutor.coreSizeOf(this.getThreadStatus());
    }

    public void setCorePoolSize(int corePoolSize) {
        long newVal;
        long oldVal;
        Assert.checkMinimumParameter("corePoolSize", 0, corePoolSize);
        Assert.checkMaximumParameter("corePoolSize", 1048575L, (long)corePoolSize);
        while (!this.compareAndSetThreadStatus(oldVal, newVal = corePoolSize > EnhancedQueueExecutor.maxSizeOf(oldVal = this.getThreadStatus()) ? EnhancedQueueExecutor.withCoreSize(EnhancedQueueExecutor.withMaxSize(oldVal, corePoolSize), corePoolSize) : EnhancedQueueExecutor.withCoreSize(oldVal, corePoolSize))) {
        }
        if (EnhancedQueueExecutor.maxSizeOf(newVal) < EnhancedQueueExecutor.maxSizeOf(oldVal) || EnhancedQueueExecutor.coreSizeOf(newVal) < EnhancedQueueExecutor.coreSizeOf(oldVal)) {
            for (Thread activeThread : this.runningThreads) {
                LockSupport.unpark(activeThread);
            }
        }
    }

    public int getMaximumPoolSize() {
        return EnhancedQueueExecutor.maxSizeOf(this.getThreadStatus());
    }

    public void setMaximumPoolSize(int maxPoolSize) {
        long newVal;
        long oldVal;
        Assert.checkMinimumParameter("maxPoolSize", 0, maxPoolSize);
        Assert.checkMaximumParameter("maxPoolSize", 1048575L, (long)maxPoolSize);
        while (!this.compareAndSetThreadStatus(oldVal, newVal = maxPoolSize < EnhancedQueueExecutor.coreSizeOf(oldVal = this.getThreadStatus()) ? EnhancedQueueExecutor.withCoreSize(EnhancedQueueExecutor.withMaxSize(oldVal, maxPoolSize), maxPoolSize) : EnhancedQueueExecutor.withMaxSize(oldVal, maxPoolSize))) {
        }
        if (EnhancedQueueExecutor.maxSizeOf(newVal) < EnhancedQueueExecutor.maxSizeOf(oldVal) || EnhancedQueueExecutor.coreSizeOf(newVal) < EnhancedQueueExecutor.coreSizeOf(oldVal)) {
            for (Thread activeThread : this.runningThreads) {
                LockSupport.unpark(activeThread);
            }
        }
    }

    public boolean allowsCoreThreadTimeOut() {
        return EnhancedQueueExecutor.isAllowCoreTimeout(this.getThreadStatus());
    }

    public void allowCoreThreadTimeOut(boolean value) {
        long newVal;
        long oldVal;
        do {
            if ((oldVal = this.getThreadStatus()) != (newVal = EnhancedQueueExecutor.withAllowCoreTimeout(oldVal, value))) continue;
            return;
        } while (!this.compareAndSetThreadStatus(oldVal, newVal));
        if (value) {
            for (Thread activeThread : this.runningThreads) {
                LockSupport.unpark(activeThread);
            }
        }
    }

    @Deprecated
    public long getKeepAliveTime(TimeUnit keepAliveUnits) {
        Assert.checkNotNullParam("keepAliveUnits", keepAliveUnits);
        return keepAliveUnits.convert(this.timeoutNanos, TimeUnit.NANOSECONDS);
    }

    public Duration getKeepAliveTime() {
        return Duration.of(this.timeoutNanos, ChronoUnit.NANOS);
    }

    @Deprecated
    public void setKeepAliveTime(long keepAliveTime, TimeUnit keepAliveUnits) {
        Assert.checkMinimumParameter("keepAliveTime", 1L, keepAliveTime);
        Assert.checkNotNullParam("keepAliveUnits", keepAliveUnits);
        this.timeoutNanos = Math.max(1L, keepAliveUnits.toNanos(keepAliveTime));
    }

    public void setKeepAliveTime(Duration keepAliveTime) {
        Assert.checkNotNullParam("keepAliveTime", keepAliveTime);
        this.timeoutNanos = TimeUtil.clampedPositiveNanos(keepAliveTime);
    }

    public int getMaximumQueueSize() {
        return EnhancedQueueExecutor.maxQueueSizeOf(this.getQueueSizeVolatile());
    }

    public void setMaximumQueueSize(int maxQueueSize) {
        long oldVal;
        Assert.checkMinimumParameter("maxQueueSize", 0, maxQueueSize);
        Assert.checkMaximumParameter("maxQueueSize", Integer.MAX_VALUE, maxQueueSize);
        if (!this.getQueueLimited()) {
            return;
        }
        while (!this.compareAndSetQueueSize(oldVal = this.getQueueSizeVolatile(), EnhancedQueueExecutor.withMaxQueueSize(oldVal, maxQueueSize))) {
        }
    }

    public Executor getHandoffExecutor() {
        return this.handoffExecutor;
    }

    public void setHandoffExecutor(Executor handoffExecutor) {
        Assert.checkNotNullParam("handoffExecutor", handoffExecutor);
        this.handoffExecutor = handoffExecutor;
    }

    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        Assert.checkNotNullParam("exceptionHandler", exceptionHandler);
        this.exceptionHandler = exceptionHandler;
    }

    public void setTerminationTask(Runnable terminationTask) {
        this.terminationTask = terminationTask;
    }

    public int getQueueSize() {
        return !this.getQueueLimited() ? -1 : EnhancedQueueExecutor.currentQueueSizeOf(this.getQueueSizeVolatile());
    }

    public int getLargestPoolSize() {
        return UPDATE_STATISTICS ? this.peakThreadCount : -1;
    }

    public int getActiveCount() {
        return UPDATE_ACTIVE_COUNT ? this.activeCount : -1;
    }

    public int getLargestQueueSize() {
        return UPDATE_STATISTICS && this.getQueueLimited() ? this.peakQueueSize : -1;
    }

    public long getSubmittedTaskCount() {
        return UPDATE_STATISTICS ? this.submittedTaskCounter.longValue() : -1L;
    }

    public long getRejectedTaskCount() {
        return UPDATE_STATISTICS ? this.rejectedTaskCounter.longValue() : -1L;
    }

    public long getCompletedTaskCount() {
        return UPDATE_STATISTICS ? this.completedTaskCounter.longValue() : -1L;
    }

    public int getPoolSize() {
        return EnhancedQueueExecutor.currentSizeOf(this.getThreadStatus());
    }

    public Thread[] getRunningThreads() {
        return this.runningThreads.toArray(NO_THREADS);
    }

    private void runThreadBody() {
        LongAdder spinMisses = this.spinMisses;
        TaskNode[] unsharedTaskNodes = this.unsharedTaskNodes;
        PoolThreadNode nextPoolThreadNode = new PoolThreadNode(Thread.currentThread());
        block0: while (true) {
            TaskNode head;
            QNode headNext;
            if ((headNext = (head = EnhancedQueueExecutor.getHead(unsharedTaskNodes)).getNext()) != head) {
                if (headNext == null || headNext instanceof PoolThreadNode) {
                    nextPoolThreadNode.setNextRelaxed(headNext);
                    if (head.compareAndSetNext(headNext, nextPoolThreadNode)) {
                        PoolThreadNode newNode = nextPoolThreadNode;
                        long start = System.nanoTime();
                        long elapsed = 0L;
                        while (true) {
                            Runnable task = newNode.getTask();
                            assert (task != ACCEPTED && task != GAVE_UP && task != null);
                            if (task != WAITING && task != EXIT) {
                                if (newNode.compareAndSetTask(task, ACCEPTED)) {
                                    task.run();
                                    nextPoolThreadNode = new PoolThreadNode(Thread.currentThread());
                                    continue block0;
                                }
                                if (!UPDATE_STATISTICS) continue;
                                spinMisses.increment();
                                continue;
                            }
                            long timeoutNanos = this.timeoutNanos;
                            long oldVal = this.getThreadStatus();
                            if (elapsed >= timeoutNanos || task == EXIT || EnhancedQueueExecutor.currentSizeOf(oldVal) > EnhancedQueueExecutor.maxSizeOf(oldVal)) {
                                if (task == EXIT || EnhancedQueueExecutor.isShutdownRequested(oldVal) || EnhancedQueueExecutor.isAllowCoreTimeout(oldVal) || EnhancedQueueExecutor.currentSizeOf(oldVal) > EnhancedQueueExecutor.coreSizeOf(oldVal)) {
                                    if (!newNode.compareAndSetTask(task, GAVE_UP)) continue;
                                    while (true) {
                                        if (this.tryDeallocateThread(oldVal)) {
                                            this.runningThreads.remove(Thread.currentThread());
                                            return;
                                        }
                                        if (UPDATE_STATISTICS) {
                                            spinMisses.increment();
                                        }
                                        oldVal = this.getThreadStatus();
                                    }
                                }
                                if (elapsed >= timeoutNanos) {
                                    newNode.park(this);
                                } else {
                                    newNode.park(this, timeoutNanos - elapsed);
                                }
                                Thread.interrupted();
                                elapsed = System.nanoTime() - start;
                                continue;
                            }
                            assert (task == WAITING);
                            newNode.park(this, timeoutNanos - elapsed);
                            Thread.interrupted();
                            elapsed = System.nanoTime() - start;
                        }
                    }
                    if (headNext != null) {
                        nextPoolThreadNode.setNextRelaxed(null);
                    }
                } else if (headNext instanceof TaskNode) {
                    TaskNode taskNode = (TaskNode)headNext;
                    if (EnhancedQueueExecutor.compareAndSetHead(unsharedTaskNodes, head, taskNode)) {
                        head.setNextOrdered(head);
                        if (this.getQueueLimited()) {
                            this.decreaseQueueSize();
                        }
                        taskNode.getAndClearTask().run();
                        continue;
                    }
                } else {
                    assert (headNext instanceof TerminateWaiterNode);
                    this.runningThreads.remove(Thread.currentThread());
                    this.deallocateThread();
                    return;
                }
            }
            if (!UPDATE_STATISTICS) continue;
            this.spinMisses.increment();
        }
    }

    int tryAllocateThread(float growthResistance) {
        long oldStat;
        while (!EnhancedQueueExecutor.isShutdownRequested(oldStat = this.getThreadStatus())) {
            int oldSize = EnhancedQueueExecutor.currentSizeOf(oldStat);
            if (oldSize >= EnhancedQueueExecutor.maxSizeOf(oldStat)) {
                return 1;
            }
            if (oldSize >= EnhancedQueueExecutor.coreSizeOf(oldStat) && oldSize > 0 && growthResistance != 0.0f && (growthResistance == 1.0f || ThreadLocalRandom.current().nextFloat() < growthResistance)) {
                return 1;
            }
            int newSize = oldSize + 1;
            if (this.compareAndSetThreadStatus(oldStat, EnhancedQueueExecutor.withCurrentSize(oldStat, newSize))) {
                if (UPDATE_STATISTICS) {
                    int oldVal;
                    while ((oldVal = this.peakThreadCount) < newSize && !this.compareAndSetPeakThreadCount(oldVal, newSize)) {
                    }
                }
                return 0;
            }
            if (!UPDATE_STATISTICS) continue;
            this.spinMisses.increment();
        }
        return 2;
    }

    void deallocateThread() {
        long oldStat;
        while (!this.tryDeallocateThread(oldStat = this.getThreadStatus())) {
        }
    }

    boolean tryDeallocateThread(long oldStat) {
        long newStat = EnhancedQueueExecutor.withCurrentSize(oldStat, EnhancedQueueExecutor.currentSizeOf(oldStat) - 1);
        if (EnhancedQueueExecutor.currentSizeOf(newStat) == 0 && EnhancedQueueExecutor.isShutdownRequested(oldStat)) {
            newStat = EnhancedQueueExecutor.withShutdownComplete(newStat);
        }
        if (!this.compareAndSetThreadStatus(oldStat, newStat)) {
            return false;
        }
        if (EnhancedQueueExecutor.isShutdownComplete(newStat)) {
            this.completeTermination();
        }
        return true;
    }

    boolean doStartThread(Task runnable) throws RejectedExecutionException {
        Thread thread;
        try {
            thread = this.threadFactory.newThread(new ThreadBody(runnable));
        }
        catch (Throwable t) {
            if (runnable != null) {
                if (UPDATE_STATISTICS) {
                    this.rejectedTaskCounter.increment();
                }
                this.rejectException(runnable, t);
            }
            return false;
        }
        if (thread == null) {
            if (runnable != null) {
                if (UPDATE_STATISTICS) {
                    this.rejectedTaskCounter.increment();
                }
                this.rejectNoThread(runnable);
            }
            return false;
        }
        try {
            thread.start();
        }
        catch (Throwable t) {
            if (runnable != null) {
                if (UPDATE_STATISTICS) {
                    this.rejectedTaskCounter.increment();
                }
                this.rejectException(runnable, t);
            }
            return false;
        }
        return true;
    }

    private int tryExecute(Task runnable) {
        TaskNode tail = this.getTail();
        TaskNode node = null;
        while (true) {
            QNode tailNext;
            if ((tailNext = tail.getNext()) != tail) {
                if (tailNext == null) {
                    int tr = this.tryAllocateThread(this.growthResistance);
                    if (tr == 0) {
                        return 3;
                    }
                    if (tr == 2) {
                        return 2;
                    }
                    assert (tr == 1);
                    if (this.getQueueLimited() && !this.increaseQueueSize()) {
                        tr = this.tryAllocateThread(0.0f);
                        if (tr == 0) {
                            return 3;
                        }
                        if (tr == 2) {
                            return 2;
                        }
                        assert (tr == 1);
                        return 1;
                    }
                    if (node == null) {
                        node = new TaskNode(runnable);
                    }
                    if (tail.compareAndSetNext(null, node)) {
                        this.compareAndSetTail(tail, node);
                        return 0;
                    }
                    if (this.getQueueLimited()) {
                        this.decreaseQueueSize();
                    }
                } else if (tailNext instanceof PoolThreadNode) {
                    QNode tailNextNext = tailNext.getNext();
                    if (tail.compareAndSetNext(tailNext, tailNextNext)) {
                        assert (tail instanceof TaskNode);
                        PoolThreadNode consumerNode = (PoolThreadNode)tailNext;
                        if (consumerNode.compareAndSetTask(WAITING, runnable)) {
                            consumerNode.compareAndSetNext(tailNextNext, null);
                            consumerNode.unpark();
                            return 0;
                        }
                    }
                } else if (tailNext instanceof TaskNode) {
                    TaskNode tailNextTaskNode = (TaskNode)tailNext;
                    if (this.compareAndSetTail(tail, tailNextTaskNode)) {
                        tail = tailNextTaskNode;
                        continue;
                    }
                } else {
                    assert (tailNext instanceof TerminateWaiterNode);
                    return 2;
                }
            }
            if (UPDATE_STATISTICS) {
                this.spinMisses.increment();
            }
            tail = this.getTail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeTermination() {
        boolean intr = Thread.interrupted();
        try {
            Runnable terminationTask = JBossExecutors.classLoaderPreservingTask(this.terminationTask);
            this.terminationTask = null;
            try {
                terminationTask.run();
            }
            catch (Throwable t) {
                try {
                    this.exceptionHandler.uncaughtException(Thread.currentThread(), t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            for (Waiter waiters = this.getAndSetTerminationWaiters(TERMINATE_COMPLETE_WAITER); waiters != null; waiters = waiters.getNext()) {
                LockSupport.unpark(waiters.getThread());
            }
            this.getTail().setNext(TERMINATE_COMPLETE);
            if (!DISABLE_MBEAN && this.acc != null) {
                Object handle = this.handle;
                if (handle != null) {
                    intr = intr || Thread.interrupted();
                    AccessController.doPrivileged(new MBeanUnregisterAction(handle), this.acc);
                }
                this.acc = null;
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    TaskNode getTail() {
        return objArrayHandle.getVolatile(this.unsharedTaskNodes, RuntimeFields.tailIndex);
    }

    TaskNode setTailPlain(TaskNode tail) {
        this.unsharedTaskNodes[RuntimeFields.tailIndex] = tail;
        return tail;
    }

    boolean compareAndSetTail(TaskNode expect, TaskNode update) {
        return this.getTail() == expect && objArrayHandle.compareAndSet(this.unsharedTaskNodes, RuntimeFields.tailIndex, expect, update);
    }

    static TaskNode getHead(TaskNode[] unsharedTaskNodes) {
        return objArrayHandle.getVolatile(unsharedTaskNodes, RuntimeFields.headIndex);
    }

    TaskNode setHeadPlain(TaskNode head) {
        this.unsharedTaskNodes[RuntimeFields.headIndex] = head;
        return head;
    }

    static boolean compareAndSetHead(TaskNode[] unsharedTaskNodes, TaskNode expect, TaskNode update) {
        return objArrayHandle.compareAndSet(unsharedTaskNodes, RuntimeFields.headIndex, expect, update);
    }

    long getThreadStatus() {
        return longArrayHandle.getVolatile(this.unsharedLongs, RuntimeFields.threadStatusIndex);
    }

    long setThreadStatusPlain(long status) {
        this.unsharedLongs[RuntimeFields.threadStatusIndex] = status;
        return status;
    }

    boolean compareAndSetThreadStatus(long expect, long update) {
        return longArrayHandle.compareAndSet(this.unsharedLongs, RuntimeFields.threadStatusIndex, expect, update);
    }

    void incrementActiveCount() {
        activeCountHandle.getAndAdd(this, 1);
    }

    void decrementActiveCount() {
        activeCountHandle.getAndAdd(this, -1);
    }

    boolean compareAndSetPeakThreadCount(int expect, int update) {
        return peakThreadCountHandle.compareAndSet(this, expect, update);
    }

    boolean compareAndSetPeakQueueSize(int expect, int update) {
        return peakQueueSizeHandle.compareAndSet(this, expect, update);
    }

    long getQueueSizeVolatile() {
        return longArrayHandle.getVolatile(this.unsharedLongs, RuntimeFields.queueSizeIndex);
    }

    long setQueueSizePlain(long queueSize) {
        this.unsharedLongs[RuntimeFields.queueSizeIndex] = queueSize;
        return queueSize;
    }

    boolean compareAndSetQueueSize(long expect, long update) {
        return longArrayHandle.compareAndSet(this.unsharedLongs, RuntimeFields.queueSizeIndex, expect, update);
    }

    boolean compareAndSetTerminationWaiters(Waiter expect, Waiter update) {
        return terminationWaitersHandle.compareAndSet(this, expect, update);
    }

    Waiter getAndSetTerminationWaiters(Waiter update) {
        return terminationWaitersHandle.getAndSet(this, update);
    }

    boolean increaseQueueSize() {
        long oldVal = this.getQueueSizeVolatile();
        int oldSize = EnhancedQueueExecutor.currentQueueSizeOf(oldVal);
        if (oldSize >= EnhancedQueueExecutor.maxQueueSizeOf(oldVal)) {
            return false;
        }
        int newSize = oldSize + 1;
        while (!this.compareAndSetQueueSize(oldVal, EnhancedQueueExecutor.withCurrentQueueSize(oldVal, newSize))) {
            if (UPDATE_STATISTICS) {
                this.spinMisses.increment();
            }
            if ((oldSize = EnhancedQueueExecutor.currentQueueSizeOf(oldVal = this.getQueueSizeVolatile())) >= EnhancedQueueExecutor.maxQueueSizeOf(oldVal)) {
                return false;
            }
            newSize = oldSize + 1;
        }
        if (UPDATE_STATISTICS) {
            while (newSize > (oldSize = this.peakQueueSize) && !this.compareAndSetPeakQueueSize(oldSize, newSize)) {
            }
        }
        return true;
    }

    void decreaseQueueSize() {
        long oldVal = this.getQueueSizeVolatile();
        assert (EnhancedQueueExecutor.currentQueueSizeOf(oldVal) > 0);
        while (!this.compareAndSetQueueSize(oldVal, EnhancedQueueExecutor.withCurrentQueueSize(oldVal, EnhancedQueueExecutor.currentQueueSizeOf(oldVal) - 1))) {
            if (UPDATE_STATISTICS) {
                this.spinMisses.increment();
            }
            oldVal = this.getQueueSizeVolatile();
            assert (EnhancedQueueExecutor.currentQueueSizeOf(oldVal) > 0);
        }
    }

    static int currentQueueSizeOf(long queueSize) {
        return (int)(queueSize & Integer.MAX_VALUE);
    }

    static long withCurrentQueueSize(long queueSize, int current) {
        assert (current >= 0);
        return queueSize & 0xFFFFFFFF00000000L | (long)current;
    }

    static int maxQueueSizeOf(long queueSize) {
        return (int)(queueSize >>> 32 & Integer.MAX_VALUE);
    }

    static long withMaxQueueSize(long queueSize, int max) {
        assert (max >= 0);
        return queueSize & 0xFFFFFFFFL | (long)max << 32;
    }

    static int coreSizeOf(long status) {
        return (int)(status >>> 20 & 0xFFFFFL);
    }

    static int maxSizeOf(long status) {
        return (int)(status >>> 40 & 0xFFFFFL);
    }

    static int currentSizeOf(long status) {
        return (int)(status >>> 0 & 0xFFFFFL);
    }

    static long withCoreSize(long status, int newCoreSize) {
        assert (0 <= newCoreSize && (long)newCoreSize <= 1048575L);
        return status & 0xFFFFFF00000FFFFFL | (long)newCoreSize << 20;
    }

    static long withCurrentSize(long status, int newCurrentSize) {
        assert (0 <= newCurrentSize && (long)newCurrentSize <= 1048575L);
        return status & 0xFFFFFFFFFFF00000L | (long)newCurrentSize << 0;
    }

    static long withMaxSize(long status, int newMaxSize) {
        assert (0 <= newMaxSize && (long)newMaxSize <= 1048575L);
        return status & 0xF00000FFFFFFFFFFL | (long)newMaxSize << 40;
    }

    static long withShutdownRequested(long status) {
        return status | 0x2000000000000000L;
    }

    static long withShutdownComplete(long status) {
        return status | Long.MIN_VALUE;
    }

    static long withShutdownInterrupt(long status) {
        return status | 0x4000000000000000L;
    }

    static long withAllowCoreTimeout(long status, boolean allowed) {
        return allowed ? status | 0x1000000000000000L : status & 0xEFFFFFFFFFFFFFFFL;
    }

    static boolean isShutdownRequested(long status) {
        return (status & 0x2000000000000000L) != 0L;
    }

    static boolean isShutdownComplete(long status) {
        return (status & Long.MIN_VALUE) != 0L;
    }

    static boolean isShutdownInterrupt(long threadStatus) {
        return (threadStatus & 0x4000000000000000L) != 0L;
    }

    static boolean isAllowCoreTimeout(long oldVal) {
        return (oldVal & 0x1000000000000000L) != 0L;
    }

    static int readIntPropertyPrefixed(String name, int defVal) {
        try {
            return Integer.parseInt(EnhancedQueueExecutor.readPropertyPrefixed(name, Integer.toString(defVal)));
        }
        catch (NumberFormatException ignored) {
            return defVal;
        }
    }

    static boolean readBooleanPropertyPrefixed(String name, boolean defVal) {
        return Boolean.parseBoolean(EnhancedQueueExecutor.readPropertyPrefixed(name, Boolean.toString(defVal)));
    }

    static String readPropertyPrefixed(String name, String defVal) {
        return EnhancedQueueExecutor.readProperty("jboss.threads.eqe." + name, defVal);
    }

    static String readProperty(final String name, final String defVal) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return EnhancedQueueExecutor.readPropertyRaw(name, defVal);
                }
            });
        }
        return EnhancedQueueExecutor.readPropertyRaw(name, defVal);
    }

    static String readPropertyRaw(String name, String defVal) {
        return System.getProperty(name, defVal);
    }

    void rejectException(Task task, Throwable cause) {
        try {
            this.handoffExecutor.execute(task.handoff());
        }
        catch (Throwable t) {
            t.addSuppressed(cause);
            throw t;
        }
    }

    void rejectNoThread(Task task) {
        try {
            this.handoffExecutor.execute(task.handoff());
        }
        catch (Throwable t) {
            t.addSuppressed(new RejectedExecutionException("No threads available"));
            throw t;
        }
    }

    void rejectQueueFull(Task task) {
        try {
            this.handoffExecutor.execute(task.handoff());
        }
        catch (Throwable t) {
            t.addSuppressed(new RejectedExecutionException("Queue is full"));
            throw t;
        }
    }

    void rejectShutdown(Task task) {
        try {
            this.handoffExecutor.execute(task.handoff());
        }
        catch (Throwable t) {
            t.addSuppressed(new RejectedExecutionException("Executor is being shut down"));
            throw t;
        }
    }

    static int wrongType() throws ClassCastException {
        throw new ClassCastException("Wrong task type for comparison");
    }

    static {
        Version.getVersionString();
        MBeanUnregisterAction.forceInit();
        DISABLE_HINT = EnhancedQueueExecutor.readBooleanPropertyPrefixed("disable", false);
        UPDATE_STATISTICS = EnhancedQueueExecutor.readBooleanPropertyPrefixed("statistics", false);
        UPDATE_ACTIVE_COUNT = UPDATE_STATISTICS || EnhancedQueueExecutor.readBooleanPropertyPrefixed("statistics.active-count", false);
        NO_QUEUE_LIMIT = EnhancedQueueExecutor.readBooleanPropertyPrefixed("unlimited-queue", false);
        REGISTER_MBEAN = EnhancedQueueExecutor.readBooleanPropertyPrefixed("register-mbean", true);
        DISABLE_MBEAN = EnhancedQueueExecutor.readBooleanPropertyPrefixed("disable-mbean", EnhancedQueueExecutor.readProperty("org.graalvm.nativeimage.imagecode", null) != null);
        PARK_SPINS = EnhancedQueueExecutor.readIntPropertyPrefixed("park-spins", ProcessorInfo.availableProcessors() == 1 ? 0 : 128);
        YIELD_FACTOR = Math.max(Math.min(EnhancedQueueExecutor.readIntPropertyPrefixed("park-yields", 1), PARK_SPINS), 0);
        DEFAULT_HANDLER = JBossExecutors.rejectingExecutor();
        TERMINATE_REQUESTED = new TerminateWaiterNode();
        TERMINATE_COMPLETE = new TerminateWaiterNode();
        TERMINATE_COMPLETE_WAITER = new Waiter(null);
        WAITING = new NullRunnable();
        GAVE_UP = new NullRunnable();
        ACCEPTED = new NullRunnable();
        EXIT = new NullRunnable();
        sequence = new AtomicInteger(1);
        NO_FUTURES = new AbstractScheduledFuture[0];
        SCHEDULED_TASK_SEQ = new AtomicLong();
    }

    final class SchedulerTask
    implements Runnable {
        final long startMark = System.nanoTime();
        final ReentrantLock ql = new ReentrantLock();
        final Condition qc = this.ql.newCondition();
        ScheduledFutureQueue q = new TreeSetQueue();
        boolean shutdownDetected;

        SchedulerTask() {
        }

        void shutdown() {
            this.ql.lock();
            try {
                this.shutdownDetected = true;
                this.qc.signal();
            }
            finally {
                this.ql.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractScheduledFuture<?>[] remainingFutures;
            ScheduledFutureQueue q = this.q;
            long startMark = this.startMark;
            block8: while (true) {
                AbstractScheduledFuture<?> first;
                this.ql.lock();
                try {
                    while (true) {
                        long now = System.nanoTime();
                        if (this.shutdownDetected) {
                            remainingFutures = q.toArray();
                            q.clear();
                            break block8;
                        }
                        if (q.isEmpty()) {
                            try {
                                this.qc.await();
                            }
                            catch (InterruptedException ignored) {}
                            continue;
                        }
                        first = q.first();
                        long firstWhen = first.when;
                        long currentWhen = Math.max(0L, now - startMark);
                        if (firstWhen <= currentWhen) {
                            q.pollFirst();
                            break;
                        }
                        long waitTime = firstWhen - currentWhen;
                        try {
                            this.qc.awaitNanos(waitTime);
                        }
                        catch (InterruptedException e) {}
                    }
                }
                finally {
                    this.ql.unlock();
                }
                first.submit();
            }
            if (remainingFutures.length > 0) {
                for (AbstractScheduledFuture<?> future : remainingFutures) {
                    future.cancel(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T, F extends AbstractScheduledFuture<T>> F schedule(F item) {
            Task wrappingTask = item.wrappingTask;
            if (item.when <= this.age()) {
                item.submit();
                return item;
            }
            this.ql.lock();
            try {
                boolean first;
                if (this.shutdownDetected) {
                    EnhancedQueueExecutor.this.rejectShutdown(wrappingTask);
                    F f = item;
                    return f;
                }
                while (true) {
                    try {
                        first = this.q.insertAndCheckForFirst(item);
                    }
                    catch (QueueFullException ignored) {
                        this.q = this.q.grow();
                        continue;
                    }
                    break;
                }
                if (first) {
                    this.qc.signal();
                }
                F f = item;
                return f;
            }
            finally {
                this.ql.unlock();
            }
        }

        long age() {
            return System.nanoTime() - this.startMark;
        }
    }

    private static final class RuntimeFields {
        private static final int unsharedTaskNodesSize;
        private static final int unsharedLongsSize;
        private static final int headIndex;
        private static final int tailIndex;
        private static final int threadStatusIndex;
        private static final int queueSizeIndex;

        private RuntimeFields() {
        }

        static {
            int cacheLine = CacheInfo.getSmallestDataCacheLineSize();
            if (cacheLine == 0) {
                cacheLine = 64;
            }
            int pad = cacheLine > 128 ? cacheLine : 128;
            int longScale = 8;
            int taskNodeScale = 8;
            unsharedTaskNodesSize = pad / taskNodeScale * 3;
            unsharedLongsSize = pad / longScale * 3;
            headIndex = pad / taskNodeScale;
            tailIndex = pad / taskNodeScale * 2;
            threadStatusIndex = pad / longScale;
            queueSizeIndex = pad / longScale * 2;
        }
    }

    static final class TaskNode
    extends QNode {
        Task task;

        TaskNode(Task task) {
            this.task = task;
        }

        Runnable getAndClearTask() {
            Task result = this.task;
            this.task = null;
            return result;
        }
    }

    final class Task
    implements Runnable {
        private final Runnable delegate;
        private final ClassLoader contextClassLoader;
        private final Object context;

        Task(Runnable delegate, Object context) {
            Assert.checkNotNullParam("delegate", delegate);
            this.delegate = delegate;
            this.context = context;
            this.contextClassLoader = JBossExecutors.getContextClassLoader(Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (EnhancedQueueExecutor.isShutdownInterrupt(EnhancedQueueExecutor.this.getThreadStatus())) {
                Thread.currentThread().interrupt();
            } else {
                Thread.interrupted();
            }
            if (UPDATE_ACTIVE_COUNT) {
                EnhancedQueueExecutor.this.incrementActiveCount();
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader old = JBossExecutors.getAndSetContextClassLoader(currentThread, this.contextClassLoader);
            try {
                this.doRunWith(this.delegate, this.context);
            }
            catch (Throwable t) {
                try {
                    EnhancedQueueExecutor.this.exceptionHandler.uncaughtException(Thread.currentThread(), t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                JBossExecutors.setContextClassLoader(currentThread, old);
            }
            Thread.interrupted();
            if (UPDATE_ACTIVE_COUNT) {
                EnhancedQueueExecutor.this.decrementActiveCount();
                if (UPDATE_STATISTICS) {
                    EnhancedQueueExecutor.this.completedTaskCounter.increment();
                }
            }
        }

        private <T> void doRunWith(Runnable delegate, Object context) {
            EnhancedQueueExecutor.this.contextHandler.runWith(delegate, context);
        }

        Runnable handoff() {
            return new ContextClassLoaderSavingRunnable(this.contextClassLoader, this.delegate);
        }

        public String toString() {
            return "Task{delegate=" + String.valueOf(this.delegate) + ", contextClassLoader=" + String.valueOf(this.contextClassLoader) + "}";
        }
    }

    public static final class Builder {
        private ThreadFactory threadFactory = Executors.defaultThreadFactory();
        private Runnable terminationTask = NullRunnable.getInstance();
        private Executor handoffExecutor = DEFAULT_HANDLER;
        private Thread.UncaughtExceptionHandler exceptionHandler = JBossExecutors.loggingExceptionHandler();
        private int coreSize = 16;
        private int maxSize = 64;
        private Duration keepAliveTime = Duration.ofSeconds(30L);
        private float growthResistance;
        private boolean allowCoreTimeOut;
        private int maxQueueSize = Integer.MAX_VALUE;
        private boolean registerMBean = REGISTER_MBEAN;
        private String mBeanName;
        private ContextHandler<?> contextHandler = ContextHandler.NONE;
        private boolean queueLimited = true;

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            Assert.checkNotNullParam("threadFactory", threadFactory);
            this.threadFactory = threadFactory;
            return this;
        }

        public Runnable getTerminationTask() {
            return this.terminationTask;
        }

        public Builder setTerminationTask(Runnable terminationTask) {
            Assert.checkNotNullParam("terminationTask", terminationTask);
            this.terminationTask = terminationTask;
            return this;
        }

        public int getCorePoolSize() {
            return this.coreSize;
        }

        public Builder setCorePoolSize(int coreSize) {
            Assert.checkMinimumParameter("coreSize", 0, coreSize);
            Assert.checkMaximumParameter("coreSize", 1048575L, (long)coreSize);
            this.coreSize = coreSize;
            return this;
        }

        public int getMaximumPoolSize() {
            return this.maxSize;
        }

        public Builder setMaximumPoolSize(int maxSize) {
            Assert.checkMinimumParameter("maxSize", 0, maxSize);
            Assert.checkMaximumParameter("maxSize", 1048575L, (long)maxSize);
            this.maxSize = maxSize;
            return this;
        }

        public Duration getKeepAliveTime() {
            return this.keepAliveTime;
        }

        @Deprecated
        public long getKeepAliveTime(TimeUnit keepAliveUnits) {
            Assert.checkNotNullParam("keepAliveUnits", keepAliveUnits);
            long secondsPart = keepAliveUnits.convert(this.keepAliveTime.getSeconds(), TimeUnit.SECONDS);
            long nanoPart = keepAliveUnits.convert(this.keepAliveTime.getNano(), TimeUnit.NANOSECONDS);
            long sum = secondsPart + nanoPart;
            return sum < 0L ? Long.MAX_VALUE : sum;
        }

        public Builder setKeepAliveTime(Duration keepAliveTime) {
            Assert.checkNotNullParam("keepAliveTime", keepAliveTime);
            if (keepAliveTime.compareTo(Duration.ZERO) <= 0) {
                throw Messages.msg.nonPositiveKeepAlive(keepAliveTime);
            }
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        @Deprecated
        public Builder setKeepAliveTime(long keepAliveTime, TimeUnit keepAliveUnits) {
            Assert.checkNotNullParam("keepAliveUnits", keepAliveUnits);
            return this.setKeepAliveTime(Duration.of(keepAliveTime, keepAliveUnits.toChronoUnit()));
        }

        public float getGrowthResistance() {
            return this.growthResistance;
        }

        public Builder setGrowthResistance(float growthResistance) {
            Assert.checkMinimumParameter("growthResistance", 0.0f, growthResistance);
            Assert.checkMaximumParameter("growthResistance", 1.0f, growthResistance);
            this.growthResistance = growthResistance;
            return this;
        }

        public boolean allowsCoreThreadTimeOut() {
            return this.allowCoreTimeOut;
        }

        public Builder allowCoreThreadTimeOut(boolean allowCoreTimeOut) {
            this.allowCoreTimeOut = allowCoreTimeOut;
            return this;
        }

        public int getMaximumQueueSize() {
            return this.maxQueueSize;
        }

        public Builder setMaximumQueueSize(int maxQueueSize) {
            Assert.checkMinimumParameter("maxQueueSize", 0, maxQueueSize);
            Assert.checkMaximumParameter("maxQueueSize", Integer.MAX_VALUE, maxQueueSize);
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public boolean getQueueLimited() {
            return this.queueLimited;
        }

        public Builder setQueueLimited(boolean limit) {
            this.queueLimited = limit;
            return this;
        }

        public Executor getHandoffExecutor() {
            return this.handoffExecutor;
        }

        public Builder setHandoffExecutor(Executor handoffExecutor) {
            Assert.checkNotNullParam("handoffExecutor", handoffExecutor);
            this.handoffExecutor = handoffExecutor;
            return this;
        }

        public Thread.UncaughtExceptionHandler getExceptionHandler() {
            return this.exceptionHandler;
        }

        public Builder setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public EnhancedQueueExecutor build() {
            return new EnhancedQueueExecutor(this);
        }

        public boolean isRegisterMBean() {
            return this.registerMBean;
        }

        public Builder setRegisterMBean(boolean registerMBean) {
            this.registerMBean = registerMBean;
            return this;
        }

        public String getMBeanName() {
            return this.mBeanName;
        }

        public Builder setMBeanName(String mBeanName) {
            this.mBeanName = mBeanName;
            return this;
        }

        public ContextHandler<?> getContextHandler() {
            return this.contextHandler;
        }

        public Builder setContextHandler(ContextHandler<?> contextHandler) {
            Assert.checkNotNullParam("contextHandler", contextHandler);
            this.contextHandler = contextHandler;
            return this;
        }
    }

    final class MXBeanImpl
    implements StandardThreadPoolMXBean {
        MXBeanImpl() {
        }

        @Override
        public float getGrowthResistance() {
            return EnhancedQueueExecutor.this.getGrowthResistance();
        }

        @Override
        public void setGrowthResistance(float value) {
            EnhancedQueueExecutor.this.setGrowthResistance(value);
        }

        @Override
        public boolean isGrowthResistanceSupported() {
            return true;
        }

        @Override
        public int getCorePoolSize() {
            return EnhancedQueueExecutor.this.getCorePoolSize();
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            EnhancedQueueExecutor.this.setCorePoolSize(corePoolSize);
        }

        @Override
        public boolean isCorePoolSizeSupported() {
            return true;
        }

        @Override
        public boolean prestartCoreThread() {
            return EnhancedQueueExecutor.this.prestartCoreThread();
        }

        @Override
        public int prestartAllCoreThreads() {
            return EnhancedQueueExecutor.this.prestartAllCoreThreads();
        }

        @Override
        public boolean isCoreThreadPrestartSupported() {
            return true;
        }

        @Override
        public int getMaximumPoolSize() {
            return EnhancedQueueExecutor.this.getMaximumPoolSize();
        }

        @Override
        public void setMaximumPoolSize(int maxPoolSize) {
            EnhancedQueueExecutor.this.setMaximumPoolSize(maxPoolSize);
        }

        @Override
        public int getPoolSize() {
            return EnhancedQueueExecutor.this.getPoolSize();
        }

        @Override
        public int getLargestPoolSize() {
            return EnhancedQueueExecutor.this.getLargestPoolSize();
        }

        @Override
        public int getActiveCount() {
            return EnhancedQueueExecutor.this.getActiveCount();
        }

        @Override
        public boolean isAllowCoreThreadTimeOut() {
            return EnhancedQueueExecutor.this.allowsCoreThreadTimeOut();
        }

        @Override
        public void setAllowCoreThreadTimeOut(boolean value) {
            EnhancedQueueExecutor.this.allowCoreThreadTimeOut(value);
        }

        @Override
        public long getKeepAliveTimeSeconds() {
            return EnhancedQueueExecutor.this.getKeepAliveTime().getSeconds();
        }

        @Override
        public void setKeepAliveTimeSeconds(long seconds) {
            EnhancedQueueExecutor.this.setKeepAliveTime(Duration.of(seconds, ChronoUnit.SECONDS));
        }

        @Override
        public int getMaximumQueueSize() {
            return EnhancedQueueExecutor.this.getMaximumQueueSize();
        }

        @Override
        public void setMaximumQueueSize(int size) {
            EnhancedQueueExecutor.this.setMaximumQueueSize(size);
        }

        @Override
        public int getQueueSize() {
            return EnhancedQueueExecutor.this.getQueueSize();
        }

        @Override
        public int getLargestQueueSize() {
            return EnhancedQueueExecutor.this.getLargestQueueSize();
        }

        @Override
        public boolean isQueueBounded() {
            return EnhancedQueueExecutor.this.getQueueLimited();
        }

        @Override
        public boolean isQueueSizeModifiable() {
            return EnhancedQueueExecutor.this.getQueueLimited();
        }

        @Override
        public boolean isShutdown() {
            return EnhancedQueueExecutor.this.isShutdown();
        }

        @Override
        public boolean isTerminating() {
            return EnhancedQueueExecutor.this.isTerminating();
        }

        @Override
        public boolean isTerminated() {
            return EnhancedQueueExecutor.this.isTerminated();
        }

        @Override
        public long getSubmittedTaskCount() {
            return EnhancedQueueExecutor.this.getSubmittedTaskCount();
        }

        @Override
        public long getRejectedTaskCount() {
            return EnhancedQueueExecutor.this.getRejectedTaskCount();
        }

        @Override
        public long getCompletedTaskCount() {
            return EnhancedQueueExecutor.this.getCompletedTaskCount();
        }

        @Override
        public long getSpinMissCount() {
            return EnhancedQueueExecutor.this.spinMisses.longValue();
        }
    }

    static final class MBeanRegisterAction
    implements PrivilegedAction<ObjectInstance> {
        private final String finalName;
        private final MXBeanImpl mxBean;

        MBeanRegisterAction(String finalName, MXBeanImpl mxBean) {
            this.finalName = finalName;
            this.mxBean = mxBean;
        }

        @Override
        public ObjectInstance run() {
            try {
                Hashtable<String, String> table = new Hashtable<String, String>();
                table.put("name", ObjectName.quote(this.finalName));
                table.put("type", "thread-pool");
                return ManagementFactory.getPlatformMBeanServer().registerMBean(this.mxBean, new ObjectName("jboss.threads", table));
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    static abstract class QNode {
        private static final VarHandle nextHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "next", VarHandle.class, QNode.class, QNode.class);
        private volatile QNode next;

        QNode() {
        }

        boolean compareAndSetNext(QNode expect, QNode update) {
            return nextHandle.compareAndSet(this, expect, update);
        }

        QNode getNext() {
            return this.next;
        }

        void setNext(QNode node) {
            this.next = node;
        }

        void setNextRelaxed(QNode node) {
            nextHandle.set(this, node);
        }

        void setNextOrdered(QNode node) {
            nextHandle.setOpaque(this, node);
        }
    }

    final class RunnableScheduledFuture
    extends AbstractScheduledFuture<Void> {
        Runnable runnable;

        RunnableScheduledFuture(Runnable runnable, long delay, TimeUnit unit) {
            super(delay, unit);
            this.runnable = runnable;
        }

        @Override
        Void performTask() {
            try {
                this.runnable.run();
            }
            finally {
                this.runnable = null;
            }
            return null;
        }

        @Override
        void doCancel() {
            this.runnable = null;
        }

        @Override
        StringBuilder toString(StringBuilder b) {
            return super.toString(b).append(this.runnable);
        }
    }

    abstract class AbstractScheduledFuture<V>
    implements ScheduledFuture<V>,
    Runnable {
        final long seq = SCHEDULED_TASK_SEQ.getAndIncrement();
        final Task wrappingTask;
        volatile long when;
        volatile int state = 0;
        volatile Object result;
        Thread liveThread;

        AbstractScheduledFuture(long delay, TimeUnit unit) {
            this.when = Math.addExact(EnhancedQueueExecutor.this.schedulerTask.age(), unit.toNanos(delay));
            this.wrappingTask = new Task(this, EnhancedQueueExecutor.this.contextHandler.captureContext());
        }

        @Override
        public int compareTo(Delayed o) {
            return o instanceof AbstractScheduledFuture ? this.compareTo((AbstractScheduledFuture)o) : EnhancedQueueExecutor.wrongType();
        }

        @Override
        public int compareTo(AbstractScheduledFuture<?> other) {
            int cmp = Long.compare(this.when, other.when);
            if (cmp == 0) {
                cmp = Long.compare(this.seq, other.seq);
            }
            return cmp;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(Math.max(0L, this.when - EnhancedQueueExecutor.this.schedulerTask.age()), TimeUnit.NANOSECONDS);
        }

        @Override
        public boolean isCancelled() {
            int state = this.state;
            return state == 1;
        }

        @Override
        public boolean isDone() {
            int state = this.state;
            return state == 5 || state == 6 || state == 1 || state == 7;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                int state = this.state;
                switch (state) {
                    case 0: 
                    case 3: {
                        this.state = 1;
                        this.notifyAll();
                        this.doCancel();
                        return true;
                    }
                    case 2: 
                    case 4: {
                        Thread liveThread;
                        this.state = 2;
                        if (mayInterruptIfRunning && (liveThread = this.liveThread) != null) {
                            liveThread.interrupt();
                        }
                        return true;
                    }
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        }

        void doCancel() {
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                while (true) {
                    int state = this.state;
                    switch (state) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: {
                            this.wait();
                            break;
                        }
                        case 1: {
                            throw new CancellationException("Task was cancelled");
                        }
                        case 7: {
                            throw new ExecutionException("Task failed due to rejection", (RejectedExecutionException)this.result);
                        }
                        case 6: {
                            throw new ExecutionException((Throwable)this.result);
                        }
                        case 5: {
                            return (V)this.result;
                        }
                    }
                }
            }
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long remaining = unit.toNanos(timeout);
            long start = System.nanoTime();
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                while (true) {
                    int state = this.state;
                    switch (state) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: {
                            if (remaining <= 0L) {
                                throw new TimeoutException();
                            }
                            this.wait(remaining / 1000000L, (int)(remaining % 1000000L));
                            break;
                        }
                        case 1: {
                            throw new CancellationException("Task was cancelled");
                        }
                        case 7: {
                            throw new ExecutionException("Task failed due to rejection", (RejectedExecutionException)this.result);
                        }
                        case 6: {
                            throw new ExecutionException((Throwable)this.result);
                        }
                        case 5: {
                            return (V)this.result;
                        }
                    }
                    long newStart = System.nanoTime();
                    long elapsed = newStart - start;
                    remaining -= elapsed;
                    start = newStart;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                switch (this.state) {
                    case 3: {
                        this.state = 4;
                        this.liveThread = Thread.currentThread();
                        break;
                    }
                    case 1: {
                        return;
                    }
                    case 6: 
                    case 7: {
                        return;
                    }
                    default: {
                        this.fail(this.badState());
                        return;
                    }
                }
            }
            try {
                this.finish(this.performTask());
            }
            catch (Throwable t) {
                this.fail(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submit() {
            block23: {
                AbstractScheduledFuture abstractScheduledFuture = this;
                synchronized (abstractScheduledFuture) {
                    switch (this.state) {
                        case 0: {
                            this.state = 3;
                            break;
                        }
                        case 1: {
                            return;
                        }
                        case 6: 
                        case 7: {
                            return;
                        }
                        default: {
                            this.fail(this.badState());
                            return;
                        }
                    }
                }
                try {
                    int result = EnhancedQueueExecutor.this.tryExecute(this.wrappingTask);
                    boolean ok = false;
                    if (result == 0) {
                        if (EnhancedQueueExecutor.currentSizeOf(EnhancedQueueExecutor.this.getThreadStatus()) == 0 && EnhancedQueueExecutor.this.tryAllocateThread(0.0f) == 0 && !EnhancedQueueExecutor.this.doStartThread(null)) {
                            EnhancedQueueExecutor.this.deallocateThread();
                        }
                        if (UPDATE_STATISTICS) {
                            EnhancedQueueExecutor.this.submittedTaskCounter.increment();
                        }
                        return;
                    }
                    if (result == 3) {
                        try {
                            ok = EnhancedQueueExecutor.this.doStartThread(this.wrappingTask);
                            break block23;
                        }
                        finally {
                            if (!ok) {
                                EnhancedQueueExecutor.this.deallocateThread();
                            }
                        }
                    }
                    if (UPDATE_STATISTICS) {
                        EnhancedQueueExecutor.this.rejectedTaskCounter.increment();
                    }
                    if (result == 2) {
                        EnhancedQueueExecutor.this.rejectShutdown(this.wrappingTask);
                    } else {
                        assert (result == 1);
                        EnhancedQueueExecutor.this.rejectQueueFull(this.wrappingTask);
                    }
                }
                catch (RejectedExecutionException e) {
                    this.reject(e);
                }
                catch (Throwable t) {
                    this.reject(new RejectedExecutionException("Task submission failed", t));
                }
            }
        }

        IllegalStateException badState() {
            return new IllegalStateException("Task was not in expected state");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reject(RejectedExecutionException e) {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                switch (this.state) {
                    case 3: {
                        this.result = e;
                        this.state = 7;
                        this.liveThread = null;
                        this.notifyAll();
                        return;
                    }
                }
                this.fail(this.badState());
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fail(Throwable t) {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                switch (this.state) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.result = t;
                        this.state = 6;
                        this.liveThread = null;
                        this.notifyAll();
                        return;
                    }
                    case 1: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finish(V result) {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                this.liveThread = null;
                switch (this.state) {
                    case 2: 
                    case 4: {
                        this.result = result;
                        this.state = 5;
                        this.notifyAll();
                        return;
                    }
                }
                this.fail(this.badState());
                return;
            }
        }

        abstract V performTask() throws Exception;

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        StringBuilder toString(StringBuilder b) {
            return b.append("future result of ");
        }
    }

    final class CallableScheduledFuture<V>
    extends AbstractScheduledFuture<V> {
        Callable<V> callable;

        CallableScheduledFuture(Callable<V> callable, long delay, TimeUnit unit) {
            super(delay, unit);
            this.callable = callable;
        }

        @Override
        V performTask() throws Exception {
            try {
                V v = this.callable.call();
                return v;
            }
            finally {
                this.callable = null;
            }
        }

        @Override
        void doCancel() {
            this.callable = null;
        }

        @Override
        StringBuilder toString(StringBuilder b) {
            return super.toString(b).append(this.callable);
        }
    }

    final class FixedRateRunnableScheduledFuture
    extends RepeatingScheduledFuture<Void> {
        Runnable runnable;

        FixedRateRunnableScheduledFuture(Runnable runnable, long delay, long period, TimeUnit unit) {
            super(delay, period, unit);
            this.runnable = runnable;
        }

        @Override
        void adjustTime() {
            this.when += this.period;
        }

        @Override
        Void performTask() {
            this.runnable.run();
            return null;
        }

        @Override
        void doCancel() {
            this.runnable = null;
        }

        @Override
        StringBuilder toString(StringBuilder b) {
            return super.toString(b).append(this.runnable);
        }
    }

    final class FixedDelayRunnableScheduledFuture
    extends RepeatingScheduledFuture<Void> {
        Runnable runnable;

        FixedDelayRunnableScheduledFuture(Runnable runnable, long delay, long period, TimeUnit unit) {
            super(delay, period, unit);
            this.runnable = runnable;
        }

        @Override
        void adjustTime() {
            this.when = EnhancedQueueExecutor.this.schedulerTask.age() + this.period;
        }

        @Override
        Void performTask() {
            this.runnable.run();
            return null;
        }

        @Override
        void doCancel() {
            this.runnable = null;
        }

        @Override
        StringBuilder toString(StringBuilder b) {
            return super.toString(b).append(this.runnable);
        }
    }

    static final class PoolThreadNode
    extends PoolThreadNodeBase {
        private static final int STATE_NORMAL = 0;
        private static final int STATE_PARKED = 1;
        private static final int STATE_UNPARKED = 2;
        private static final VarHandle taskHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "task", VarHandle.class, PoolThreadNode.class, Runnable.class);
        private static final VarHandle parkedHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "parked", VarHandle.class, PoolThreadNode.class, Integer.TYPE);
        private final Thread thread;
        private volatile Runnable task;
        private volatile int parked;

        PoolThreadNode(Thread thread) {
            this.thread = thread;
            this.task = WAITING;
        }

        boolean compareAndSetTask(Runnable expect, Runnable update) {
            return this.task == expect && taskHandle.compareAndSet(this, expect, update);
        }

        Runnable getTask() {
            return this.task;
        }

        @Override
        PoolThreadNode getNext() {
            return (PoolThreadNode)super.getNext();
        }

        void park(EnhancedQueueExecutor enhancedQueueExecutor) {
            if (this.parked == 2 && parkedHandle.compareAndSet(this, 2, 0)) {
                return;
            }
            for (int spins = PARK_SPINS; spins > 0; --spins) {
                if (spins < YIELD_FACTOR) {
                    Thread.yield();
                    continue;
                }
                Thread.onSpinWait();
                if (this.parked != 2 || !parkedHandle.compareAndSet(this, 2, 0)) continue;
                return;
            }
            if (this.parked == 0 && parkedHandle.compareAndSet(this, 0, 1)) {
                try {
                    LockSupport.park(enhancedQueueExecutor);
                }
                finally {
                    this.parked = 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void park(EnhancedQueueExecutor enhancedQueueExecutor, long nanos) {
            long remaining;
            int spins = PARK_SPINS;
            if (spins > 0) {
                long start = System.nanoTime();
                if (this.parked == 2 && parkedHandle.compareAndSet(this, 2, 0)) {
                    return;
                }
                while (spins > 0) {
                    if (spins < YIELD_FACTOR) {
                        Thread.yield();
                    } else {
                        Thread.onSpinWait();
                    }
                    if (this.parked == 2 && parkedHandle.compareAndSet(this, 2, 0)) {
                        return;
                    }
                    --spins;
                }
                remaining = nanos - (System.nanoTime() - start);
                if (remaining < 0L) {
                    return;
                }
            } else {
                remaining = nanos;
            }
            if (this.parked == 0 && parkedHandle.compareAndSet(this, 0, 1)) {
                try {
                    LockSupport.parkNanos(enhancedQueueExecutor, remaining);
                }
                finally {
                    this.parked = 0;
                }
            }
        }

        void unpark() {
            if (this.parked == 0 && parkedHandle.compareAndSet(this, 0, 2)) {
                return;
            }
            LockSupport.unpark(this.thread);
        }
    }

    static final class TerminateWaiterNode
    extends QNode {
        TerminateWaiterNode() {
        }
    }

    final class ThreadBody
    implements Runnable {
        private Task initialTask;

        ThreadBody(Task initialTask) {
            this.initialTask = initialTask;
        }

        @Override
        public void run() {
            EnhancedQueueExecutor.this.runningThreads.add(Thread.currentThread());
            Task initial = this.initialTask;
            if (initial != null) {
                this.initialTask = null;
                initial.run();
            }
            EnhancedQueueExecutor.this.runThreadBody();
        }
    }

    static class MBeanUnregisterAction
    implements PrivilegedAction<Void> {
        private final Object handle;

        static void forceInit() {
        }

        MBeanUnregisterAction(Object handle) {
            this.handle = handle;
        }

        @Override
        public Void run() {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(((ObjectInstance)this.handle).getObjectName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    static final class QueueFullException
    extends RuntimeException {
        QueueFullException() {
            super(null, null, false, false);
        }
    }

    static class TreeSetQueue
    extends TreeSet<AbstractScheduledFuture<?>>
    implements ScheduledFutureQueue {
        TreeSetQueue(ScheduledFutureQueue original) {
            Collections.addAll(this, original.toArray());
        }

        TreeSetQueue() {
        }

        @Override
        public AbstractScheduledFuture<?>[] toArray() {
            return super.toArray(NO_FUTURES);
        }

        @Override
        public boolean insertAndCheckForFirst(AbstractScheduledFuture<?> item) {
            this.add(item);
            return item == this.first();
        }

        @Override
        public ScheduledFutureQueue grow() {
            return this;
        }
    }

    static final class ArrayQueue
    implements ScheduledFutureQueue {
        final AbstractScheduledFuture<?>[] array;
        int head;
        int size;

        ArrayQueue(int capacity) {
            capacity = Integer.highestOneBit(Math.max(capacity, 2) - 1) << 1;
            this.array = new AbstractScheduledFuture[capacity];
        }

        private ArrayQueue(ArrayQueue original, int newCapacity) {
            assert (Integer.bitCount(newCapacity) == 1);
            this.array = original.toArray(newCapacity);
            this.head = 0;
            this.size = original.size;
        }

        @Override
        public AbstractScheduledFuture<?>[] toArray() {
            return this.toArray(this.size());
        }

        public AbstractScheduledFuture<?>[] toArray(int size) {
            int head = this.head;
            int end = head + size;
            AbstractScheduledFuture<?>[] copy = Arrays.copyOfRange(this.array, head, end);
            if (end > this.array.length) {
                System.arraycopy(this.array, 0, copy, size - (this.array.length - head), size - this.array.length);
            }
            return copy;
        }

        @Override
        public void clear() {
            Arrays.fill(this.array, null);
            this.size = 0;
            this.head = 0;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public AbstractScheduledFuture<?> first() {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            return this.array[this.head];
        }

        @Override
        public AbstractScheduledFuture<?> pollFirst() {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            int head = this.head;
            AbstractScheduledFuture<?> item = this.array[head];
            this.array[head] = null;
            --this.size;
            int mask = this.array.length - 1;
            this.head = head + 1 & mask;
            return item;
        }

        @Override
        public boolean insertAndCheckForFirst(AbstractScheduledFuture<?> item) {
            int size = this.size;
            AbstractScheduledFuture<?>[] array = this.array;
            int arrayLen = array.length;
            if (size == arrayLen) {
                throw new QueueFullException();
            }
            int mask = arrayLen - 1;
            int idx = 0;
            int high = size - 1;
            int head = this.head;
            while (idx <= high) {
                int mid = idx + high >>> 1;
                AbstractScheduledFuture<?> testVal = array[head + mid & mask];
                int cmp = testVal.compareTo(item);
                if (cmp < 0) {
                    idx = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return false;
            }
            return this.insertAt(idx, item);
        }

        void moveForward(int idx, AbstractScheduledFuture<?> storeVal) {
            AbstractScheduledFuture<?>[] array = this.array;
            int size = this.size;
            int moveCnt = size - idx;
            int arrayLength = array.length;
            int mask = arrayLength - 1;
            int head = this.head;
            int start = head + idx;
            for (int i = moveCnt - 1; i >= 0; --i) {
                int pos = start + i;
                array[pos + 1 & mask] = array[pos & mask];
            }
            array[start & mask] = storeVal;
        }

        void moveBackward(int idx, AbstractScheduledFuture<?> storeVal) {
            AbstractScheduledFuture<?>[] array = this.array;
            int size = this.size;
            int moveCnt = size - idx + 1;
            int arrayLength = array.length;
            int mask = arrayLength - 1;
            int head = this.head;
            int start = head + idx - 1;
            for (int i = moveCnt - 1; i >= 0; --i) {
                int pos = start - i;
                array[pos - 1 & mask] = array[pos & mask];
            }
            array[start & mask] = storeVal;
            this.head = head - 1 & mask;
        }

        boolean insertAt(int idx, AbstractScheduledFuture<?> item) {
            int size = this.size;
            this.size = size + 1;
            int halfSize = size + 1 >> 1;
            if (idx >= halfSize) {
                this.moveForward(idx, item);
            } else {
                this.moveBackward(idx, item);
            }
            return idx == 0;
        }

        @Override
        public ScheduledFutureQueue grow() {
            if (this.array.length >= 256) {
                return new TreeSetQueue(this);
            }
            return new ArrayQueue(this, this.array.length << 1);
        }

        int testPoint_arrayLength() {
            return this.array.length;
        }

        int testPoint_head() {
            return this.head;
        }

        void testPoint_setHead(int newHead) {
            this.head = newHead;
        }

        void testPoint_setSize(int newSize) {
            this.size = newSize;
        }

        AbstractScheduledFuture<?> testPoint_getArrayItem(int index) {
            return this.array[index & this.array.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractScheduledFuture<?> testPoint_setArrayItem(int index, AbstractScheduledFuture<?> item) {
            try {
                AbstractScheduledFuture<?> abstractScheduledFuture = this.array[index & this.array.length - 1];
                return abstractScheduledFuture;
            }
            finally {
                this.array[index & this.array.length - 1] = item;
            }
        }
    }

    static interface ScheduledFutureQueue {
        public AbstractScheduledFuture<?>[] toArray();

        public void clear();

        public boolean isEmpty();

        public int size();

        public AbstractScheduledFuture<?> first();

        public AbstractScheduledFuture<?> pollFirst();

        public boolean insertAndCheckForFirst(AbstractScheduledFuture<?> var1) throws QueueFullException;

        public ScheduledFutureQueue grow();
    }

    abstract class RepeatingScheduledFuture<V>
    extends AbstractScheduledFuture<V> {
        final long period;

        RepeatingScheduledFuture(long delay, long period, TimeUnit unit) {
            super(delay, unit);
            this.period = unit.toNanos(period);
        }

        abstract void adjustTime();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void finish(V result) {
            RepeatingScheduledFuture repeatingScheduledFuture = this;
            synchronized (repeatingScheduledFuture) {
                this.liveThread = null;
                switch (this.state) {
                    case 2: {
                        this.state = 1;
                        this.notifyAll();
                        return;
                    }
                    case 4: {
                        this.adjustTime();
                        this.state = 0;
                        EnhancedQueueExecutor.this.schedulerTask.schedule(this);
                        return;
                    }
                }
                this.fail(this.badState());
                return;
            }
        }

        @Override
        StringBuilder toString(StringBuilder b) {
            return super.toString(b.append("repeating "));
        }
    }

    static abstract class PoolThreadNodeBase
    extends QNode {
        int p00;
        int p01;
        int p02;
        int p03;
        int p04;
        int p05;
        int p06;
        int p07;
        int p08;
        int p09;
        int p0A;
        int p0B;
        int p0C;
        int p0D;
        int p0E;
        int p0F;

        PoolThreadNodeBase() {
        }
    }
}

