/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Average
implements Streamable {
    protected long[] samples;
    protected TimeUnit unit;
    protected volatile boolean all_filled;
    protected static final int DEFAULT_CAPACITY = 512;

    public Average() {
        this(512);
    }

    public Average(int capacity) {
        this.samples = new long[capacity];
        Arrays.fill(this.samples, -1L);
    }

    public int capacity() {
        return this.samples.length;
    }

    public TimeUnit unit() {
        return this.unit;
    }

    public <T extends Average> T unit(TimeUnit u) {
        this.unit = u;
        return (T)this;
    }

    public double getAverage() {
        return this.average();
    }

    public <T extends Average> T add(long num) {
        if (num < 0L) {
            return (T)this;
        }
        int idx = Util.random(this.samples.length) - 1;
        this.samples[idx] = num;
        return (T)this;
    }

    public <T extends Average> T merge(T other) {
        if (other == null) {
            return (T)this;
        }
        for (int i = 0; i < other.samples.length; ++i) {
            this.add(other.samples[i]);
        }
        return (T)this;
    }

    public long total() {
        long ret = 0L;
        for (int i = 0; i < this.samples.length; ++i) {
            long sample = this.samples[i];
            if (sample < 0L) continue;
            ret += sample;
        }
        return ret;
    }

    public int count() {
        if (this.all_filled) {
            return this.samples.length;
        }
        int ret = 0;
        for (int i = 0; i < this.samples.length; ++i) {
            if (this.samples[i] < 0L) continue;
            ++ret;
        }
        if (ret >= this.samples.length) {
            this.all_filled = true;
        }
        return ret;
    }

    public boolean isEmpty() {
        if (this.all_filled) {
            return false;
        }
        for (int i = 0; i < this.samples.length; ++i) {
            if (this.samples[i] < 0L) continue;
            return false;
        }
        return true;
    }

    public double average() {
        int count = 0;
        long total = 0L;
        for (int i = 0; i < this.samples.length; ++i) {
            long sample = this.samples[i];
            if (sample < 0L) continue;
            ++count;
            total += sample;
        }
        if (count == 0) {
            return 0.0;
        }
        return (double)total / (double)count;
    }

    public void clear() {
        Arrays.fill(this.samples, -1L);
        this.all_filled = false;
    }

    public String toString() {
        return this.unit != null ? this.toString(this.unit) : String.format("%,.2f %s", this.average(), this.unit == null ? "" : Util.suffix(this.unit));
    }

    public String toString(TimeUnit u) {
        if (this.count() == 0) {
            return "n/a";
        }
        return String.format("%s", Util.printTime(this.average(), u));
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.samples.length);
        for (int i = 0; i < this.samples.length; ++i) {
            Bits.writeLongCompressed(this.samples[i], out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        int len = in.readInt();
        this.samples = new long[len];
        for (int i = 0; i < this.samples.length; ++i) {
            this.samples[i] = Bits.readLongCompressed(in);
        }
    }
}

