/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import org.wildfly.httpclient.common.ContentType;

public final class HeadersHelper {
    private HeadersHelper() {
    }

    public static void addRequestHeader(ClientRequest request, HttpString headerName, String headerValue) {
        if (request == null || headerName == null) {
            return;
        }
        request.getRequestHeaders().add(headerName, headerValue);
    }

    public static boolean containsRequestHeader(ClientRequest request, HttpString headerName) {
        if (request == null || headerName == null) {
            throw new IllegalArgumentException();
        }
        return request.getRequestHeaders().contains(headerName);
    }

    public static String getRequestHeader(ClientRequest request, HttpString headerName) {
        if (request == null || headerName == null) {
            throw new IllegalArgumentException();
        }
        return request.getRequestHeaders().getFirst(headerName);
    }

    public static String getResponseHeader(ClientResponse response, HttpString headerName) {
        if (response == null || headerName == null) {
            throw new IllegalArgumentException();
        }
        return response.getResponseHeaders().getFirst(headerName);
    }

    public static HeaderValues getResponseHeaders(ClientResponse response, HttpString headerName) {
        if (response == null || headerName == null) {
            throw new IllegalArgumentException();
        }
        return response.getResponseHeaders().get(headerName);
    }

    public static void putRequestHeader(ClientRequest request, HttpString headerName, ContentType headerValue) {
        if (request == null || headerName == null || headerValue == null) {
            throw new IllegalArgumentException();
        }
        request.getRequestHeaders().put(headerName, headerValue.toString());
    }

    public static void putRequestHeader(ClientRequest request, HttpString headerName, HttpString headerValue) {
        if (request == null || headerName == null || headerValue == null) {
            throw new IllegalArgumentException();
        }
        request.getRequestHeaders().put(headerName, headerValue.toString());
    }

    public static void putRequestHeader(ClientRequest request, HttpString headerName, String headerValue) {
        if (request == null || headerName == null || headerValue == null) {
            throw new IllegalArgumentException();
        }
        request.getRequestHeaders().put(headerName, headerValue);
    }

    public static void addResponseHeader(HttpServerExchange exchange, HttpString headerName, String headerValue) {
        if (exchange == null || headerName == null || headerValue == null) {
            throw new IllegalArgumentException();
        }
        exchange.getResponseHeaders().add(headerName, headerValue);
    }

    public static String getRequestHeader(HttpServerExchange exchange, HttpString headerName) {
        if (exchange == null || headerName == null) {
            throw new IllegalArgumentException();
        }
        return exchange.getRequestHeaders().getFirst(headerName);
    }

    public static void putResponseHeader(HttpServerExchange exchange, HttpString headerName, String headerValue) {
        if (exchange == null || headerName == null || headerValue == null) {
            throw new IllegalArgumentException();
        }
        exchange.getResponseHeaders().put(headerName, headerValue);
    }

    public static void putResponseHeader(HttpServerExchange exchange, HttpString headerName, ContentType headerValue) {
        if (exchange == null || headerName == null || headerValue == null) {
            throw new IllegalArgumentException();
        }
        exchange.getResponseHeaders().put(headerName, headerValue.toString());
    }
}

