/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChecksumType {
    COMPOSITE("COMPOSITE"),
    FULL_OBJECT("FULL_OBJECT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChecksumType> VALUE_MAP;
    private final String value;

    private ChecksumType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChecksumType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChecksumType> knownValues() {
        EnumSet<ChecksumType> knownValues = EnumSet.allOf(ChecksumType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChecksumType.class, ChecksumType::toString);
    }
}

