/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.x500.cert.acme.CertificateAuthority;

class CertificateAuthorityDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING, false).setValidator((ParameterValidator)new URLValidator(false))).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition STAGING_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("staging-url", ModelType.STRING, true).setValidator((ParameterValidator)new URLValidator(false))).setAllowExpression(true)).setRestartAllServices()).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{URL, STAGING_URL};
    private static final AbstractAddStepHandler ADD = new CertificateAuthorityAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.CERTIFICATE_AUTHORITY_RUNTIME_CAPABILITY);

    CertificateAuthorityDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"certificate-authority"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("certificate-authority")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.CERTIFICATE_AUTHORITY_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, ElytronReloadRequiredWriteAttributeHandler.INSTANCE);
        }
    }

    static Service<CertificateAuthority> getCertificateAuthorityService(ServiceRegistry serviceRegistry, String certificateAuthorityName) {
        RuntimeCapability runtimeCapability = Capabilities.CERTIFICATE_AUTHORITY_RUNTIME_CAPABILITY.fromBaseCapability(certificateAuthorityName);
        ServiceName serviceName = runtimeCapability.getCapabilityServiceName();
        ServiceController<CertificateAuthority> serviceContainer = ElytronExtension.getRequiredService(serviceRegistry, serviceName, CertificateAuthority.class);
        return serviceContainer.getService();
    }

    private static class URLValidator
    extends StringLengthValidator {
        private URLValidator(boolean nullable) {
            super(1, nullable, false);
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            String url = value.asString();
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidURL(url, e);
            }
        }
    }

    private static class CertificateAuthorityAddHandler
    extends BaseAddHandler {
        private CertificateAuthorityAddHandler() {
            super(Capabilities.CERTIFICATE_AUTHORITY_RUNTIME_CAPABILITY);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String certificateAuthorityName = context.getCurrentAddressValue();
            if (certificateAuthorityName.equalsIgnoreCase(CertificateAuthority.LETS_ENCRYPT.getName())) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.letsEncryptNameNotAllowed();
            }
            ElytronDefinition.commonRequirements(this.installService(context, model)).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        ServiceBuilder<CertificateAuthority> installService(OperationContext context, ModelNode model) {
            ServiceTarget serviceTarget = context.getServiceTarget();
            TrivialService<CertificateAuthority> certificateAuthorityTrivialService = new TrivialService<CertificateAuthority>(this.getValueSupplier(context, model));
            return serviceTarget.addService(Capabilities.CERTIFICATE_AUTHORITY_RUNTIME_CAPABILITY.getCapabilityServiceName(new String[]{context.getCurrentAddressValue()}), certificateAuthorityTrivialService);
        }

        protected TrivialService.ValueSupplier<CertificateAuthority> getValueSupplier(OperationContext context, ModelNode model) {
            return () -> {
                String certificateAuthorityResourceName = context.getCurrentAddress().getLastElement().getValue();
                return new CertificateAuthority(certificateAuthorityResourceName, model.get("url").asString(), model.get("staging-url").asStringOrNull());
            };
        }
    }
}

