/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.EnumSet;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.session.cache.affinity.NarySessionAffinityConfiguration;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.extension.clustering.web.AffinityResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.web.AffinityResourceRegistration;
import org.wildfly.extension.clustering.web.routing.infinispan.RankedRouteLocatorProvider;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.resource.AttributeDefinitionProvider;
import org.wildfly.subsystem.resource.ResourceDescriptor;

public class RankedAffinityResourceDefinitionRegistrar
extends AffinityResourceDefinitionRegistrar {
    RankedAffinityResourceDefinitionRegistrar() {
        super((ResourceRegistration)AffinityResourceRegistration.RANKED, (NullaryServiceDescriptor<RoutingProvider>)RoutingProvider.INFINISPAN_SERVICE_DESCRIPTOR);
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).provideAttributes(EnumSet.allOf(Attribute.class));
    }

    public Supplier<RouteLocatorProvider> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final String delimiter = Attribute.DELIMITER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final int maxRoutes = Attribute.MAX_ROUTES.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        return new Supplier<RouteLocatorProvider>(){

            @Override
            public RouteLocatorProvider get() {
                return new RankedRouteLocatorProvider(new NarySessionAffinityConfiguration(){

                    public int getMaxMembers() {
                        return maxRoutes;
                    }

                    public String getDelimiter() {
                        return delimiter;
                    }
                });
            }
        };
    }

    static enum Attribute implements AttributeDefinitionProvider
    {
        DELIMITER("delimiter", ModelType.STRING, new ModelNode(".")),
        MAX_ROUTES("max-routes", ModelType.STRING, new ModelNode(3));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(false)).setDefaultValue(defaultValue)).setRequired(false)).build();
        }

        public AttributeDefinition get() {
            return this.definition;
        }
    }
}

