/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.deployment;

import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.deployers.deployment.AbstractDeploymentModelBuilder;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointType;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointMetaData;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointsMetaData;

final class DeploymentModelBuilderJAXWS_JMS
extends AbstractDeploymentModelBuilder {
    DeploymentModelBuilderJAXWS_JMS() {
        super(EndpointType.JAXWS_JSE);
    }

    @Override
    protected void build(Deployment dep, DeploymentUnit unit) {
        JMSEndpointsMetaData jmsEndpointsMD = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.JMS_ENDPOINT_METADATA_KEY);
        dep.addAttachment(JMSEndpointsMetaData.class, (Object)jmsEndpointsMD);
        WSLogger.ROOT_LOGGER.trace("Creating JAXWS Jakarta Messaging endpoints meta data model");
        for (JMSEndpointMetaData jmsEndpoint : jmsEndpointsMD.getEndpointsMetaData()) {
            String jmsEndpointName = jmsEndpoint.getName();
            WSLogger.ROOT_LOGGER.tracef("Jakarta Messaging name: %s", jmsEndpointName);
            String jmsEndpointClassName = jmsEndpoint.getImplementor();
            WSLogger.ROOT_LOGGER.tracef("Jakarta Messaging class: %s", jmsEndpointClassName);
            String jmsEndpointAddress = jmsEndpoint.getSoapAddress();
            WSLogger.ROOT_LOGGER.tracef("Jakarta Messaging address: %s", jmsEndpointAddress);
            Endpoint ep = this.newJMSEndpoint(jmsEndpointClassName, jmsEndpointName, jmsEndpointAddress, dep);
            this.markWeldDeployment(unit, ep);
        }
    }
}

