/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.deployment;

import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceController;
import org.wildfly.clustering.singleton.service.ServiceTargetFactory;
import org.wildfly.extension.clustering.singleton.SingletonLogger;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentServiceTargetTransformer;

public class SingletonDeploymentProcessor
implements DeploymentUnitProcessor,
LifecycleListener {
    static final AttachmentKey<ServiceTargetFactory> SERVICE_TARGET_FACTORY_KEY = AttachmentKey.create(ServiceTargetFactory.class);

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        CapabilityServiceSupport support;
        ServiceTargetFactory factory;
        DeploymentUnit unit = context.getDeploymentUnit();
        if (unit.getParent() == null && (factory = (ServiceTargetFactory)context.getAttachment(SERVICE_TARGET_FACTORY_KEY)) != null && unit.putAttachment(Attachments.DEPLOYMENT_UNIT_PHASE_SERVICE_TARGET_TRANSFORMER, (Object)new SingletonDeploymentServiceTargetTransformer(support = (CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT), factory)) == null) {
            SingletonLogger.ROOT_LOGGER.singletonDeploymentDetected(factory);
            ServiceController controller = context.getServiceRegistry().getRequiredService(unit.getServiceName());
            controller.addListener((LifecycleListener)this);
            controller.setMode(ServiceController.Mode.NEVER);
        }
    }

    public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
        if (event == LifecycleEvent.DOWN) {
            controller.setMode(ServiceController.Mode.ACTIVE);
            controller.removeListener((LifecycleListener)this);
        }
    }
}

