/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.remote.CompletedFuture;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public class BlockingQueueOperationListener<T extends TransactionalProtocolClient.Operation>
implements TransactionalProtocolClient.TransactionalOperationListener<T> {
    private final BlockingQueue<TransactionalProtocolClient.PreparedOperation<T>> queue;

    public BlockingQueueOperationListener() {
        this(new LinkedBlockingQueue<TransactionalProtocolClient.PreparedOperation<T>>());
    }

    public BlockingQueueOperationListener(int capacity) {
        this(new ArrayBlockingQueue<TransactionalProtocolClient.PreparedOperation<T>>(capacity));
    }

    public BlockingQueueOperationListener(BlockingQueue<TransactionalProtocolClient.PreparedOperation<T>> queue) {
        this.queue = queue;
    }

    @Override
    public void operationPrepared(TransactionalProtocolClient.PreparedOperation<T> prepared) {
        ControllerLogger.MGMT_OP_LOGGER.tracef("received prepared operation  %s", prepared);
        if (!this.queue.offer(prepared)) {
            prepared.rollback();
        }
    }

    @Override
    public void operationFailed(T operation, ModelNode result) {
        ControllerLogger.MGMT_OP_LOGGER.tracef("received failed operation  %s", operation);
        this.queue.offer(new FailedOperation<T>(operation, result));
    }

    @Override
    public void operationComplete(T operation, OperationResponse result) {
    }

    public TransactionalProtocolClient.PreparedOperation<T> retrievePreparedOperation() throws InterruptedException {
        return this.queue.take();
    }

    protected void drainTo(Collection<TransactionalProtocolClient.PreparedOperation<T>> collection) {
        if (!this.queue.isEmpty()) {
            this.queue.drainTo(collection);
        }
    }

    public TransactionalProtocolClient.PreparedOperation<T> retrievePreparedOperation(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.queue.poll(timeout, timeUnit);
    }

    public static class FailedOperation<T extends TransactionalProtocolClient.Operation>
    implements TransactionalProtocolClient.PreparedOperation<T> {
        private final T operation;
        private final ModelNode finalResult;
        private final boolean timedOut;

        public static <T extends TransactionalProtocolClient.Operation> TransactionalProtocolClient.PreparedOperation<T> create(T operation, Throwable t) {
            String failureDescription = t.getLocalizedMessage() == null ? t.getClass().getName() : t.getLocalizedMessage();
            return FailedOperation.create(operation, failureDescription);
        }

        public static <T extends TransactionalProtocolClient.Operation> TransactionalProtocolClient.PreparedOperation<T> create(T operation, String failureDescription) {
            ModelNode failedResult = new ModelNode();
            failedResult.get("outcome").set("failed");
            failedResult.get("failure-description").set(failureDescription);
            return new FailedOperation<T>(operation, failedResult, false);
        }

        private static boolean isTimeoutFailureDescription(ModelNode response) {
            boolean result = response.hasDefined("failure-description");
            if (result) {
                result = response.get("failure-description").asString().startsWith("WFLYCTL0409");
            }
            return result;
        }

        public FailedOperation(T operation, ModelNode finalResult) {
            this(operation, finalResult, FailedOperation.isTimeoutFailureDescription(finalResult));
        }

        public FailedOperation(T operation, ModelNode finalResult, boolean timedOut) {
            this.operation = operation;
            this.finalResult = finalResult;
            this.timedOut = timedOut;
        }

        @Override
        public T getOperation() {
            return this.operation;
        }

        @Override
        public ModelNode getPreparedResult() {
            return this.finalResult;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public boolean isFailed() {
            return true;
        }

        @Override
        public boolean isTimedOut() {
            return this.timedOut;
        }

        @Override
        public AsyncFuture<OperationResponse> getFinalResult() {
            return new CompletedFuture<OperationResponse>(OperationResponse.Factory.createSimple((ModelNode)this.finalResult));
        }

        @Override
        public void commit() {
            throw new IllegalStateException();
        }

        @Override
        public void rollback() {
            throw new IllegalStateException();
        }
    }

    public static class SucceededOperation<T extends TransactionalProtocolClient.Operation>
    implements TransactionalProtocolClient.PreparedOperation<T> {
        private final T operation;
        private final ModelNode finalResult;

        public static <T extends TransactionalProtocolClient.Operation> TransactionalProtocolClient.PreparedOperation<T> create(T operation) {
            ModelNode succeededResult = new ModelNode();
            succeededResult.get("outcome").set("success");
            succeededResult.get("result");
            return new SucceededOperation<T>(operation, succeededResult);
        }

        public SucceededOperation(T operation, ModelNode finalResult) {
            this.operation = operation;
            this.finalResult = finalResult;
        }

        @Override
        public T getOperation() {
            return this.operation;
        }

        @Override
        public ModelNode getPreparedResult() {
            return this.finalResult;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public boolean isFailed() {
            return false;
        }

        @Override
        public boolean isTimedOut() {
            return false;
        }

        @Override
        public AsyncFuture<OperationResponse> getFinalResult() {
            return new CompletedFuture<OperationResponse>(OperationResponse.Factory.createSimple((ModelNode)this.finalResult));
        }

        @Override
        public void commit() {
            throw new IllegalStateException();
        }

        @Override
        public void rollback() {
            throw new IllegalStateException();
        }
    }
}

