/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.registry;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.local.LocalGroup;
import org.wildfly.clustering.server.local.LocalGroupMember;
import org.wildfly.clustering.server.registry.Registry;
import org.wildfly.clustering.server.registry.RegistryListener;

public interface LocalRegistry<K, V>
extends Registry<LocalGroupMember, K, V> {
    public LocalGroup getGroup();

    public static <K, V> LocalRegistry<K, V> of(final LocalGroup group, final Map.Entry<K, V> entry, final Runnable closeTask) {
        final Map<K, V> entries = Collections.singletonMap(entry.getKey(), entry.getValue());
        final AtomicBoolean closed = new AtomicBoolean(false);
        return new LocalRegistry<K, V>(){

            @Override
            public LocalGroup getGroup() {
                return group;
            }

            public Registration register(RegistryListener<K, V> object) {
                return Registration.EMPTY;
            }

            public Map<K, V> getEntries() {
                return !closed.get() ? entries : Map.of();
            }

            public Map.Entry<K, V> getEntry(LocalGroupMember member) {
                return !closed.get() && ((LocalGroupMember)group.getLocalMember()).equals(member) ? entry : null;
            }

            public void close() {
                if (closed.compareAndSet(false, true)) {
                    closeTask.run();
                }
            }
        };
    }
}

