/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.dmr.ModelNode;

public class DelegatingModelControllerClient
implements ModelControllerClient {
    private final DelegateProvider provider;

    public DelegatingModelControllerClient(final ModelControllerClient delegate) {
        this(new DelegateProvider(){

            @Override
            public ModelControllerClient getDelegate() {
                if (delegate == null) {
                    throw new IllegalStateException("The client has been closed");
                }
                return delegate;
            }
        });
    }

    public DelegatingModelControllerClient(DelegateProvider provider) {
        this.provider = provider;
    }

    @Override
    public ModelNode execute(ModelNode operation) throws IOException {
        return this.provider.getDelegate().execute(operation);
    }

    @Override
    public ModelNode execute(Operation operation) throws IOException {
        return this.provider.getDelegate().execute(operation);
    }

    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return this.provider.getDelegate().execute(operation, messageHandler);
    }

    @Override
    public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.provider.getDelegate().execute(operation, messageHandler);
    }

    @Override
    public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.provider.getDelegate().executeOperation(operation, messageHandler);
    }

    @Override
    public CompletableFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        return this.provider.getDelegate().executeAsync(operation, messageHandler);
    }

    @Override
    public CompletableFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
        return this.provider.getDelegate().executeAsync(operation, messageHandler);
    }

    @Override
    public CompletableFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
        return this.provider.getDelegate().executeOperationAsync(operation, messageHandler);
    }

    @Override
    public void close() throws IOException {
        try {
            this.provider.getDelegate().close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static interface DelegateProvider {
        public ModelControllerClient getDelegate() throws IllegalStateException;
    }
}

